/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.listeners;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinRemovalListener
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(PinRemovalListener.class);
    protected static final String PROP_ENABLED = "enabled";
    protected static final String PROP_LDAP = "ldap";
    protected static final String PROP_BASEDN = "ldap.basedn";
    protected static final String PROP_PINATTR = "pinAttr";
    protected String mName = null;
    protected String mImplName = null;
    protected String mBaseDN = null;
    protected String mPinAttr = null;
    private boolean mEnabled = false;
    private ConfigStore mConfig;
    private LDAPConfig mLdapConfig;
    private LdapBoundConnFactory mConnFactory;
    private LDAPConnection mRemovePinLdapConnection = null;
    protected String[] configParams = new String[]{"a"};

    public String getName() {
        return this.mName;
    }

    public String getImplName() {
        return this.mImplName;
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void shutdown() {
    }

    public String[] getConfigParams() throws EBaseException {
        return this.configParams;
    }

    @Override
    public void init(Subsystem sub, ConfigStore config) throws EBaseException {
        this.init(null, null, config);
    }

    public void init(String name, String ImplName, ConfigStore config) throws EBaseException {
        EngineConfig cs = this.engine.getConfig();
        this.mName = name;
        this.mImplName = ImplName;
        this.mConfig = config;
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.mLdapConfig = this.mConfig.getSubStore(PROP_LDAP, LDAPConfig.class);
        this.mConnFactory = new LdapBoundConnFactory("PinRemovalListener");
        this.mConnFactory.setCMSEngine(this.engine);
        this.mConnFactory.init(socketConfig, this.mLdapConfig, this.engine.getPasswordStore());
        this.mRemovePinLdapConnection = this.mConnFactory.getConn();
        this.mEnabled = this.mConfig.getBoolean(PROP_ENABLED, false);
        this.mBaseDN = this.mConfig.getString(PROP_BASEDN, "");
        this.mPinAttr = this.mConfig.getString(PROP_PINATTR, "pin");
    }

    @Override
    public void accept(Request r) {
        if (!this.mEnabled) {
            return;
        }
        String rs = r.getRequestStatus().toString();
        logger.debug("PinRemovalListener: Request status: " + rs);
        if (!rs.equals("complete")) {
            logger.warn("PinRemovalListener: - request not complete - not removing pin");
            return;
        }
        String requestType = r.getRequestType();
        if (requestType.equals("enrollment") || requestType.equals("renewal")) {
            String uid = r.getExtDataInString("HTTP_PARAMS", "uid");
            if (uid == null) {
                logger.warn("PinRemovalListener: did not find UID parameter in this request");
                return;
            }
            String userdn = null;
            try {
                LDAPSearchResults res = this.mRemovePinLdapConnection.search(this.mBaseDN, 2, "(uid=" + uid + ")", null, false);
                if (!res.hasMoreElements()) {
                    logger.warn("PinRemovalListener: uid " + uid + " does not exist in the ldap server. Could not remove pin");
                    return;
                }
                LDAPEntry entry = (LDAPEntry)res.nextElement();
                userdn = entry.getDN();
                this.mRemovePinLdapConnection.modify(userdn, new LDAPModification(1, new LDAPAttribute(this.mPinAttr)));
                logger.info("PinRemovalListener: Removed pin for user \"" + userdn + "\"");
            }
            catch (LDAPException e) {
                logger.warn("PinRemovalListener: could not remove pin for " + userdn, (Throwable)e);
            }
        }
    }

    @Override
    public void set(String name, String val) {
    }
}

