/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.base.EBaseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class CMSFile {
    protected String mAbsPath;
    protected long mLastModified;
    protected byte[] mContent;
    protected long mLastAccess = 0L;

    protected CMSFile() {
    }

    public CMSFile(File file) throws IOException, EBaseException {
        this.mAbsPath = file.getAbsolutePath();
        this.mLastModified = file.lastModified();
        this.fillContent(file);
    }

    private void fillContent(File file) throws IOException {
        int actualSize;
        int fileSize = (int)file.length();
        this.mContent = new byte[fileSize];
        try (FileInputStream fileIn = new FileInputStream(file);){
            actualSize = ((InputStream)fileIn).read(this.mContent);
        }
        if (actualSize != fileSize) {
            byte[] actualContent = new byte[actualSize];
            System.arraycopy(this.mContent, 0, actualContent, 0, actualSize);
            this.mContent = actualContent;
        }
    }

    public String getAbsPath() {
        return this.mAbsPath;
    }

    public byte[] getContent() {
        return this.mContent;
    }

    public long getLastModified() {
        return this.mLastModified;
    }

    public synchronized long getLastAccess() {
        return this.mLastAccess;
    }

    public synchronized void setLastAccess(long lastAccess) {
        this.mLastAccess = lastAccess;
    }

    public String toString() {
        try {
            return new String(this.mContent, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.mContent);
        }
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.mContent, enc);
    }
}

