/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import java.util.Date;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;

public class KeyRecordParser {
    public static final String OUT_STATE = "state";
    public static final String OUT_OWNER_NAME = "ownerName";
    public static final String OUT_SERIALNO = "serialNumber";
    public static final String OUT_SERIALNO_IN_HEX = "serialNumberInHex";
    public static final String OUT_KEY_ALGORITHM = "keyAlgorithm";
    public static final String OUT_PUBLIC_KEY = "publicKey";
    public static final String OUT_KEY_LEN = "keyLength";
    public static final String OUT_KEY_EC_CURVE = "EllipticCurve";
    public static final String OUT_ARCHIVED_BY = "archivedBy";
    public static final String OUT_ARCHIVED_ON = "archivedOn";
    public static final String OUT_RECOVERED_BY = "recoveredBy";
    public static final String OUT_RECOVERED_ON = "recoveredOn";
    public static final String OUT_SK_TYPE = "sessionKeyType";
    public static final String OUT_SK_KEYGEN_ALGORITHM = "sessionKeyKeyGenAlgorithm";
    public static final String OUT_SK_LENGTH = "sessionKeyLength";
    public static final String OUT_SK_WRAP_ALGORITHM = "sessionKeyWrapAlgorithm";
    public static final String OUT_PL_WRAP_ALGORITHM = "payloadWrapAlgorithm";
    public static final String OUT_PL_WRAP_IV = "payloadWrapIV";
    public static final String OUT_PL_WRAP_IV_LEN = "payloadWrapIVLen";
    public static final String OUT_PL_ENCRYPTION_ALGORITHM = "payloadEncryptionAlgorithm";
    public static final String OUT_PL_ENCRYPTION_MODE = "payloadEncryptionMode";
    public static final String OUT_PL_ENCRYPTION_PADDING = "payloadEncryptionPadding";
    public static final String OUT_PL_ENCRYPTION_IV = "payloadEncryptionIV";
    public static final String OUT_PL_ENCRYPTION_IV_LEN = "payloadEncryptionIVLen";
    public static final String OUT_PL_ENCRYPTION_OID = "payloadEncryptionOID";
    public static final String OUT_PL_ENCRYPTED = "payloadEncrypted";

    public static void fillRecordIntoArg(KeyRecord rec, ArgBlock rarg) throws EBaseException {
        String curve;
        if (rec == null) {
            return;
        }
        rarg.addStringValue(OUT_STATE, rec.getState().toString());
        rarg.addStringValue(OUT_OWNER_NAME, rec.getOwnerName());
        rarg.addBigIntegerValue(OUT_SERIALNO, rec.getSerialNumber(), 10);
        rarg.addBigIntegerValue(OUT_SERIALNO_IN_HEX, rec.getSerialNumber(), 16);
        rarg.addStringValue(OUT_KEY_ALGORITHM, rec.getAlgorithm());
        PrettyPrintFormat pp = new PrettyPrintFormat(":");
        rarg.addStringValue(OUT_PUBLIC_KEY, pp.toHexString(rec.getPublicKeyData(), 0, 20));
        Integer keySize = rec.getKeySize();
        if (keySize == null) {
            rarg.addIntegerValue(OUT_KEY_LEN, 512);
        } else {
            rarg.addIntegerValue(OUT_KEY_LEN, keySize);
        }
        MetaInfo metaInfo = rec.getMetaInfo();
        if (metaInfo != null && (curve = (String)metaInfo.get(OUT_KEY_EC_CURVE)) != null) {
            rarg.addStringValue(OUT_KEY_EC_CURVE, curve);
        }
        rarg.addStringValue(OUT_ARCHIVED_BY, rec.getArchivedBy());
        rarg.addLongValue(OUT_ARCHIVED_ON, rec.getCreateTime().getTime() / 1000L);
        Date[] dateOfRevocation = rec.getDateOfRevocation();
        if (dateOfRevocation != null) {
            rarg.addStringValue(OUT_RECOVERED_BY, "null");
            rarg.addStringValue(OUT_RECOVERED_ON, "null");
        }
    }
}

