# Makefile.am.inc
# Include file with common automake definitions for plugins
#
# Wireshark - Network traffic analyzer
# By Gerald Combs <gerald@wireshark.org>
# Copyright 1998 Gerald Combs
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

LIBS = @PLUGIN_LIBS@

PLUGIN_CPPFLAGS = $(INCLUDEDIRS) $(WS_CPPFLAGS) $(GLIB_CFLAGS) -DPLUGIN_VERSION=\"$(PLUGIN_VERSION)\"

PLUGIN_CFLAGS =

PLUGIN_LDFLAGS = -module -avoid-version

epan_plugindir = $(plugindir)/epan

wiretap_plugindir = $(plugindir)/wiretap

codecs_plugindir = $(plugindir)/codecs

#
# Source files are divided up along several axes:
#
# C vs. C++ - this is used on Windows to generated lists of object files
# with .c=.obj or .cpp=.obj
#
# Register vs. non-register - register files are scanned for registration
# functions, non-register files aren't.
#
# Flex-generated, Lemon-generated, and non-generated:
#
#	we distribute non-generated files, as they're part of the source,
#	and distribute Flex-generated files, as we don't require that
#	people have Flex installed and don't distribute it ourself and
#	thus can't guarantee that we can run Flex in the build process,
#	but we don't distribute Lemon-generated files, as we distribute
#	Lemon and can run it in the build process;
#
#	"make maintainer-clean" on UN*X remove all generated files;
#
#	"make distclean" on UN*X removes Lemon-generated files, as they're
#	not in the distribution, but not Flex-generated files, as they
#	are in the distribution;
#
#	"make distclean" on Windows removes both Lemon-generated and
#	Flex-generated files, as the Flex-generated files in the
#	distribution were generated by Flex on UN*X, and won't compile
#	on Windows;
#
#	Flex-generated files can't be built with full warnings
#	turned on, and can't be run through the checkAPI scripts,
#	as they generate code that won't pass (we've tweaked
#	Lemon to generate code that will pass).
#

#
# All source files to be scanned for registration routines.
#
REGISTER_SRC_FILES = \
	$(FLEX_GENERATED_REGISTER_C_FILES) \
	$(FLEX_GENERATED_REGISTER_CPP_FILES) \
	$(LEMON_GENERATED_REGISTER_C_FILES) \
	$(LEMON_GENERATED_REGISTER_CPP_FILES) \
	$(NONGENERATED_REGISTER_C_FILES) \
	$(NONGENERATED_REGISTER_CPP_FILES)

#
# All distributed source files.
#
SRC_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(FLEX_GENERATED_CPP_FILES) \
	$(NONGENERATED_C_FILES) \
	$(NONGENERATED_CPP_FILES)

#
# All non-distributed source files.
#
NODIST_SRC_FILES = \
	$(LEMON_GENERATED_C_FILES) \
	$(LEMON_GENERATED_CPP_FILES)

#
# All non-distributed header files.
#
NODIST_HEADER_FILES = \
	$(LEMON_GENERATED_HEADER_FILES)

#
# All Flex-generated source files.
#
FLEX_GENERATED_SRC_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(FLEX_GENERATED_CPP_FILES)

#
# All Lemon-generated source files.
#
LEMON_GENERATED_SRC_FILES = \
	$(LEMON_GENERATED_C_FILES) \
	$(LEMON_GENERATED_CPP_FILES)

#
# All generated source files.
#
GENERATED_SRC_FILES = \
	$(FLEX_GENERATED_SRC_FILES) \
	$(LEMON_GENERATED_SRC_FILES)

#
# All generated header files.
#
GENERATED_HEADER_FILES = \
	$(FLEX_GENERATED_HEADER_FILES) \
	$(LEMON_GENERATED_HEADER_FILES)

#
# All "clean" source files; they can be compiled with the regular
# warning options, including -Werror with GCC-compatible compilers,
# and can be run through checkAPI.  Neither Flex-generated nor
# Lemon-generated files can currently be guaranteed to be clean.
#
CLEAN_SRC_FILES = \
	$(NONGENERATED_C_FILES) \
	$(NONGENERATED_CPP_FILES)

# C source files
C_FILES = \
	$(FLEX_GENERATED_C_FILES) \
	$(LEMON_GENERATED_C_FILES) \
	$(NONGENERATED_C_FILES)

# C++ source files
CPP_FILES = \
	$(FLEX_GENERATED_CPP_FILES) \
	$(LEMON_GENERATED_CPP_FILES) \
	$(NONGENERATED_CPP_FILES)

checkapi:
	$(PERL) $(top_srcdir)/tools/checkAPIs.pl -g abort -g termoutput -build \
	-sourcedir=$(srcdir) \
	$(CLEAN_SRC_FILES) $(CLEAN_HEADER_FILES)
