// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple loongarch32 -emit-llvm %s -o - \
// RUN:     | FileCheck %s -check-prefix=LA32
// RUN: %clang_cc1 -triple loongarch64 -emit-llvm %s -o - \
// RUN:     | FileCheck %s -check-prefix=LA64

#include <larchintrin.h>

// LA32-LABEL: @dbar(
// LA32-NEXT:  entry:
// LA32-NEXT:    call void @llvm.loongarch.dbar(i32 0)
// LA32-NEXT:    ret void
//
// LA64-LABEL: @dbar(
// LA64-NEXT:  entry:
// LA64-NEXT:    call void @llvm.loongarch.dbar(i32 0)
// LA64-NEXT:    ret void
//
void dbar() {
  return __builtin_loongarch_dbar(0);
}

// LA32-LABEL: @ibar(
// LA32-NEXT:  entry:
// LA32-NEXT:    call void @llvm.loongarch.ibar(i32 0)
// LA32-NEXT:    ret void
//
// LA64-LABEL: @ibar(
// LA64-NEXT:  entry:
// LA64-NEXT:    call void @llvm.loongarch.ibar(i32 0)
// LA64-NEXT:    ret void
//
void ibar() {
  return __builtin_loongarch_ibar(0);
}

// LA32-LABEL: @loongarch_break(
// LA32-NEXT:  entry:
// LA32-NEXT:    call void @llvm.loongarch.break(i32 1)
// LA32-NEXT:    ret void
//
// LA64-LABEL: @loongarch_break(
// LA64-NEXT:  entry:
// LA64-NEXT:    call void @llvm.loongarch.break(i32 1)
// LA64-NEXT:    ret void
//
void loongarch_break() {
  __builtin_loongarch_break(1);
}

// LA32-LABEL: @syscall(
// LA32-NEXT:  entry:
// LA32-NEXT:    call void @llvm.loongarch.syscall(i32 1)
// LA32-NEXT:    ret void
//
// LA64-LABEL: @syscall(
// LA64-NEXT:  entry:
// LA64-NEXT:    call void @llvm.loongarch.syscall(i32 1)
// LA64-NEXT:    ret void
//
void syscall() {
  __builtin_loongarch_syscall(1);
}
