import React, { ButtonHTMLAttributes } from 'react';
import { IconName } from '../../types/icon';
import { GrafanaTheme } from '@grafana/data';
import { ComponentSize } from '../../types/size';
export declare type ButtonVariant = 'primary' | 'secondary' | 'destructive' | 'link';
declare type CommonProps = {
    size?: ComponentSize;
    variant?: ButtonVariant;
    icon?: IconName;
    className?: string;
    children?: React.ReactNode;
    fullWidth?: boolean;
};
export declare type ButtonProps = CommonProps & ButtonHTMLAttributes<HTMLButtonElement>;
export declare const Button: React.ForwardRefExoticComponent<CommonProps & React.ButtonHTMLAttributes<HTMLButtonElement> & React.RefAttributes<HTMLButtonElement>>;
export declare const LinkButton: React.ForwardRefExoticComponent<CommonProps & React.ButtonHTMLAttributes<HTMLButtonElement> & React.AnchorHTMLAttributes<HTMLAnchorElement> & React.RefAttributes<HTMLAnchorElement>>;
export interface StyleProps {
    size: ComponentSize;
    variant: ButtonVariant;
    children?: React.ReactNode;
    icon?: IconName;
    theme: GrafanaTheme;
    fullWidth?: boolean;
    narrow?: boolean;
}
export declare const getButtonStyles: (props: StyleProps) => {
    button: string;
    img: string;
    icon: string;
    content: string;
};
export declare function getPropertiesForVariant(theme: GrafanaTheme, variant: ButtonVariant): {
    borderColor: string;
    variantStyles: string;
};
export {};
