/// <reference types="react" />
import { PlotPlugin } from './types';
import { Options } from 'uplot';
import { UPlotConfigBuilder } from './config/UPlotConfigBuilder';
export declare const usePlotPlugins: () => {
    arePluginsReady: boolean;
    plugins: Record<string, PlotPlugin>;
    registerPlugin: (plugin: PlotPlugin) => () => void;
};
export declare const DEFAULT_PLOT_CONFIG: Partial<Options>;
export declare const usePlotConfig: (width: number, height: number, configBuilder: UPlotConfigBuilder) => {
    isConfigReady: boolean;
    registerPlugin: (plugin: PlotPlugin) => () => void;
    currentConfig: import("react").MutableRefObject<Options | undefined>;
};
/**
 * Forces re-render of a component when uPlots's draw hook is fired.
 * This hook is usefull in scenarios when you want to reposition XYCanvas elements when i.e. plot size changes
 * @param pluginId - id under which the plugin will be registered
 */
export declare const useRefreshAfterGraphRendered: (pluginId: string) => number;
export declare function useRevision<T>(dep?: T | null, cmp?: (prev?: T | null, next?: T | null) => boolean): number;
