import React from 'react';
import PropTypes from 'prop-types';

const UilCloudMoonMeatball = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M21.7,8a1,1,0,0,0-.94-.26,3,3,0,0,1-.65.08,3,3,0,0,1-3-3,3.05,3.05,0,0,1,.08-.66,1,1,0,0,0-.26-.94A1,1,0,0,0,16,2.94a5,5,0,0,0-3.83,4.22,5.86,5.86,0,0,0-1.67-.24A6,6,0,0,0,4.56,12,3.52,3.52,0,0,0,2,15.42a3.47,3.47,0,0,0,1.41,2.79A1,1,0,1,0,4.59,16.6,1.46,1.46,0,0,1,4,15.42a1.5,1.5,0,0,1,1.5-1.5,1,1,0,0,0,1-1,4,4,0,0,1,6.17-3.35l0,0a3.9,3.9,0,0,1,1.57,2,1,1,0,0,0,.78.66,2.33,2.33,0,0,1,.54,4.44,1,1,0,0,0-.52,1.32,1,1,0,0,0,.92.6,1,1,0,0,0,.4-.09,4.33,4.33,0,0,0,2.6-4,4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8.92,1,1,0,0,0,21.7,8Zm-4.59,2.82a2.72,2.72,0,0,1-.42,0,4.6,4.6,0,0,0-.72-.31,5.91,5.91,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.22A3,3,0,0,1,17.11,10.81ZM12.5,16.92h-.77l.39-.67a1,1,0,0,0-1.74-1l-.38.67-.38-.67a1,1,0,0,0-1.74,1l.39.67H7.5a1,1,0,0,0,0,2h.77l-.39.66a1,1,0,0,0,1.74,1l.38-.66.38.66a1,1,0,1,0,1.74-1l-.39-.66h.77a1,1,0,0,0,0-2Z'
  }));
};

UilCloudMoonMeatball.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilCloudMoonMeatball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilCloudMoonMeatball;