"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toBeInvalid = toBeInvalid;
exports.toBeValid = toBeValid;

var _jestMatcherUtils = require("jest-matcher-utils");

var _utils = require("./utils");

const FORM_TAGS = ['form', 'input', 'select', 'textarea'];

function isElementHavingAriaInvalid(element) {
  return element.hasAttribute('aria-invalid') && element.getAttribute('aria-invalid') !== 'false';
}

function isElementInvalid(element) {
  return !element.checkValidity();
}

function toBeInvalid(element) {
  (0, _utils.checkHtmlElement)(element, toBeInvalid, this);
  const isInvalid = isElementHavingAriaInvalid(element) || isElementInvalid(element);
  return {
    pass: isInvalid,
    message: () => {
      const is = isInvalid ? 'is' : 'is not';
      return [(0, _jestMatcherUtils.matcherHint)(`${this.isNot ? '.not' : ''}.toBeInvalid`, 'element', ''), '', `Received element ${is} currently invalid:`, `  ${(0, _jestMatcherUtils.printReceived)(element.cloneNode(false))}`].join('\n');
    }
  };
}

function toBeValid(element) {
  (0, _utils.checkHtmlElement)(element, toBeValid, this);
  const isValid = !isElementHavingAriaInvalid(element) && FORM_TAGS.includes((0, _utils.getTag)(element)) && !isElementInvalid(element);
  return {
    pass: isValid,
    message: () => {
      const is = isValid ? 'is' : 'is not';
      return [(0, _jestMatcherUtils.matcherHint)(`${this.isNot ? '.not' : ''}.toBeValid`, 'element', ''), '', `Received element ${is} currently valid:`, `  ${(0, _jestMatcherUtils.printReceived)(element.cloneNode(false))}`].join('\n');
    }
  };
}