"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginSignTask = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const pluginValidation_1 = require("../../config/utils/pluginValidation");
const manifest_1 = require("../../plugins/manifest");
const plugin_utils_1 = require("./plugin.utils");
const task_1 = require("./task");
const pluginSignRunner = ({ signatureType, rootUrls }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const distContentDir = path_1.default.resolve('dist');
    try {
        console.log('Building manifest...');
        const manifest = yield (0, manifest_1.buildManifest)(distContentDir);
        // console.log(manifest);
        console.log('Signing manifest...');
        if (signatureType) {
            manifest.signatureType = signatureType;
        }
        if (rootUrls && rootUrls.length > 0) {
            rootUrls.forEach(pluginValidation_1.assertRootUrlIsValid);
            manifest.rootUrls = rootUrls;
        }
        manifest.toolkit = { version: (0, plugin_utils_1.getToolkitVersion)() };
        const signedManifest = yield (0, manifest_1.signManifest)(manifest);
        console.log('Saving signed manifest...');
        yield (0, manifest_1.saveManifest)(distContentDir, signedManifest);
        console.log('Signed successfully');
    }
    catch (err) {
        console.warn(err);
    }
});
exports.pluginSignTask = new task_1.Task('plugin:sign task', pluginSignRunner);
//# sourceMappingURL=plugin.sign.js.map