import { AggregationTemporality } from './AggregationTemporality';
import { ResourceMetrics } from './MetricData';
import { ExportResult } from '@opentelemetry/core';
import { InstrumentType } from '../InstrumentDescriptor';
export interface PushMetricExporter {
    export(metrics: ResourceMetrics, resultCallback: (result: ExportResult) => void): void;
    forceFlush(): Promise<void>;
    selectAggregationTemporality(instrumentType: InstrumentType): AggregationTemporality;
    shutdown(): Promise<void>;
}
export declare class ConsoleMetricExporter implements PushMetricExporter {
    protected _shutdown: boolean;
    private _aggregationTemporality;
    constructor(aggregationTemporality?: AggregationTemporality);
    export(metrics: ResourceMetrics, resultCallback: (result: ExportResult) => void): void;
    selectAggregationTemporality(_instrumentType: InstrumentType): AggregationTemporality;
    forceFlush(): Promise<void>;
    shutdown(): Promise<void>;
}
//# sourceMappingURL=MetricExporter.d.ts.map