import * as metrics from '@opentelemetry/api-metrics';
import { MeterSharedState } from './state/MeterSharedState';
/**
 * This class implements the {@link metrics.Meter} interface.
 */
export declare class Meter implements metrics.Meter {
    private _meterSharedState;
    constructor(_meterSharedState: MeterSharedState);
    /**
     * Create a {@link metrics.Histogram} instrument.
     */
    createHistogram(name: string, options?: metrics.MetricOptions): metrics.Histogram;
    /**
     * Create a {@link metrics.Counter} instrument.
     */
    createCounter(name: string, options?: metrics.MetricOptions): metrics.Counter;
    /**
     * Create a {@link metrics.UpDownCounter} instrument.
     */
    createUpDownCounter(name: string, options?: metrics.MetricOptions): metrics.UpDownCounter;
    /**
     * Create a {@link metrics.ObservableGauge} instrument.
     */
    createObservableGauge(name: string, options?: metrics.MetricOptions): metrics.ObservableGauge;
    /**
     * Create a {@link metrics.ObservableCounter} instrument.
     */
    createObservableCounter(name: string, options?: metrics.MetricOptions): metrics.ObservableCounter;
    /**
     * Create a {@link metrics.ObservableUpDownCounter} instrument.
     */
    createObservableUpDownCounter(name: string, options?: metrics.MetricOptions): metrics.ObservableUpDownCounter;
    /**
     * @see {@link metrics.Meter.addBatchObservableCallback}
     */
    addBatchObservableCallback(callback: metrics.BatchObservableCallback, observables: metrics.Observable[]): void;
    /**
     * @see {@link metrics.Meter.removeBatchObservableCallback}
     */
    removeBatchObservableCallback(callback: metrics.BatchObservableCallback, observables: metrics.Observable[]): void;
}
//# sourceMappingURL=Meter.d.ts.map