"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoldTextAppender = void 0;
const tsdoc_1 = require("@microsoft/tsdoc");
const DocEmphasisSpan_1 = require("../../nodes/DocEmphasisSpan");
class BoldTextAppender {
    constructor(configuration) {
        this._configuration = configuration;
    }
    append(output, text) {
        const configuration = this._configuration;
        output.appendNode(new tsdoc_1.DocParagraph({ configuration }, [
            new DocEmphasisSpan_1.DocEmphasisSpan({ configuration, bold: true }, [
                new tsdoc_1.DocPlainText({ configuration, text })
            ])
        ]));
    }
}
exports.BoldTextAppender = BoldTextAppender;
;
//# sourceMappingURL=BoldTextAppender.js.map