/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;

public class CertificateRenewalWindowExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 4470220533545299271L;
    public static final String NAME = "CertificateRenewalWindow";
    public static final int[] OID = new int[]{2, 16, 840, 1, 113730, 1, 15};
    public static final ObjectIdentifier ID = new ObjectIdentifier(OID);
    private Date mBeginTime = null;
    private Date mEndTime = null;

    public CertificateRenewalWindowExtension(boolean critical, Date beginTime, Date endTime) throws IOException {
        this.extensionId = ID;
        this.critical = critical;
        this.mBeginTime = beginTime;
        this.mEndTime = endTime;
        this.encodeThis();
    }

    public CertificateRenewalWindowExtension(boolean critical) {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = null;
    }

    public CertificateRenewalWindowExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = (byte[])((byte[])value).clone();
        this.decodeThis();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set(String name, Object obj) throws CertificateException {
    }

    @Override
    public Object get(String name) throws CertificateException {
        return null;
    }

    @Override
    public void delete(String name) throws CertificateException {
    }

    @Override
    public void decode(InputStream in) throws IOException {
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public Date getBeginTime() {
        return this.mBeginTime;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public void setBeginTime(Date d) {
        this.mBeginTime = d;
    }

    public void setEndTime(Date d) {
        this.mEndTime = d;
    }

    private void decodeThis() throws IOException {
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of CertificateWindow extension");
        }
        while (val.data.available() != 0) {
            if (this.mBeginTime == null) {
                this.mBeginTime = val.data.getGeneralizedTime();
                continue;
            }
            this.mEndTime = val.data.getGeneralizedTime();
        }
    }

    private void encodeThis() throws IOException {
        try (DerOutputStream seq = new DerOutputStream();
             DerOutputStream tmp = new DerOutputStream();){
            tmp.putGeneralizedTime(this.mBeginTime);
            if (this.mEndTime != null) {
                tmp.putGeneralizedTime(this.mEndTime);
            }
            seq.write((byte)48, tmp);
            this.extensionValue = seq.toByteArray();
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public String toString() {
        String s = super.toString() + "CertificateRenewalWindow [\n";
        s = s + "BeginTime: " + this.mBeginTime + "\n";
        if (this.mEndTime != null) {
            s = s + "EndTime: " + this.mEndTime;
        }
        return s + "]\n";
    }
}

