/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSEngineReferenceImpl;
import org.mozilla.jss.ssl.javax.JSSSocket;

public class JSSSocketFactory
extends SSLSocketFactory {
    private SSLContext ctx;
    private JSSKeyManager key_manager;
    private X509TrustManager[] trust_managers;

    public JSSSocketFactory(String protocol, JSSKeyManager km, X509TrustManager[] tms) {
        try {
            this.ctx = SSLContext.getInstance(protocol, "Mozilla-JSS");
            this.ctx.init(new JSSKeyManager[]{km}, tms, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error recreating SSLContext instance: " + e.getMessage(), e);
        }
        this.key_manager = km;
        this.trust_managers = tms;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        SSLCipher[] ciphers = JSSEngine.queryEnabledCipherSuites();
        String[] result = new String[ciphers.length];
        for (int i = 0; i < ciphers.length; ++i) {
            result[i] = ciphers[i].toString();
        }
        return result;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        JSSEngineReferenceImpl engine = new JSSEngineReferenceImpl();
        return engine.getSupportedCipherSuites();
    }

    @Override
    public JSSSocket createSocket() throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(new Socket());
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(InetAddress host, int port) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(new Socket(host, port));
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(new Socket(host, port, localAddress, localPort));
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(String host, int port) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(new Socket(host, port));
        ret.setSSLContext(this.ctx);
        ret.initEngine(host, port);
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(new Socket(host, port, localAddress, localPort));
        ret.setSSLContext(this.ctx);
        ret.initEngine(host, port);
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(s);
        ret.setSSLContext(this.ctx);
        ret.initEngine(host, port);
        ret.setAutoClose(autoClose);
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }

    @Override
    public JSSSocket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        JSSSocket ret = new JSSSocket();
        ret.consumeSocket(s);
        ret.setConsumedData(consumed);
        ret.setSSLContext(this.ctx);
        ret.initEngine();
        ret.setUseClientMode(false);
        ret.setAutoClose(autoClose);
        ret.setKeyManager(this.key_manager);
        ret.setTrustManagers(this.trust_managers);
        return ret;
    }
}

