#ifndef HAVE_ADNS_MESSAGE_H
#define HAVE_ADNS_MESSAGE_H

using namespace System;
using namespace System::Net;
using namespace System::Net::Sockets;
using namespace System::Collections::Generic;

#include "message_header.h"
#include "question_header.h"
#include "all_rr.h"
#include "dns_charstring.h"
#include "domain_name.h"
#include "rrset.h"

namespace ADNS {


	public delegate ResourceRecord^ GenRRDelegate(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
	public delegate String^ PrintRRDelegate(ResourceRecord^ rr);
	public delegate ResourceRecord^ CloneRRDelegate(ResourceRecord^ rr);

	public ref class Message {
	private:
		List<RR_TYPE>^ RegisteredTypes;
		List<GenRRDelegate^>^ RegisteredRRParsers;
		List<PrintRRDelegate^>^ RegisteredRRPrinters;
		List<CloneRRDelegate^>^ RegisteredRRCloners;

	public:
		MessageHeader^ mh;
		List<QuestionHeader^>^ Questions;
		RRSet^ Answer;
		RRSet^ Authority;
		RRSet^ Additional;
		String^ PrintResourceRecord(ResourceRecord^ rr);
		Message();
		Message(array<Byte>^ packet);
		array<Byte>^ ToWire();
		array<Byte>^ SendMessageUDP(IPAddress^ DNSServer, int retries, int timeout);
		ResourceRecord^ CloneResourceRecord(ResourceRecord^ rr);
		void RegisterResourceRecords();
		ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		bool RRIsSupported(UInt16 rr_type);
	};


}


#endif
