/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tks.servlet;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Map;
import org.dogtagpki.server.tks.TKSEngine;
import org.dogtagpki.server.tks.servlet.GPParams;
import org.dogtagpki.server.tks.servlet.KDF;
import org.dogtagpki.server.tks.servlet.NistSP800_108KDF;
import org.dogtagpki.server.tks.servlet.StandardKDF;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.SymmetricKeyDeriver;
import org.mozilla.jss.crypto.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelProtocol {
    public static Logger logger = LoggerFactory.getLogger(SecureChannelProtocol.class);
    static String sharedSecretKeyName = null;
    static String masterKeyPrefix = null;
    static final int DEF_AES_KEYLENGTH = 16;
    static final int KEYLENGTH = 16;
    static final int PREFIXLENGHT = 128;
    static final int DES2_LENGTH = 16;
    static final int DES3_LENGTH = 24;
    static final int EIGHT_BYTES = 8;
    static final int KEYNAMELENGTH = 135;
    static final String TRANSPORT_KEY_NAME = "sharedSecret";
    static final String DEFKEYSET_NAME = "defKeySet";
    static int protocol = 1;
    public static final String encType = "enc";
    public static final String macType = "mac";
    public static final String kekType = "kek";
    public static final String authType = "auth";
    public static final String dekType = "dek";
    public static final String rmacType = "rmac";
    public static final int PROTOCOL_ONE = 1;
    public static final int PROTOCOL_TWO = 2;
    public static final int PROTOCOL_THREE = 3;
    public static final int HOST_CRYPTOGRAM = 0;
    public static final int CARD_CRYPTOGRAM = 1;
    static final int LONG_SIZE = 8;
    static final int AES_128_BYTES = 16;
    static final int AES_192_BYTES = 24;
    static final int AES_256_BYTES = 32;
    static final int AES_128_BITS = 128;
    static final int AES_192_BITS = 192;
    static final int AES_256_BITS = 256;
    private SymmetricKey transportKey = null;
    CryptoManager cryptoManager = null;
    protected static final char[] hex = "0123456789abcdef".toCharArray();

    public SecureChannelProtocol() {
    }

    public SecureChannelProtocol(int theProtocol) {
        protocol = theProtocol;
    }

    public byte[] computeCryptogram_SCP01(String selectedToken, String keyNickName, byte[] card_challenge, byte[] host_challenge, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, int cryptogramType, byte[] authKeyArray, String useSoftToken_s, String keySet, String transportKeyName) throws EBaseException {
        String method = "SecureChannelProtocol.computeCryptogram_SCP01:";
        logger.debug(method + " Entering:  Type:  HOST=0 , CARD=1 : TYPE: " + cryptogramType);
        if (card_challenge == null || card_challenge.length != 8 || host_challenge == null || host_challenge.length != 8) {
            throw new EBaseException(method + " Invalid card challenge or host challenge!");
        }
        if (cryptogramType != 0 && cryptogramType != 1) {
            throw new EBaseException(method + " Invalid cyrptgram type!");
        }
        byte[] cryptogram = null;
        SymmetricKey authKey = this.computeSessionKey_SCP01(encType, selectedToken, keyNickName, card_challenge, host_challenge, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, authKeyArray, useSoftToken_s, keySet, transportKeyName);
        byte[] input = new byte[16];
        byte[] icv = new byte[8];
        if (cryptogramType == 0) {
            int i;
            for (i = 0; i < 8; ++i) {
                input[i] = card_challenge[i];
            }
            for (i = 0; i < 8; ++i) {
                input[8 + i] = host_challenge[i];
            }
        } else if (cryptogramType == 1) {
            int i;
            for (i = 0; i < 8; ++i) {
                input[i] = host_challenge[i];
            }
            for (i = 0; i < 8; ++i) {
                input[8 + i] = card_challenge[i];
            }
        }
        cryptogram = this.computeMAC_SCP01(authKey, input, icv, selectedToken);
        return cryptogram;
    }

    public SymmetricKey computeSessionKey_SCP02(String selectedToken, String keyNickName, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, byte[] macKeyArray, byte[] sequenceCounter, byte[] derivationConstant, String useSoftToken_s, String keySet, String transportKeyName) throws EBaseException {
        String method = "SecureChannelProtocol.computeSessionKey_SCP01:";
        logger.debug(method + " entering... ");
        throw new EBaseException(method + " Not yet implemented!");
    }

    public int getProtocol() {
        return protocol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SymmetricKey computeSessionKey_SCP03(String selectedToken, String keyNickName, byte[] keyInfo, String keyType, byte[] devKeyArray, String keySet, byte[] xCUID, byte[] xKDD, byte[] host_challenge, byte[] card_challenge, String transportKeyName, GPParams params) throws EBaseException {
        int mac_constant = 6;
        int enc_constant = 4;
        int rmac_constant = 7;
        boolean enc_constant_gpkmc = true;
        int mac_constant_gpkmc = 2;
        int kek_constant_gpkmc = 3;
        boolean noDerive = false;
        byte constant = 0;
        byte constant_gpkmc = 0;
        String method = "SecureChannelProtocol.computeSessionKey_SCP03:";
        if (keyType == null) throw new EBaseException(method + " invalid input data");
        if (devKeyArray == null) throw new EBaseException(method + " invalid input data");
        if (transportKeyName == null) {
            throw new EBaseException(method + " invalid input data");
        }
        if (xCUID == null) throw new EBaseException(method + "CUID invalid size!");
        if (xCUID.length <= 0) {
            throw new EBaseException(method + "CUID invalid size!");
        }
        if (xKDD == null) throw new EBaseException(method + "KDD invalid size!");
        if (xKDD.length != 10) {
            throw new EBaseException(method + "KDD invalid size!");
        }
        if (card_challenge == null && host_challenge == null) {
            noDerive = true;
        } else {
            if (card_challenge == null) throw new EBaseException(method + " Invalid challenge data!");
            if (host_challenge == null) {
                throw new EBaseException(method + " Invalid challenge data!");
            }
        }
        logger.debug(method + " entering. nickname: " + keyNickName + " selectedToken: " + selectedToken);
        TKSEngine engine = TKSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        CryptoManager cm = null;
        CryptoToken token = null;
        CryptoToken internalToken = null;
        try {
            cm = CryptoManager.getInstance();
            token = this.returnTokenByName(selectedToken, cm);
            internalToken = this.returnTokenByName("internal", cm);
        }
        catch (NotInitializedException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        catch (NoSuchTokenException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        sharedSecretKeyName = SecureChannelProtocol.getSharedSecretKeyName(transportKeyName);
        this.transportKey = this.getSharedSecretKey(internalToken);
        byte[] context = null;
        ByteArrayOutputStream contextStream = new ByteArrayOutputStream();
        if (!noDerive) {
            try {
                contextStream.write(host_challenge);
                contextStream.write(card_challenge);
            }
            catch (IOException e) {
                throw new EBaseException(method + " Error calculating derivation data!");
            }
            context = contextStream.toByteArray();
        }
        if (keyType.equalsIgnoreCase(encType)) {
            constant = 4;
            constant_gpkmc = 1;
        }
        if (keyType.equalsIgnoreCase(macType)) {
            constant = 6;
            constant_gpkmc = 1;
        }
        if (keyType.equalsIgnoreCase(rmacType)) {
            constant = 7;
        }
        if (keyType.equalsIgnoreCase(kekType)) {
            constant = 0;
            constant_gpkmc = 3;
        }
        String keyNameStr = null;
        SymmetricKey sessionKey = null;
        SymmetricKey masterKey = null;
        keyNameStr = keyNickName == null ? this.getKeyName(keyInfo) : keyNickName;
        boolean noDivers = false;
        logger.debug(method + " keyNameStr: " + keyNameStr);
        if (keyInfo[0] == 1 && keyNameStr.contains("#01#") || keyInfo[0] == -1 && keyNameStr.indexOf("#FF") != -1) {
            String finalKeyType = keyType;
            String devKeyType = params.getDevKeyType();
            logger.debug(method + " Developer key set case: incoming dev key type: " + devKeyType);
            SymmetricKey devSymKey = this.returnDeveloperSymKey(token, finalKeyType, keySet, devKeyArray, devKeyType);
            NistSP800_108KDF nistKdf = new NistSP800_108KDF(this);
            StandardKDF standard = new StandardKDF(this);
            SymmetricKey divKey = null;
            byte[] keyDiversified = null;
            if (params.isVer1DiversNone()) {
                logger.debug(method + " No diversifcation requested. ");
                noDivers = true;
            } else if (params.isVer1DiversEmv()) {
                logger.debug(method + " EMV diversification requested. ");
                keyDiversified = KDF.getDiversificationData_EMV(xKDD, keyType);
            } else if (params.isVer1DiversVisa2()) {
                logger.debug(method + " Visa2 diversification requested.");
                keyDiversified = KDF.getDiversificationData_VISA2(xKDD, keyType);
            } else {
                if (!params.isVer1DiversGPKMC()) throw new EBaseException(method + " Invalid diversification method!");
                logger.debug(method + " GPKMC diversification requested.");
            }
            if (noDivers) {
                divKey = devSymKey;
            } else if ("DES3".equalsIgnoreCase(devKeyType)) {
                divKey = standard.computeCardKey_SCP03_WithDES3(devSymKey, keyDiversified, token);
            } else {
                if (!"AES".equalsIgnoreCase(devKeyType)) throw new EBaseException(method + " Invalid devolper key type. Does not support diversification: " + devKeyType);
                if (params.isVer1DiversGPKMC()) {
                    divKey = nistKdf.diversifyAESKey(devSymKey, xCUID, constant_gpkmc, token);
                }
            }
            if (constant == 0) {
                return divKey;
            }
            if (noDerive) {
                return divKey;
            }
            byte[] finalKeyBytes = nistKdf.kdf_AES_CMAC_SCP03(divKey, context, constant, 16);
            sessionKey = this.unwrapAESSymKeyOnToken(token, finalKeyBytes, false);
            jssSubsystem.obscureBytes(finalKeyBytes);
            return sessionKey;
        } else {
            logger.debug(method + "In master key mode.");
            masterKey = SecureChannelProtocol.getSymKeyByName(token, keyNameStr);
            String masterKeyType = params.getMasterKeyType();
            logger.debug(method + " Master key case: requested master key type: " + masterKeyType);
            NistSP800_108KDF nistKdf = new NistSP800_108KDF(this);
            StandardKDF standard = new StandardKDF(this);
            byte[] keyDiversified = null;
            if (params.isDiversNone()) {
                if (!"AES".equalsIgnoreCase(masterKeyType)) throw new EBaseException(method + " No diversification requested in master key mode. With master key type of DES3: Aborting...");
                logger.debug(method + " Master key case: no diversification requested: With master key type of AES ");
            } else if (params.isDiversEmv()) {
                keyDiversified = KDF.getDiversificationData_EMV(xKDD, keyType);
            } else if (params.isDiversVisa2()) {
                keyDiversified = KDF.getDiversificationData_VISA2(xKDD, keyType);
            }
            SymmetricKey divKey = null;
            if ("AES".equalsIgnoreCase(masterKeyType)) {
                logger.debug(method + " master key case with AES type.");
                if (params.isDiversGPKMC()) {
                    logger.debug(method + " GPKMC diversification requested.");
                    divKey = nistKdf.diversifyAESKey(masterKey, xCUID, constant_gpkmc, token);
                } else {
                    divKey = masterKey;
                }
            } else {
                divKey = standard.computeCardKey_SCP03_WithDES3(masterKey, keyDiversified, token);
            }
            if (constant == 0) {
                return divKey;
            }
            if (noDerive) {
                return divKey;
            }
            byte[] finalKeyBytes = nistKdf.kdf_AES_CMAC_SCP03(divKey, context, constant, 16);
            sessionKey = this.unwrapAESSymKeyOnToken(token, finalKeyBytes, false);
            jssSubsystem.obscureBytes(finalKeyBytes);
        }
        return sessionKey;
    }

    public SymmetricKey computeKEKKey_SCP01(String selectedToken, String keyNickName, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, byte[] devKeyArray, String useSoftToken_s, String keySet, String transportKeyName) throws EBaseException {
        String method = "SecureChannelProtocol.computeKEKKey_SCP01:";
        logger.debug(method + " entering... ");
        return this.computeSessionKey_SCP01(kekType, selectedToken, keyNickName, null, null, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, devKeyArray, useSoftToken_s, keySet, transportKeyName);
    }

    public SymmetricKey computeSessionKey_SCP01(String keyType, String selectedToken, String keyNickName, byte[] card_challenge, byte[] host_challenge, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, byte[] devKeyArray, String useSoftToken_s, String keySet, String transportKeyName) throws EBaseException {
        String method = "SecureChannelProtocol.computeSessionKey_SCP01:";
        logger.debug(method + " entering... requested type: " + keyType);
        boolean noDerive = false;
        if (keyType == null || devKeyArray == null || keyInfo == null || keySet == null || transportKeyName == null || keyInfo == null || keyInfo.length < 2) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (xCUID == null || xCUID.length <= 0) {
            throw new EBaseException(method + "CUID invalid size!");
        }
        if (xKDD == null || xKDD.length != 10) {
            throw new EBaseException(method + "KDD invalid size!");
        }
        if (card_challenge == null && host_challenge == null) {
            noDerive = true;
            logger.debug(method + " NoDerive mode: true");
        } else {
            if (card_challenge == null || host_challenge == null) {
                throw new EBaseException(method + " Invalid input!");
            }
            logger.debug(method + " NoDerive mode: false");
        }
        logger.debug(method + " entering. nickname: " + keyNickName + " selectedToken: " + selectedToken);
        logger.debug(method + " nistSP800_108kdfOnKeyVersion: " + (nistSP800_108KdfOnKeyVersion & 0xFF));
        CryptoManager cm = null;
        CryptoToken token = null;
        CryptoToken internalToken = null;
        try {
            cm = CryptoManager.getInstance();
            token = this.returnTokenByName(selectedToken, cm);
            internalToken = this.returnTokenByName("internal", cm);
        }
        catch (NotInitializedException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        catch (NoSuchTokenException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        sharedSecretKeyName = SecureChannelProtocol.getSharedSecretKeyName(transportKeyName);
        this.transportKey = this.getSharedSecretKey(internalToken);
        String keyNameStr = null;
        SymmetricKey sessionKey = null;
        SymmetricKey masterKey = null;
        keyNameStr = keyNickName == null ? this.getKeyName(keyInfo) : keyNickName;
        byte[] context = null;
        context = nistSP800_108KdfUseCuidAsKdd && NistSP800_108KDF.useThisKDF(nistSP800_108KdfOnKeyVersion, keyInfo[0]) ? xCUID : xKDD;
        if (keyInfo[0] == 1 && keyInfo[1] == 1 && keyNameStr.equals("#01#01") || keyInfo[0] == -1 && keyNameStr.indexOf("#FF") != -1) {
            String finalKeyType = keyType;
            SymmetricKey devSymKey = this.returnDeveloperSymKey(token, finalKeyType, keySet, devKeyArray, "DES3");
            if (keyType.equals(encType)) {
                this.returnDeveloperSymKey(token, authType, keySet, devKeyArray, "DES3");
            }
            sessionKey = noDerive ? devSymKey : this.deriveKey_SCP01(token, devSymKey, host_challenge, card_challenge);
        } else {
            SymmetricKey devKey = null;
            logger.debug(method + "In master key mode.");
            masterKey = SecureChannelProtocol.getSymKeyByName(token, keyNameStr);
            if (NistSP800_108KDF.useThisKDF(nistSP800_108KdfOnKeyVersion, keyInfo[0])) {
                logger.debug(method + " ComputeSessionKey NistSP800_108KDF code: Using NIST SP800-108 KDF.");
                NistSP800_108KDF nistKDF = new NistSP800_108KDF(this);
                Map<String, SymmetricKey> keys = null;
                try {
                    keys = nistKDF.computeCardKeys(masterKey, context, token);
                }
                catch (EBaseException e) {
                    logger.error(method + "Can't compute card keys! " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                devKey = keys.get(keyType);
            } else {
                StandardKDF standardKDF = new StandardKDF(this);
                logger.debug(method + " ComputeSessionKey NistSP800_108KDF code: Using original KDF.");
                byte[] data = KDF.getDiversificationData_VISA2(context, keyType);
                devKey = standardKDF.computeCardKey(masterKey, data, token, 1);
            }
            sessionKey = noDerive ? devKey : this.deriveKey_SCP01(token, devKey, host_challenge, card_challenge);
        }
        return sessionKey;
    }

    private SymmetricKey deriveKey_SCP01(CryptoToken token, SymmetricKey cardKey, byte[] host_challenge, byte[] card_challenge) throws EBaseException {
        String method = "SecureChannelProtocol.deriveKey_SCP01:";
        logger.debug(method + "entering..");
        if (cardKey == null || token == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        byte[] derivationData = new byte[16];
        SymmetricKey derivedKey = null;
        for (int i = 0; i < 4; ++i) {
            derivationData[i] = card_challenge[i + 4];
            derivationData[i + 4] = host_challenge[i];
            derivationData[i + 8] = card_challenge[i];
            derivationData[i + 12] = host_challenge[i + 4];
        }
        byte[] encrypted = null;
        try {
            SymmetricKeyDeriver encryptDes3 = token.getSymmetricKeyDeriver();
            encryptDes3.initDerive(cardKey, 4354L, derivationData, null, 306L, 268L, 16L);
            try {
                derivedKey = encryptDes3.derive();
            }
            catch (TokenException e) {
                logger.debug(method + "Unable to derive the key with the proper mechanism!" + e);
                logger.debug(method + "Now try this the old fashioned way");
                encrypted = this.computeDes3EcbEncryption(cardKey, token.getName(), derivationData);
                byte[] parityEncrypted = KDF.getDesParity(encrypted);
                logger.debug(method + "encryption completed");
                derivedKey = this.unwrapSymKeyOnToken(token, null, parityEncrypted, false, SymmetricKey.DES3);
            }
        }
        catch (EBaseException | InvalidKeyException | TokenException e) {
            logger.error(method + "Unable to derive the key with the proper mechanism! " + e.getMessage(), e);
            throw new EBaseException((Exception)e);
        }
        return derivedKey;
    }

    public SymmetricKey getSharedSecretKey(CryptoToken token) throws EBaseException {
        String method = "SecureChannelProtocol.getSharedSecretKey:";
        logger.debug(method + "entering: transportKey: " + this.transportKey);
        CryptoToken finalToken = token;
        CryptoToken internalToken = null;
        if (token == null) {
            logger.debug(method + " No token provided assume internal ");
            CryptoManager cm = null;
            try {
                cm = CryptoManager.getInstance();
                finalToken = internalToken = this.returnTokenByName("internal", cm);
            }
            catch (NotInitializedException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
            catch (NoSuchTokenException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
        }
        if (this.transportKey == null) {
            this.transportKey = SecureChannelProtocol.getSymKeyByName(finalToken, sharedSecretKeyName);
        }
        if (this.transportKey == null) {
            throw new EBaseException(method + "Can't locate shared secret key in token db.");
        }
        return this.transportKey;
    }

    private String getKeyName(byte[] keyVersion) {
        String method = "SecureChannelProtocol.getKeyName:";
        logger.debug(method + " Entering...");
        String keyName = null;
        if (keyVersion == null || keyVersion.length != 2) {
            return null;
        }
        keyName = "#" + String.format("%02X", keyVersion[0]) + "#" + String.format("%02X", keyVersion[1]);
        logger.debug(method + " returning: " + keyName);
        return keyName;
    }

    public static String getSharedSecretKeyName(String name) throws EBaseException {
        String method = "SecureChannelProtocol.getSharedSecretKeyName:";
        logger.debug(method + " Entering...");
        if (name != null) {
            sharedSecretKeyName = name;
        }
        if (sharedSecretKeyName == null) {
            throw new EBaseException(method + " Can not find shared secret key name!");
        }
        return sharedSecretKeyName;
    }

    public static String setSharedSecretKeyName(String name) throws EBaseException {
        return SecureChannelProtocol.getSharedSecretKeyName(name);
    }

    public SymmetricKey returnDeveloperSymKey(CryptoToken token, String keyType, String keySet, byte[] inputKeyArray, String keyAlg) throws EBaseException {
        SymmetricKey devKey = null;
        String method = "SecureChannelProtocol.returnDeveloperSymKey:";
        boolean isAES = false;
        String finalAlg = null;
        if (keyAlg == null) {
            finalAlg = "DES3";
        }
        if (keyAlg.equalsIgnoreCase("AES")) {
            isAES = true;
            finalAlg = "AES";
        }
        String devKeyName = keySet + "-" + keyType + "Key-" + finalAlg;
        logger.debug(method + " entering.. searching for key: " + devKeyName);
        if (token == null || keyType == null || keySet == null) {
            throw new EBaseException(method + "Invalid input data!");
        }
        try {
            logger.debug(method + " requested token: " + token.getName());
        }
        catch (TokenException e) {
            throw new EBaseException(method + e);
        }
        devKey = SecureChannelProtocol.getSymKeyByName(token, devKeyName);
        if (devKey == null) {
            byte[] des3InputKey = null;
            if (inputKeyArray == null) {
                throw new EBaseException(method + "Input key is null and has to be non null when importing...");
            }
            int inputLen = inputKeyArray.length;
            logger.debug(method + " inputKeyArray.length: " + inputLen);
            if (!isAES) {
                if (inputLen != 24 && inputLen != 16) {
                    throw new EBaseException(method + "invalid input key length!");
                }
                if (inputLen == 16) {
                    des3InputKey = new byte[24];
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 0, 16);
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 16, 8);
                } else {
                    System.arraycopy(inputKeyArray, 0, des3InputKey, 0, 24);
                }
                devKey = this.unwrapSymKeyOnToken(token, des3InputKey, true);
            } else if (inputLen == 16) {
                devKey = this.unwrapAESSymKeyOnToken(token, inputKeyArray, true);
            }
            devKey.setNickName(devKeyName);
        } else {
            logger.debug(method + " Found sym key: " + devKeyName);
        }
        return devKey;
    }

    public SymmetricKey unwrapAESSymKeyOnToken(CryptoToken token, byte[] inputKeyArray, boolean isPerm) throws EBaseException {
        SymmetricKey finalAESKey;
        String method = "SecureChannelProtocol.unwrapAESSymKeyOnToken:";
        logger.debug(method + "Entering...");
        if (token == null || inputKeyArray == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        if (inputKeyArray.length < 16) {
            throw new EBaseException(method + " Invalid key size!");
        }
        byte[] finalInputKeyArray = inputKeyArray;
        if (inputKeyArray.length > 16) {
            finalInputKeyArray = new byte[16];
            System.arraycopy(inputKeyArray, 0, finalInputKeyArray, 0, 16);
        }
        try {
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
            SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
            kg.setKeyUsages(usages);
            kg.temporaryKeys(true);
            kg.initialize(128);
            SymmetricKey tempKey = kg.generate();
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
            byte[] iv = null;
            if (ivLength > 0) {
                iv = new byte[ivLength];
            }
            encryptor.initEncrypt(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            byte[] wrappedKey = encryptor.doFinal(finalInputKeyArray);
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyWrap.initUnwrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            finalAESKey = isPerm ? keyWrap.unwrapSymmetricPerm(wrappedKey, SymmetricKey.AES, 16) : keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, 16);
        }
        catch (Exception e) {
            throw new EBaseException(method + " Can't unwrap key onto token!");
        }
        return finalAESKey;
    }

    public SymmetricKey unwrapAESSymKeyOnToken(CryptoToken token, SymmetricKey keyToUnwrap, boolean isPerm) throws EBaseException {
        SymmetricKey finalAESKey;
        String method = "SecureChannelProtocol.unwrapAESSymKeyOnToken:";
        logger.debug(method + "Entering...");
        if (token == null || keyToUnwrap == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        if (keyToUnwrap.getLength() < 16) {
            throw new EBaseException(method + " Invalid key size!");
        }
        TKSEngine engine = TKSEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        try {
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
            SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
            kg.setKeyUsages(usages);
            kg.temporaryKeys(true);
            kg.initialize(128);
            SymmetricKey tempKey = kg.generate();
            int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
            byte[] iv = null;
            if (ivLength > 0) {
                iv = new byte[ivLength];
            }
            int len = keyToUnwrap.getLength();
            SymmetricKey finalKeyToWrap = null;
            SymmetricKey key16 = null;
            if (len > 16) {
                key16 = this.extractDes2FromDes3(keyToUnwrap, token.getName());
                if (key16 != null) {
                    len = key16.getLength();
                }
                finalKeyToWrap = key16;
            } else {
                finalKeyToWrap = keyToUnwrap;
            }
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyWrap.initWrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            byte[] wrappedKey = keyWrap.wrap(finalKeyToWrap);
            KeyWrapper keyUnWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
            keyUnWrap.initUnwrap(tempKey, (AlgorithmParameterSpec)new IVParameterSpec(iv));
            finalAESKey = keyUnWrap.unwrapSymmetric(wrappedKey, SymmetricKey.AES, 16);
            jssSubsystem.obscureBytes(wrappedKey);
        }
        catch (Exception e) {
            throw new EBaseException(method + " Can't unwrap key onto token!");
        }
        return finalAESKey;
    }

    public SymmetricKey unwrapSymKeyOnToken(CryptoToken token, SymmetricKey unwrappingKey, byte[] inputKeyArray, boolean isPerm, SymmetricKey.Type finalKeyType) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        SymmetricKey tempKey = null;
        if (token == null) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (inputKeyArray == null || inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        if (unwrappingKey == null) {
            try {
                KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES3);
                SymmetricKey.Usage[] usages = new SymmetricKey.Usage[]{SymmetricKey.Usage.WRAP, SymmetricKey.Usage.UNWRAP, SymmetricKey.Usage.ENCRYPT, SymmetricKey.Usage.DECRYPT};
                kg.setKeyUsages(usages);
                kg.temporaryKeys(true);
                tempKey = kg.generate();
            }
            catch (CharConversionException | IllegalStateException | NoSuchAlgorithmException | TokenException e) {
                throw new EBaseException(method + "Can't generate temporary key to unwrap the key.");
            }
        }
        byte[] finalKeyArray = null;
        if (inputKeyArray.length == 16 && finalKeyType == SymmetricKey.DES3) {
            finalKeyArray = SecureChannelProtocol.makeDes3FromDes2(inputKeyArray);
        }
        Cipher encryptor = null;
        byte[] wrappedKey = null;
        SymmetricKey encUnwrapKey = null;
        encUnwrapKey = tempKey != null ? tempKey : unwrappingKey;
        try {
            encryptor = token.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            encryptor.initEncrypt(encUnwrapKey);
            wrappedKey = finalKeyArray != null ? (finalKeyType == SymmetricKey.Type.DES3 || finalKeyType == SymmetricKey.Type.DES ? encryptor.doFinal(KDF.getDesParity(finalKeyArray)) : encryptor.doFinal(finalKeyArray)) : (finalKeyType == SymmetricKey.Type.DES3 || finalKeyType == SymmetricKey.Type.DES ? encryptor.doFinal(KDF.getDesParity(inputKeyArray)) : encryptor.doFinal(inputKeyArray));
            logger.debug(method + " done enrypting data");
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
            keyWrap.initUnwrap(encUnwrapKey, null);
            unwrapped = isPerm ? keyWrap.unwrapSymmetricPerm(wrappedKey, finalKeyType, 0) : keyWrap.unwrapSymmetric(wrappedKey, finalKeyType, 0);
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        finally {
            if (finalKeyArray != null) {
                Arrays.fill(finalKeyArray, (byte)0);
            }
        }
        logger.debug(method + "Returning symkey...");
        return unwrapped;
    }

    public SymmetricKey unwrapWrappedSymKeyOnToken(CryptoToken token, SymmetricKey unwrappingKey, byte[] inputKeyArray, boolean isPerm, SymmetricKey.Type keyType) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapWrappedSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        SymmetricKey finalUnwrapped = null;
        if (token == null || unwrappingKey == null) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (inputKeyArray == null) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        if (keyType == SymmetricKey.Type.AES ? inputKeyArray.length != 16 : (keyType == SymmetricKey.Type.DES || keyType == SymmetricKey.Type.DES3) && inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "Invalid length of raw input array.");
        }
        try {
            KeyWrapper keyWrap;
            if (unwrappingKey.getType() == SymmetricKey.Type.AES) {
                IVParameterSpec iv = new IVParameterSpec(new byte[EncryptionAlgorithm.AES_128_CBC.getIVLength()]);
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
                keyWrap.initUnwrap(unwrappingKey, (AlgorithmParameterSpec)iv);
            } else if (unwrappingKey.getType() == SymmetricKey.Type.DES || unwrappingKey.getType() == SymmetricKey.Type.DES3) {
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
                keyWrap.initUnwrap(unwrappingKey, null);
            } else {
                throw new EBaseException(method + " Unsupported transport key type.");
            }
            unwrapped = isPerm ? keyWrap.unwrapSymmetricPerm(inputKeyArray, keyType, SymmetricKey.Usage.UNWRAP, inputKeyArray.length) : keyWrap.unwrapSymmetric(inputKeyArray, keyType, SymmetricKey.Usage.UNWRAP, inputKeyArray.length);
            if (keyType == SymmetricKey.DES3) {
                finalUnwrapped = this.makeDes3KeyDerivedFromDes2(unwrapped, token.getName());
            }
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        logger.debug(method + "Returning symkey...");
        return finalUnwrapped == null ? unwrapped : finalUnwrapped;
    }

    public SymmetricKey unwrapSymKeyOnToken(CryptoToken token, byte[] inputKeyArray, boolean isPerm) throws EBaseException {
        String method = "SecureChannelProtocol.unwrapSymKeyOnToken:";
        logger.debug(method + "Entering...");
        SymmetricKey unwrapped = null;
        if (token == null) {
            throw new EBaseException(method + "Invalide crypto token!");
        }
        if (inputKeyArray == null || inputKeyArray.length != 24 && inputKeyArray.length != 16) {
            throw new EBaseException(method + "No raw array to use to create key!");
        }
        SymmetricKey transport = this.getSharedSecretKey(token);
        unwrapped = this.unwrapSymKeyOnToken(token, transport, inputKeyArray, isPerm, SymmetricKey.DES3);
        return unwrapped;
    }

    public static SymmetricKey getSymKeyByName(CryptoToken token, String name) throws EBaseException {
        SymmetricKey[] keys;
        String method = "SecureChannelProtocol.getSymKeyByName:";
        if (token == null || name == null) {
            throw new EBaseException(method + "Invalid input data!");
        }
        logger.debug(method + "Searching for sym key: " + name);
        try {
            keys = token.getCryptoStore().getSymmetricKeys();
        }
        catch (TokenException e) {
            throw new EBaseException(method + "Can't get the list of symmetric keys!");
        }
        for (SymmetricKey cur : keys) {
            if (cur == null || !name.equals(cur.getNickName())) continue;
            logger.debug(method + "Found key: " + name);
            return cur;
        }
        logger.debug(method + " Sym Key not found.");
        return null;
    }

    public CryptoToken returnTokenByName(String name, CryptoManager manager) throws NoSuchTokenException, NotInitializedException {
        logger.debug("returnTokenByName: requested name: " + name);
        if (name == null || manager == null) {
            throw new NoSuchTokenException();
        }
        return CryptoUtil.getKeyStorageToken((String)name);
    }

    public static byte[] makeDes3FromDes2(byte[] des2) {
        if (des2 == null || des2.length != 16) {
            return null;
        }
        byte[] des3 = new byte[24];
        System.arraycopy(des2, 0, des3, 0, 16);
        System.arraycopy(des2, 0, des3, 16, 8);
        return des3;
    }

    public static void debugByteArray(byte[] array, String message) {
        logger.debug("About to dump array: " + message);
        System.out.println("About to dump array: " + message);
        if (array == null) {
            logger.debug("Array to dump is empty!");
            return;
        }
        System.out.println("################### ");
        logger.debug("################### ");
        String result = SecureChannelProtocol.getHexString(array);
        logger.debug(result);
        System.out.println(result);
    }

    public static void displayByteArray(byte[] ba, boolean has_check_sum) {
        int mask = 255;
        if (has_check_sum) {
            mask = 254;
        }
        for (int i = 0; i < ba.length; ++i) {
            System.out.print(Integer.toHexString(ba[i] & mask) + " ");
            if (i % 26 != 25) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    public static String getHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 3];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3] = hex[v >>> 4];
            hexChars[j * 3 + 1] = hex[v & 0xF];
            hexChars[j * 3 + 2] = 58;
        }
        return new String(hexChars);
    }

    public CryptoManager getCryptoManger() throws EBaseException {
        String method = "SecureChannelProtocol.getCryptoManager";
        CryptoManager cm = null;
        if (this.cryptoManager != null) {
            return this.cryptoManager;
        }
        try {
            cm = CryptoManager.getInstance();
        }
        catch (NotInitializedException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        this.cryptoManager = cm;
        return this.cryptoManager;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public SymmetricKey generateSymKey(String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.generateSymKey:";
        logger.debug(method + " entering , token: " + selectedToken);
        SymmetricKey symKey = null;
        SymmetricKey symKeyFinal = null;
        if (selectedToken == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES3);
            symKey = kg.generate();
            symKeyFinal = this.makeDes3KeyDerivedFromDes2(symKey, selectedToken);
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return symKeyFinal;
    }

    public byte[] ecbEncrypt(SymmetricKey devKey, SymmetricKey symKey, String selectedToken) throws EBaseException {
        byte[] result = null;
        String method = "SecureChannelProtocol.ecbEncrypt:";
        logger.debug(method + " Entering...");
        if (devKey == null || symKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input parameters.");
        }
        String devKeyToken = null;
        try {
            devKeyToken = symKey.getOwningToken().getName();
            logger.debug(method + " symKey token: " + devKeyToken);
            logger.debug(method + " devKey token: " + devKey.getOwningToken().getName());
        }
        catch (TokenException tokenException) {
            // empty catch block
        }
        SymmetricKey des2 = this.extractDes2FromDes3(symKey, devKeyToken);
        result = this.wrapSessionKey(selectedToken, des2, devKey);
        return result;
    }

    public SymmetricKey makeDes3KeyDerivedFromDes2(SymmetricKey des3Key, String selectedToken) throws EBaseException {
        SymmetricKey des3 = null;
        String method = "SecureChannelProtocol.makeDes3KeyDerivedFromDes2:";
        logger.debug(method + " Entering ...");
        if (des3Key == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            long bitPosition = 0L;
            byte[] param = SecureChannelProtocol.longToBytes(bitPosition);
            SymmetricKey extracted16 = this.extractDes2FromDes3(des3Key, selectedToken);
            SymmetricKeyDeriver extract8 = token.getSymmetricKeyDeriver();
            extract8.initDerive(extracted16, 869L, param, null, 260L, 268L, 8L);
            SymmetricKey extracted8 = extract8.derive();
            logger.debug(method + " extracted8 key");
            SymmetricKeyDeriver concat = token.getSymmetricKeyDeriver();
            concat.initDerive(extracted16, extracted8, 864L, null, null, 306L, 268L, 0L);
            des3 = concat.derive();
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return des3;
    }

    public SymmetricKey extractDes2FromDes3(SymmetricKey baseKey, String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.extractDes2FromDes3:";
        logger.debug(method + " Entering: ");
        SymmetricKey extracted16 = null;
        if (baseKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            long bitPosition = 0L;
            byte[] param = SecureChannelProtocol.longToBytes(bitPosition);
            SymmetricKeyDeriver extract16 = token.getSymmetricKeyDeriver();
            extract16.initDerive(baseKey, 869L, param, null, 260L, 268L, 16L);
            extracted16 = extract16.derive();
        }
        catch (Exception e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e);
        }
        return extracted16;
    }

    public byte[] wrapSessionKey(String tokenName, SymmetricKey sessionKey, SymmetricKey wrappingKey) throws EBaseException {
        String method = "SecureChannelProtocol.wrapSessionKey";
        KeyWrapper keyWrap = null;
        byte[] wrappedSessKeyData = null;
        if (tokenName == null || sessionKey == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        SymmetricKey wrapper = null;
        wrapper = wrappingKey == null ? this.transportKey : wrappingKey;
        logger.debug(method + " wrapper key type: " + wrapper.getType());
        if (wrapper.getType() != SymmetricKey.AES) {
            logger.debug(method + "Trying to wrap a key with an DES key!");
            try {
                CryptoManager cm = this.getCryptoManger();
                CryptoToken token = this.returnTokenByName(tokenName, cm);
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES3_ECB);
                keyWrap.initWrap(wrapper, null);
                wrappedSessKeyData = keyWrap.wrap(sessionKey);
            }
            catch (Exception e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        if (wrapper.getType() == SymmetricKey.AES) {
            logger.debug(method + "Trying to wrap a key with an AES key!");
            try {
                CryptoManager cm = this.getCryptoManger();
                CryptoToken token = this.returnTokenByName(tokenName, cm);
                int ivLength = EncryptionAlgorithm.AES_128_CBC.getIVLength();
                byte[] iv = null;
                if (ivLength > 0) {
                    iv = new byte[ivLength];
                }
                keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.AES_CBC);
                keyWrap.initWrap(wrapper, (AlgorithmParameterSpec)new IVParameterSpec(iv));
                wrappedSessKeyData = keyWrap.wrap(sessionKey);
            }
            catch (Exception e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        logger.debug(method + " returning session key");
        return wrappedSessKeyData;
    }

    public byte[] computeAES_CBCEncryption(SymmetricKey symKey, String selectedToken, byte[] input, byte[] iv) throws EBaseException {
        String method = "SecureChannelProtocol.computeAES_CBCEncryption";
        byte[] output = null;
        byte[] finalIv = null;
        if (symKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        finalIv = iv == null ? new byte[16] : iv;
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.AES_128_CBC);
            encryptor.initEncrypt(symKey, (AlgorithmParameterSpec)new IVParameterSpec(finalIv));
            output = encryptor.doFinal(input);
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + e);
        }
        return output;
    }

    public byte[] computeDes3EcbEncryption(SymmetricKey desKey, String selectedToken, byte[] input) throws EBaseException {
        String method = "SecureChannelProtocol.computeDes3EcbEncryption";
        byte[] output = null;
        if (desKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        try {
            CryptoManager cm = this.getCryptoManger();
            CryptoToken token = this.returnTokenByName(selectedToken, cm);
            logger.debug(method + "desKey: owning token: " + desKey.getOwningToken().getName());
            logger.debug(method + "desKey: current token: " + token.getName());
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            logger.debug(method + "got encryptor");
            encryptor.initEncrypt(desKey);
            logger.debug(method + "done initEncrypt");
            output = encryptor.doFinal(input);
            logger.debug(method + "done doFinal");
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new EBaseException(method + e);
        }
        logger.debug("returning encrypted output.");
        return output;
    }

    public byte[] computeKeyCheck_SCP03(SymmetricKey symKey, String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.computeKeyCheck_SCP03:";
        if (symKey == null || selectedToken == null) {
            throw new EBaseException(method + " invalid input data!");
        }
        byte[] key_check_message = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] key_check_iv = new byte[16];
        byte[] output = null;
        byte[] finalOutput = new byte[3];
        try {
            output = this.computeAES_CBCEncryption(symKey, selectedToken, key_check_message, key_check_iv);
        }
        catch (EBaseException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw e;
        }
        System.arraycopy(output, 0, finalOutput, 0, 3);
        return finalOutput;
    }

    public byte[] computeCryptogram_SCP03(SymmetricKey symKey, String selectedToken, byte[] context, byte cryptoType) throws EBaseException {
        String method = "SecureChannelProtocol.computeCryptogram_";
        logger.debug(method + " entering ..");
        if (symKey == null || selectedToken == null || cryptoType != 0 && cryptoType != 1) {
            throw new EBaseException(method + " Invalid input data.");
        }
        NistSP800_108KDF nistKdf = new NistSP800_108KDF(this);
        byte[] crypto = nistKdf.kdf_AES_CMAC_SCP03(symKey, context, cryptoType, 8);
        byte[] finalCrypto = new byte[8];
        System.arraycopy(crypto, 0, finalCrypto, 0, 8);
        return finalCrypto;
    }

    public byte[] computeKeyCheck(SymmetricKey desKey, String selectedToken) throws EBaseException {
        String method = "SecureChannelProtocol.computeKeyCheck:";
        logger.debug(method + " Entering...");
        byte[] input = new byte[8];
        byte[] finalOutput = new byte[3];
        if (desKey == null || selectedToken == null) {
            throw new EBaseException(method + " Invalid input data.");
        }
        byte[] output = null;
        String keysToken = null;
        try {
            keysToken = desKey.getOwningToken().getName();
        }
        catch (TokenException e1) {
            throw new EBaseException(e1 + " Can't get owning token for key/");
        }
        try {
            output = this.computeDes3EcbEncryption(desKey, keysToken, input);
        }
        catch (EBaseException e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw e;
        }
        System.arraycopy(output, 0, finalOutput, 0, 3);
        logger.debug(method + " ends");
        return finalOutput;
    }

    public byte[] computeMAC_SCP01(SymmetricKey symKey, byte[] input, byte[] icv, String selectedToken) throws EBaseException {
        byte[] output = null;
        byte[] result = null;
        String method = "SecureChannelProtocol.computeMAC_SCP01:";
        logger.debug(method + " Entering...");
        if (symKey == null || input == null || icv == null || icv.length != 8) {
            throw new EBaseException(method + " invalid input data!");
        }
        int inputLen = input.length;
        byte[] macPad = new byte[8];
        macPad[0] = -128;
        CryptoToken token = null;
        try {
            byte a;
            CryptoManager cm = this.getCryptoManger();
            token = this.returnTokenByName(selectedToken, cm);
            Cipher cipher = token.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            cipher.initEncrypt(symKey);
            result = new byte[8];
            System.arraycopy(icv, 0, result, 0, 8);
            int inputOffset = 0;
            while (inputLen >= 8) {
                for (int i = 0; i < 8; ++i) {
                    result[i] = a = (byte)(result[i] ^ input[inputOffset + i]);
                }
                byte[] ciphResult = cipher.update(result);
                if (ciphResult.length != result.length) {
                    throw new EBaseException(method + " Invalid cipher!");
                }
                System.arraycopy(ciphResult, 0, result, 0, 8);
                inputLen -= 8;
                inputOffset += 8;
            }
            int i = 0;
            for (i = 0; i < inputLen; ++i) {
                result[i] = a = (byte)(result[i] ^ input[inputOffset + i]);
            }
            int padOffset = 0;
            while (i < 8) {
                byte a2;
                result[i] = a2 = (byte)(result[i] ^ macPad[padOffset++]);
                ++i;
            }
            output = cipher.doFinal(result);
            if (output.length != result.length) {
                throw new EBaseException(method + " Invalid cipher!");
            }
        }
        catch (Exception e) {
            throw new EBaseException(method + " Cryptographic problem encountered! " + e.toString());
        }
        return output;
    }

    public byte[] diversifyKey(String tokenName, String newTokenName, String oldMasterKeyName, String newMasterKeyName, byte[] oldKeyInfo, byte[] newKeyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] CUIDValue, byte[] KDD, byte[] kekKeyArray, byte[] encKeyArray, byte[] macKeyArray, String useSoftToken, String keySet, byte protocol, GPParams params) throws EBaseException {
        Map<String, SymmetricKey> keys;
        CryptoToken newToken;
        CryptoToken token;
        String fullNewMasterKeyName;
        byte[] output;
        SymmetricKey kekKey;
        SymmetricKey macKey;
        SymmetricKey encKey;
        SymmetricKey old_kek_sym_key;
        SymmetricKey old_enc_sym_key;
        SymmetricKey old_mac_sym_key;
        byte[] KDCkek;
        byte[] KDCmac;
        byte[] KDCenc;
        SymmetricKey oldMasterKey;
        SymmetricKey masterKey;
        String method;
        block37: {
            method = "SecureChannelProtocol.diversifyKey:";
            logger.debug(method + " Entering ... newTokenName: " + newTokenName + " protocol: " + protocol);
            logger.debug(method + " oldMasterKeyName: " + oldMasterKeyName);
            logger.debug(method + " newMasterKeyName: " + newMasterKeyName);
            masterKey = null;
            oldMasterKey = null;
            KDCenc = null;
            KDCmac = null;
            KDCkek = null;
            old_mac_sym_key = null;
            old_enc_sym_key = null;
            old_kek_sym_key = null;
            encKey = null;
            macKey = null;
            kekKey = null;
            output = null;
            if (oldMasterKeyName == null || oldKeyInfo == null || newKeyInfo == null || keySet == null || params == null) {
                throw new EBaseException(method + "Invalid input!");
            }
            if (oldKeyInfo.length < 2 || newKeyInfo.length < 2) {
                throw new EBaseException(method + " Invalid input length for keyinfo versions.");
            }
            fullNewMasterKeyName = this.getFullMasterKeyName(newMasterKeyName);
            String fullOldMasterKeyName = this.getFullMasterKeyName(oldMasterKeyName);
            logger.debug(method + " fullOldMasterKeyName: " + fullOldMasterKeyName);
            logger.debug(method + " fullNewMasterKeyName: " + fullNewMasterKeyName);
            CryptoManager cm = null;
            token = null;
            newToken = null;
            try {
                cm = CryptoManager.getInstance();
                token = this.returnTokenByName(tokenName, cm);
                if (newTokenName != null) {
                    newToken = this.returnTokenByName(newTokenName, cm);
                }
            }
            catch (NotInitializedException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
            catch (NoSuchTokenException e) {
                logger.error(method + " " + e.getMessage(), (Throwable)e);
                throw new EBaseException((Exception)((Object)e));
            }
            try {
                if (newToken != null) {
                    masterKey = SecureChannelProtocol.getSymKeyByName(newToken, fullNewMasterKeyName);
                }
                oldMasterKey = SecureChannelProtocol.getSymKeyByName(token, fullOldMasterKeyName);
            }
            catch (EBaseException e) {
                masterKey = null;
                logger.warn(method + " Master key is null, possibly ok in moving from keyset 2 to 1: " + e.getMessage());
                if (oldMasterKey != null) break block37;
                throw new EBaseException(method + " Can't retrieve old master key!");
            }
        }
        byte oldKeyVersion = oldKeyInfo[0];
        byte newKeyVersion = newKeyInfo[0];
        byte[] context = null;
        context = nistSP800_108KdfUseCuidAsKdd ? CUIDValue : KDD;
        if (context == null) {
            throw new EBaseException(method + "Invalid token id information included!");
        }
        StandardKDF standardKDF = new StandardKDF(this);
        NistSP800_108KDF nistKDF = new NistSP800_108KDF(this);
        KDCenc = KDF.getDiversificationData_VISA2(KDD, encType);
        KDCmac = KDF.getDiversificationData_VISA2(KDD, macType);
        KDCkek = KDF.getDiversificationData_VISA2(KDD, kekType);
        if (protocol == 2) {
            throw new EBaseException(method + " SCP 02 not yet supported here.");
        }
        String transportKeyName = SecureChannelProtocol.getSharedSecretKeyName(null);
        if (this.checkForDeveloperKeySet(oldMasterKeyName)) {
            logger.debug(method + " Developer key set case:  protocol: " + protocol);
        } else {
            logger.debug(method + " Not Developer key set case: ");
            if (protocol == 1) {
                if (NistSP800_108KDF.useThisKDF(nistSP800_108KdfOnKeyVersion, oldKeyVersion)) {
                    logger.debug(method + " NistSP800_108KDF code: Using NIST SP800-108 KDF.");
                    keys = null;
                    try {
                        keys = nistKDF.computeCardKeys(oldMasterKey, context, token);
                    }
                    catch (EBaseException e) {
                        logger.error(method + "Can't compute card keys! " + e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    old_enc_sym_key = keys.get(encType);
                    old_mac_sym_key = keys.get(macType);
                    old_kek_sym_key = keys.get(kekType);
                    if (old_enc_sym_key == null || old_mac_sym_key == null || old_kek_sym_key == null) {
                        throw new EBaseException(method + " Can't derive session keys with Nist KDF.");
                    }
                } else {
                    logger.debug(method + " ComputeSessionKey NistSP800_108KDF code: Using original KDF.");
                    old_kek_sym_key = standardKDF.computeCardKey(oldMasterKey, KDCkek, token, 1);
                }
            } else {
                old_kek_sym_key = this.computeSessionKey_SCP03(tokenName, oldMasterKeyName, oldKeyInfo, kekType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                logger.debug(method + " Moving back to the developer key set case, protocol 3");
            }
        }
        if (fullNewMasterKeyName != null && (fullNewMasterKeyName.equals("#01#01") || fullNewMasterKeyName.contains("#01#03"))) {
            if (protocol == 1) {
                logger.debug(method + " Special case returning to the dev key set (1) for DiversifyKey, protocol 1!");
                encKey = this.returnDeveloperSymKey(newToken, encType, keySet, null, "DES3");
                macKey = this.returnDeveloperSymKey(newToken, macType, keySet, null, "DES3");
                kekKey = this.returnDeveloperSymKey(newToken, kekType, keySet, null, "DES3");
            } else if (protocol == 3) {
                logger.debug(method + " Special case or returning to the dev key set (or ver 1) for DiversifyKey, protocol 3!");
                encKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, newKeyInfo, encType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                macKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, newKeyInfo, macType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                kekKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, newKeyInfo, kekType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
            }
        } else {
            logger.debug(method + " Compute card key on token case ! For new key version.");
            if (protocol == 1) {
                if (NistSP800_108KDF.useThisKDF(nistSP800_108KdfOnKeyVersion, newKeyVersion)) {
                    logger.debug(method + " NistSP800_108KDF code: Using NIST SP800-108 KDF. For new key version.");
                    keys = null;
                    try {
                        keys = nistKDF.computeCardKeys(masterKey, context, newToken);
                    }
                    catch (EBaseException e) {
                        logger.error(method + "Can't compute card keys! For new key version. " + e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    encKey = keys.get(encType);
                    macKey = keys.get(macType);
                    kekKey = keys.get(kekType);
                } else {
                    logger.debug(method + " ComputeSessionKey NistSP800_108KDF code: Using original KDF. For new key version.");
                    encKey = standardKDF.computeCardKeyOnToken(masterKey, KDCenc, protocol);
                    macKey = standardKDF.computeCardKeyOnToken(masterKey, KDCmac, protocol);
                    kekKey = standardKDF.computeCardKeyOnToken(masterKey, KDCkek, protocol);
                }
            } else {
                logger.debug(method + " Generating new card keys to upgrade to, protocol 3.");
                logger.debug("tokenName: " + tokenName + " newTokenName: " + newTokenName);
                encKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, oldKeyInfo, encType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                macKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, oldKeyInfo, macType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                kekKey = this.computeSessionKey_SCP03(newTokenName, newMasterKeyName, oldKeyInfo, kekType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
                old_kek_sym_key = this.computeSessionKey_SCP03(tokenName, oldMasterKeyName, oldKeyInfo, kekType, kekKeyArray, keySet, CUIDValue, KDD, null, null, transportKeyName, params);
            }
            if (encKey == null || macKey == null || kekKey == null) {
                throw new EBaseException(method + " Can't derive session keys with selected KDF. For new key version.");
            }
        }
        boolean showKeysForDebug = false;
        if (showKeysForDebug) {
            try {
                SecureChannelProtocol.debugByteArray(encKey.getKeyData(), "DiversifyKey: new encKey: ");
                SecureChannelProtocol.debugByteArray(macKey.getKeyData(), "DiversifyKey: new macKey:");
                SecureChannelProtocol.debugByteArray(kekKey.getKeyData(), "DiversifyKey: new kekKey");
            }
            catch (SymmetricKey.NotExtractableException e) {
                logger.warn(method + " Can not display debugging info for key");
            }
        }
        if (old_kek_sym_key != null) {
            logger.debug(method + " old kek sym key is not null");
            output = this.createKeySetDataWithSymKeys(newKeyVersion, null, old_kek_sym_key, encKey, macKey, kekKey, protocol, tokenName);
        } else {
            logger.debug(method + " old kek sym key is null");
            String devKeyType = null;
            devKeyType = protocol == 3 ? params.getDevKeyType() : "DES3";
            old_kek_sym_key = this.returnDeveloperSymKey(token, kekType, keySet, kekKeyArray, devKeyType);
            output = this.createKeySetDataWithSymKeys(newKeyVersion, null, old_kek_sym_key, encKey, macKey, kekKey, protocol, tokenName);
        }
        return output;
    }

    private byte[] createKeySetDataWithSymKeys(byte newKeyVersion, byte[] old_kek_key_array, SymmetricKey old_kek_sym_key, SymmetricKey encKey, SymmetricKey macKey, SymmetricKey kekKey, byte protocol, String tokenName) throws EBaseException {
        SymmetricKey wrappingKey = null;
        String method = "SecureChannelProtocol.createKeySetDataWithSymKeys:";
        byte alg = -127;
        byte[] output = null;
        if (encKey == null || macKey == null || kekKey == null || tokenName == null) {
            throw new EBaseException(method + " Invalid input data!");
        }
        CryptoManager cm = null;
        CryptoToken token = null;
        try {
            cm = CryptoManager.getInstance();
            token = this.returnTokenByName(tokenName, cm);
        }
        catch (NotInitializedException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        catch (NoSuchTokenException e) {
            logger.error(method + " " + e.getMessage(), (Throwable)e);
            throw new EBaseException((Exception)((Object)e));
        }
        SymmetricKey encKey16 = null;
        SymmetricKey macKey16 = null;
        SymmetricKey kekKey16 = null;
        byte[] encrypted_enc_key = null;
        byte[] encrypted_mac_key = null;
        byte[] encrypted_kek_key = null;
        byte[] keycheck_enc_key = null;
        byte[] keycheck_mac_key = null;
        byte[] keycheck_kek_key = null;
        if (protocol == 1) {
            if (old_kek_sym_key == null) {
                logger.debug(method + " Using old kek key array.");
                wrappingKey = this.unwrapSymKeyOnToken(token, old_kek_key_array, false);
            } else {
                logger.debug(method + " Using input old key key sym key.");
                wrappingKey = old_kek_sym_key;
            }
            logger.debug(method + "Wrapping key: length: " + wrappingKey.getLength());
            alg = -127;
            encKey16 = this.extractDes2FromDes3(encKey, tokenName);
            macKey16 = this.extractDes2FromDes3(macKey, tokenName);
            kekKey16 = this.extractDes2FromDes3(kekKey, tokenName);
            encrypted_enc_key = this.wrapSessionKey(tokenName, encKey16, wrappingKey);
            encrypted_mac_key = this.wrapSessionKey(tokenName, macKey16, wrappingKey);
            encrypted_kek_key = this.wrapSessionKey(tokenName, kekKey16, wrappingKey);
            keycheck_enc_key = this.computeKeyCheck(encKey, tokenName);
            keycheck_mac_key = this.computeKeyCheck(macKey, tokenName);
            keycheck_kek_key = this.computeKeyCheck(kekKey, tokenName);
        } else {
            if (protocol == 2) {
                throw new EBaseException(method + " SCP 02 not yet implemented!");
            }
            if (protocol == 3) {
                logger.debug(method + " Attempting SCP03");
                if (old_kek_sym_key == null) {
                    logger.debug(method + " SCP03: Using old kek key array.");
                    wrappingKey = this.unwrapAESSymKeyOnToken(token, old_kek_key_array, false);
                } else {
                    logger.debug(method + "SCP03: Using input old key key sym key.");
                    wrappingKey = old_kek_sym_key;
                }
                alg = -120;
                encrypted_enc_key = this.wrapSessionKey(tokenName, encKey, wrappingKey);
                encrypted_mac_key = this.wrapSessionKey(tokenName, macKey, wrappingKey);
                encrypted_kek_key = this.wrapSessionKey(tokenName, kekKey, wrappingKey);
                try {
                    keycheck_enc_key = this.computeKeyCheck_SCP03(encKey, encKey.getOwningToken().getName());
                    keycheck_mac_key = this.computeKeyCheck_SCP03(macKey, macKey.getOwningToken().getName());
                    keycheck_kek_key = this.computeKeyCheck_SCP03(kekKey, kekKey.getOwningToken().getName());
                }
                catch (TokenException e) {
                    throw new EBaseException(method + e);
                }
            } else {
                throw new EBaseException(method + " Invalid SCP version requested!");
            }
        }
        byte[] b1 = null;
        byte[] b2 = null;
        b1 = protocol == 3 ? new byte[]{alg, 17, (byte)encrypted_enc_key.length} : new byte[]{alg, 16};
        b2 = new byte[]{3};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(newKeyVersion);
            outputStream.write(b1);
            outputStream.write(encrypted_enc_key);
            outputStream.write(b2);
            outputStream.write(keycheck_enc_key);
            outputStream.write(b1);
            outputStream.write(encrypted_mac_key);
            outputStream.write(b2);
            outputStream.write(keycheck_mac_key);
            outputStream.write(b1);
            outputStream.write(encrypted_kek_key);
            outputStream.write(b2);
            outputStream.write(keycheck_kek_key);
            output = outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new EBaseException(method + " Can't compose final output byte array!");
        }
        logger.debug(method + " returning output");
        return output;
    }

    private String getFullMasterKeyName(String masterKeyName) {
        if (masterKeyName == null) {
            return null;
        }
        Object fullMasterKeyName = null;
        fullMasterKeyName = "";
        if (masterKeyName.length() > 0) {
            fullMasterKeyName = (String)fullMasterKeyName + masterKeyName;
        }
        return fullMasterKeyName;
    }

    private boolean checkForDeveloperKeySet(String keyInfo) {
        if (keyInfo == null) {
            return true;
        }
        if (keyInfo.equals("#01#01") || keyInfo.equals("#FF#01")) {
            return true;
        }
        if (keyInfo.equals("#01#02") || keyInfo.equals("#FF#02")) {
            return true;
        }
        return keyInfo.contains("#01#03") || keyInfo.contains("#FF#03");
    }

    public static void setDefaultPrefix(String masterkeyPrefix) {
        if (masterKeyPrefix == null) {
            masterKeyPrefix = masterkeyPrefix;
        }
    }

    public byte[] encryptData_SCP03(String selectedToken, String keyNickName, byte[] data, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, byte[] kekKeyArray, String useSoftToken_s, String keySet, GPParams params) throws EBaseException {
        String method = "SecureChannelProtocol.encryptData_SCP03:";
        logger.debug(method + " Entering ....");
        String transportKeyName = SecureChannelProtocol.getSharedSecretKeyName(null);
        if (keyInfo == null || keySet == null || keyInfo == null || keyInfo.length < 2 || params == null) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (xCUID == null || xCUID.length <= 0) {
            throw new EBaseException(method + "CUID invalid size!");
        }
        if (xKDD == null || xKDD.length != 10) {
            throw new EBaseException(method + "KDD invalid size!");
        }
        SymmetricKey kekKey = this.computeSessionKey_SCP03(selectedToken, keyNickName, keyInfo, kekType, kekKeyArray, keySet, xCUID, xKDD, null, null, transportKeyName, params);
        byte[] output = null;
        output = this.computeAES_CBCEncryption(kekKey, selectedToken, data, null);
        return output;
    }

    public byte[] encryptData(String selectedToken, String keyNickName, byte[] data, byte[] keyInfo, byte nistSP800_108KdfOnKeyVersion, boolean nistSP800_108KdfUseCuidAsKdd, byte[] xCUID, byte[] xKDD, byte[] kekKeyArray, String useSoftToken_s, String keySet) throws EBaseException {
        String method = "SecureChannelProtocol.encryptData:";
        logger.debug(method + " Entering ....");
        String transportKeyName = SecureChannelProtocol.getSharedSecretKeyName(null);
        if (keyInfo == null || keySet == null || keyInfo == null || keyInfo.length < 2) {
            throw new EBaseException(method + "Invalid input!");
        }
        if (xCUID == null || xCUID.length <= 0) {
            throw new EBaseException(method + "CUID invalid size!");
        }
        if (xKDD == null || xKDD.length != 10) {
            throw new EBaseException(method + "KDD invalid size!");
        }
        SymmetricKey kekKey = this.computeSessionKey_SCP01(kekType, selectedToken, keyNickName, null, null, keyInfo, nistSP800_108KdfOnKeyVersion, nistSP800_108KdfUseCuidAsKdd, xCUID, xKDD, kekKeyArray, useSoftToken_s, keySet, transportKeyName);
        byte[] output = this.computeDes3EcbEncryption(kekKey, selectedToken, data);
        return output;
    }
}

