/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CMSCRLExtensions;
import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.ElementProcessor;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPoint;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRecordProcessor
extends ElementProcessor {
    public static final Logger logger = LoggerFactory.getLogger(CertRecordProcessor.class);
    private Map<BigInteger, RevokedCertificate> crlCerts;
    private boolean allowExtensions;
    private CRLIssuingPoint issuingPoint;
    private boolean issuingDistPointAttempted;
    private boolean issuingDistPointEnabled;
    private BitArray onlySomeReasons;

    public CertRecordProcessor(Map<BigInteger, RevokedCertificate> crlCerts, CRLIssuingPoint ip, boolean allowExtensions) {
        this.crlCerts = crlCerts;
        this.issuingPoint = ip;
        this.allowExtensions = allowExtensions;
    }

    private boolean initCRLIssuingDistPointExtension() {
        boolean result = false;
        CMSCRLExtensions exts = null;
        if (this.issuingDistPointAttempted) {
            return this.issuingDistPointEnabled && this.onlySomeReasons != null;
        }
        this.issuingDistPointAttempted = true;
        exts = this.issuingPoint.getCRLExtensions();
        if (exts == null) {
            return result;
        }
        boolean isIssuingDistPointExtEnabled = false;
        isIssuingDistPointExtEnabled = exts.isCRLExtensionEnabled("IssuingDistributionPoint");
        if (!isIssuingDistPointExtEnabled) {
            this.issuingDistPointEnabled = false;
            return false;
        }
        this.issuingDistPointEnabled = true;
        CRLExtensions ext = new CRLExtensions();
        Vector<String> extNames = exts.getCRLExtensionNames();
        for (String extName : extNames) {
            if (!extName.equals("IssuingDistributionPoint")) continue;
            exts.addToCRLExtensions(ext, extName, null);
        }
        Extension issuingDistExt = null;
        try {
            issuingDistExt = ext.get("IssuingDistributionPoint");
        }
        catch (Exception extName) {
            // empty catch block
        }
        IssuingDistributionPointExtension iExt = null;
        if (issuingDistExt != null) {
            iExt = (IssuingDistributionPointExtension)issuingDistExt;
        }
        IssuingDistributionPoint issuingDistributionPoint = null;
        if (iExt != null) {
            issuingDistributionPoint = iExt.getIssuingDistributionPoint();
        }
        BitArray osr = null;
        if (issuingDistributionPoint != null) {
            osr = issuingDistributionPoint.getOnlySomeReasons();
        }
        boolean applyReasonMatch = false;
        if (osr != null) {
            applyReasonMatch = !osr.toString().equals("0000000");
            logger.debug("applyReasonMatch {}", (Object)applyReasonMatch);
            if (applyReasonMatch) {
                this.onlySomeReasons = osr;
                result = true;
            }
        }
        return result;
    }

    private boolean checkOnlySomeReasonsExtension(CRLExtensions entryExts) {
        boolean includeCert = true;
        if (entryExts == null) {
            return includeCert;
        }
        Extension crlReasonExt = null;
        try {
            crlReasonExt = entryExts.get("CRLReason");
        }
        catch (Exception e) {
            return includeCert;
        }
        RevocationReason reason = null;
        int reasonIndex = 0;
        if (crlReasonExt != null) {
            try {
                CRLReasonExtension theReason = (CRLReasonExtension)crlReasonExt;
                reason = (RevocationReason)theReason.get("value");
                reasonIndex = reason.getCode();
                logger.debug("revoked reason {}", (Object)reason);
            }
            catch (Exception e) {
                return includeCert;
            }
        } else {
            return includeCert;
        }
        boolean reasonMatch = false;
        if (this.onlySomeReasons != null) {
            reasonMatch = this.onlySomeReasons.get(reasonIndex);
            if (reasonMatch) {
                logger.debug("onlySomeReasons match! reason: {}", (Object)reason);
            } else {
                includeCert = false;
            }
        }
        return includeCert;
    }

    public boolean checkRevokedCertExtensions(CRLExtensions crlExtensions) {
        boolean includeCert = true;
        if (crlExtensions == null || !this.allowExtensions) {
            return includeCert;
        }
        boolean inited = this.initCRLIssuingDistPointExtension();
        if (!inited) {
            return includeCert;
        }
        includeCert = this.checkOnlySomeReasonsExtension(crlExtensions);
        return includeCert;
    }

    public void process(Object o) {
        CertRecord certRecord = (CertRecord)o;
        BigInteger serialNumber = certRecord.getSerialNumber();
        CertId certID = new CertId(serialNumber);
        Date revocationDate = certRecord.getRevocationDate();
        RevocationInfo revInfo = certRecord.getRevocationInfo();
        CRLExtensions entryExt = null;
        CRLExtensions crlExts = null;
        if (revInfo != null) {
            crlExts = revInfo.getCRLEntryExtensions();
            entryExt = this.issuingPoint.getRequiredEntryExtensions(crlExts);
        }
        RevokedCertImpl newRevokedCert = new RevokedCertImpl(serialNumber, revocationDate, entryExt);
        boolean includeCert = this.checkRevokedCertExtensions(crlExts);
        if (includeCert) {
            logger.info("CertRecordProcessor: Adding cert {} into CRL", (Object)certID.toHexString());
            this.crlCerts.put(serialNumber, (RevokedCertificate)newRevokedCert);
        }
    }
}

