/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.updater;

import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.updater.ProfileUpdater;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemGroupUpdater
extends ProfileUpdater {
    public static Logger logger = LoggerFactory.getLogger(SubsystemGroupUpdater.class);
    private ConfigStore mConfig;
    private Vector<String> mConfigNames = new Vector();

    @Override
    public void init(ConfigStore config) throws EProfileException {
        this.mConfig = config;
    }

    public Enumeration<String> getConfigNames() {
        return this.mConfigNames.elements();
    }

    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") != null) {
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }

    public String getConfig(String name) {
        try {
            if (this.mConfig == null) {
                return null;
            }
            if (this.mConfig.getSubStore("params") != null) {
                return this.mConfig.getSubStore("params").getString(name);
            }
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    @Override
    public void update(Request req, RequestStatus status) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        logger.info("SubsystemGroupUpdater: Updating Subsystem Group");
        if (status != req.getRequestStatus()) {
            return;
        }
        X509CertImpl cert = req.getExtDataInCert("req_issued_cert");
        if (cert == null) {
            return;
        }
        UGSubsystem system = engine.getUGSubsystem();
        String requestor_name = "subsystem";
        try {
            requestor_name = req.getExtDataInString("requestor_name");
        }
        catch (Exception e) {
            logger.warn("SubsystemGroupUpdater: Unable to get requestor name: " + e.getMessage(), (Throwable)e);
        }
        String id = requestor_name;
        String auditParams = "Scope;;users+Operation;;OP_ADD+source;;SubsystemGroupUpdater+Resource;;" + id + "+fullname;;" + id + "+state;;1+userType;;agentType+email;;<null>+password;;<null>+phone;;<null>";
        logger.info("SubsystemGroupUpdater: Adding user " + id);
        try {
            User user = system.createUser(id);
            user.setFullName(id);
            user.setEmail("");
            user.setPassword("");
            user.setUserType("agentType");
            user.setState("1");
            user.setPhone("");
            system.addUser(user);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
        }
        catch (ConflictingOperationException e) {
            logger.warn("UpdateSubsystemGroup: User already exists: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("UpdateSubsystemGroup: Unable to add user: " + e.getMessage(), (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            throw new EProfileException("Unable to add user: " + e.getMessage(), (Throwable)e);
        }
        logger.info("SubsystemGroupUpdater: Adding certificate for user " + id);
        try {
            String b64 = "<null>";
            try {
                byte[] certEncoded = cert.getEncoded();
                b64 = Utils.base64encode((byte[])certEncoded, (boolean)true).trim();
                b64 = b64.replace("\r", "").replace("\n", "");
            }
            catch (Exception e) {
                logger.warn("SubsystemGroupUpdater: Unable to encode certificate: " + e.getMessage(), (Throwable)e);
            }
            auditParams = "Scope;;certs+Operation;;OP_ADD+source;;SubsystemGroupUpdater+Resource;;" + id + "+cert;;" + b64;
            system.addUserCert(id, (X509Certificate)cert);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
        }
        catch (ConflictingOperationException e) {
            logger.warn("UpdateSubsystemGroup: Certificate already exists: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("UpdateSubsystemGroup: Unable to add certificate for user " + id + ": " + e.getMessage(), (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            throw new EProfileException("Unable to add certificate: " + e.getMessage(), (Throwable)e);
        }
        String groupName = "Subsystem Group";
        logger.info("SubsystemGroupUpdater: Adding user " + id + " into group " + groupName);
        auditParams = "Scope;;groups+Operation;;OP_MODIFY+source;;SubsystemGroupUpdater+Resource;;" + groupName;
        try {
            Group group = system.getGroupFromName(groupName);
            auditParams = auditParams + "+user;;";
            Enumeration members = group.getMemberNames();
            while (members.hasMoreElements()) {
                auditParams = auditParams + (String)members.nextElement();
                if (!members.hasMoreElements()) continue;
                auditParams = auditParams + ",";
            }
            if (!group.isMember(id)) {
                auditParams = auditParams + "," + id;
                group.addMemberName(id);
                system.modifyGroup(group);
                auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
            } else {
                logger.info("SubsystemGroupUpdater: User " + id + " already in group " + groupName);
            }
        }
        catch (Exception e) {
            logger.warn("SubsystemGroupUpdater: Unable to add user " + id + " into group " + groupName + ": " + e.getMessage(), (Throwable)e);
            auditor.log((LogEvent)new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
        }
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_UPDATER_SUBSYSTEM_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_UPDATER_SUBSYSTEM_TEXT", (String[])new String[0]);
    }

    private String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }
}

