/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.authentication.HashAuthentication;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashEnrollServlet
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(HashEnrollServlet.class);
    private static final long serialVersionUID = 5532936020515258333L;
    public static final String ADMIN_ENROLL_SERVLET_ID = "adminEnroll";
    public static final String ENROLL_SUCCESS_TEMPLATE = "/ra/HashEnrollSuccess.template";
    public static final String OLD_CERT_TYPE = "csrCertType";
    public static final String CERT_TYPE = "certType";
    public static final String REQUEST_FORMAT = "reqFormat";
    public static final String REQUEST_CONTENT = "requestContent";
    public static final String SUBJECT_KEYGEN_INFO = "subjectKeyGenInfo";
    public static final String CRMF_REQUEST = "CRMFRequest";
    public static final String SUBJECT_NAME = "subject";
    public static final String CRMF_REQID = "crmfReqId";
    public static final String CHALLENGE_PASSWORD = "challengePhrase";
    private static final String CERT_AUTH_DUAL = "dual";
    private static final String CERT_AUTH_ENCRYPTION = "encryption";
    private static final String CERT_AUTH_SINGLE = "single";
    private static final String CLIENT_ISSUER = "clientIssuer";
    public static final String TPL_ERROR_FILE = "/ra/GenErrorHashDirEnroll.template";
    private String mEnrollSuccessTemplate = null;
    private ICMSTemplateFiller mEnrollSuccessFiller = new ImportCertsTemplateFiller();
    CertificateAuthority mCa;
    CertificateRepository mRepository;
    private boolean mIsTestBed = false;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        try {
            ICMSTemplateFiller filler;
            String fillername;
            this.mEnrollSuccessTemplate = sc.getInitParameter("successTemplate");
            if (this.mEnrollSuccessTemplate == null) {
                this.mEnrollSuccessTemplate = ENROLL_SUCCESS_TEMPLATE;
            }
            if ((fillername = sc.getInitParameter("successTemplateFiller")) != null && (filler = this.newFillerObject(fillername)) != null) {
                this.mEnrollSuccessFiller = filler;
            }
            CAEngine engine = CAEngine.getInstance();
            this.mCa = engine.getCA();
            this.init_testbed_hack(this.mConfig);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_IMP_INIT_SERV_ERR", (Object[])new Object[]{e.toString(), this.mId}));
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        String certType = null;
        String reqHost = httpReq.getRemoteHost();
        String host = httpParams.getValueAsString("hostname", null);
        if (host == null || !host.equals(reqHost)) {
            this.printError(cmsReq, "0");
            cmsReq.setStatus(CMSRequest.SUCCESS);
            return;
        }
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig configStore = engine.getConfig();
        String val = configStore.getString("hashDirEnrollment.name");
        AuthSubsystem authSS = engine.getAuthSubsystem();
        AuthManager authMgr = authSS.get(val);
        HashAuthentication mgr = (HashAuthentication)authMgr;
        Date date = new Date();
        long currTime = date.getTime();
        long timeout = mgr.getTimeout(reqHost);
        long lastlogin = mgr.getLastLogin(reqHost);
        long diff = currTime - lastlogin;
        boolean enable = mgr.isEnable(reqHost);
        if (!enable) {
            this.printError(cmsReq, "0");
            cmsReq.setStatus(CMSRequest.SUCCESS);
            return;
        }
        if (lastlogin == 0L) {
            mgr.setLastLogin(reqHost, currTime);
        } else if (diff > timeout) {
            mgr.disable(reqHost);
            this.printError(cmsReq, "2");
            cmsReq.setStatus(CMSRequest.SUCCESS);
            return;
        }
        mgr.setLastLogin(reqHost, currTime);
        certType = httpParams.getValueAsString(OLD_CERT_TYPE, null);
        if (certType == null) {
            certType = httpParams.getValueAsString(CERT_TYPE, "client");
        }
        this.processX509(cmsReq);
    }

    private void printError(CMSRequest cmsReq, String errorCode) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        header.addStringValue("authority", "Registration Manager");
        header.addStringValue("errorCode", errorCode);
        String formPath = TPL_ERROR_FILE;
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(formPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{formPath, e.toString()}), (Throwable)e);
            cmsReq.setError((EBaseException)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        try {
            ServletOutputStream out = httpResp.getOutputStream();
            httpResp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{e.toString()}), (Throwable)e);
            cmsReq.setError((EBaseException)new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processX509(CMSRequest cmsReq) throws EBaseException {
        String authMgr;
        AuthToken authToken;
        X509CertInfo[] certInfoArray;
        CertInfo certInfo;
        String challengePassword;
        Request req;
        ArgBlock httpParams;
        block66: {
            String crmf;
            HttpServletRequest httpReq;
            block67: {
                httpParams = cmsReq.getHttpParams();
                httpReq = cmsReq.getHttpReq();
                CAEngine engine = CAEngine.getInstance();
                CertRequestRepository requestRepository = engine.getCertRequestRepository();
                req = requestRepository.createRequest("enrollment");
                boolean certAuthEnroll = false;
                String certAuthEnrollOn = httpParams.getValueAsString("certauthEnroll", null);
                if (certAuthEnrollOn != null && certAuthEnrollOn.equals("on")) {
                    certAuthEnroll = true;
                    logger.debug("HashEnrollServlet: certAuthEnroll is on");
                }
                String certauthEnrollType = null;
                if (certAuthEnroll) {
                    certauthEnrollType = httpParams.getValueAsString("certauthEnrollType", null);
                    if (certauthEnrollType == null) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTAUTH_ENROLL_TYPE", (Object[])new Object[0]));
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CERTAUTH_ENROLL_TYPE", (String[])new String[0]));
                    }
                    if (certauthEnrollType.equals(CERT_AUTH_DUAL)) {
                        logger.debug("HashEnrollServlet: certauthEnrollType is dual");
                    } else if (certauthEnrollType.equals(CERT_AUTH_ENCRYPTION)) {
                        logger.debug("HashEnrollServlet: certauthEnrollType is encryption");
                    } else {
                        if (!certauthEnrollType.equals(CERT_AUTH_SINGLE)) {
                            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERTAUTH_ENROLL_TYPE_1", (Object[])new Object[]{certauthEnrollType}));
                            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERTAUTH_ENROLL_TYPE", (String[])new String[0]));
                        }
                        logger.debug("HashEnrollServlet: certauthEnrollType is single");
                    }
                }
                challengePassword = httpParams.getValueAsString("challengePassword", "");
                cmsReq.setRequest(req);
                this.saveHttpHeaders(httpReq, req);
                this.saveHttpParams(httpParams, req);
                CAEngineConfig configStore = engine.getConfig();
                CertificateRepository cr = engine.getCertificateRepository();
                AuthToken token = this.authenticate(cmsReq);
                AuthzToken authzToken = null;
                try {
                    authzToken = this.authorize(this.mAclMethod, token, this.mAuthzResourceName, "import");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (authzToken == null) {
                    cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                    return;
                }
                X509Certificate sslClientCert = null;
                String certBasedOldSubjectDN = null;
                BigInteger certBasedOldSerialNum = null;
                certInfo = null;
                if (certAuthEnroll) {
                    sslClientCert = this.getSSLClientCertificate(httpReq);
                    if (sslClientCert == null) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SSL_CLIENT_CERT", (Object[])new Object[0]));
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_SSL_CLIENT_CERT", (String[])new String[0]));
                    }
                    certBasedOldSubjectDN = sslClientCert.getSubjectDN().toString();
                    certBasedOldSerialNum = sslClientCert.getSerialNumber();
                    try {
                        certInfo = (X509CertInfo)((X509CertImpl)sslClientCert).get("x509.info");
                    }
                    catch (CertificateParsingException ex) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTINFO_ENCRYPT_CERT", (Object[])new Object[0]), (Throwable)ex);
                        throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_CERTINFO", (String[])new String[0]));
                    }
                } else {
                    certInfo = new CertInfo();
                }
                certInfoArray = new X509CertInfo[]{certInfo};
                String val = configStore.getString("hashDirEnrollment.name");
                AuthSubsystem authSS = engine.getAuthSubsystem();
                AuthManager authMgr1 = authSS.get(val);
                HashAuthentication mgr = (HashAuthentication)authMgr1;
                String pageID = httpParams.getValueAsString("pageID", null);
                authToken = mgr.getAuthToken(pageID);
                authMgr = "noAuthManager";
                if (authToken == null) {
                    this.printError(cmsReq, "3");
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                    return;
                }
                authMgr = authToken.getInString("authMgrInstName");
                logger.info("Enrollment request was authenticated by " + authToken.getInString("authMgrInstName"));
                this.fillCertInfoFromAuthToken((X509CertInfo)certInfo, authToken);
                HashEnrollServlet.saveAuthToken((AuthToken)authToken, (Request)req);
                String certType = httpParams.getValueAsString(OLD_CERT_TYPE, null);
                if (certType == null) {
                    certType = httpParams.getValueAsString(CERT_TYPE, "client");
                } else {
                    req.setExtData("HTTP_PARAMS", CERT_TYPE, certType);
                }
                crmf = httpParams.getValueAsString(CRMF_REQUEST, null);
                if (!certAuthEnroll) break block67;
                this.fillCertInfoFromAuthToken((X509CertInfo)certInfo, authToken);
                if (certauthEnrollType.equals(CERT_AUTH_DUAL)) {
                    if (this.mCa == null) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_NOT_A_CA", (Object[])new Object[0]));
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NOT_A_CA", (String[])new String[0]));
                    }
                    if (!CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) || CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) && CertUtils.isEncryptionCert((X509CertImpl)((X509CertImpl)sslClientCert))) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERT_TYPE", (Object[])new Object[0]));
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_TYPE", (String[])new String[0]));
                    }
                    X509Key key = null;
                    key = (X509Key)sslClientCert.getPublicKey();
                    try {
                        certInfo.set("key", (Object)new CertificateX509Key(key));
                    }
                    catch (CertificateException e) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                    }
                    catch (IOException e) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                    }
                    String filter = "(&(x509cert.subject=" + certBasedOldSubjectDN + ")(!(x509cert.serialNumber=" + certBasedOldSerialNum + "))(certStatus=VALID))";
                    CertRecordList list = cr.findCertRecordsInList(filter, null, 10);
                    int size = list.getSize();
                    Enumeration en = list.getCertRecords(0, size - 1);
                    boolean gotEncCert = false;
                    if (en.hasMoreElements()) {
                        CertInfo encCertInfo = new CertInfo();
                        X509CertInfo[] cInfoArray = new X509CertInfo[]{certInfo, encCertInfo};
                        int i = 1;
                        while (en.hasMoreElements()) {
                            CertRecord record = (CertRecord)en.nextElement();
                            X509CertImpl cert = record.getCertificate();
                            if (!CertUtils.isEncryptionCert((X509CertImpl)cert) || CertUtils.isEncryptionCert((X509CertImpl)cert) && CertUtils.isSigningCert((X509CertImpl)cert)) continue;
                            key = (X509Key)cert.getPublicKey();
                            try {
                                encCertInfo = (X509CertInfo)cert.get("x509.info");
                            }
                            catch (CertificateParsingException ex) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTINFO_ENCRYPT_CERT", (Object[])new Object[0]), (Throwable)ex);
                                throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_CERTINFO", (String[])new String[0]), (Exception)ex);
                            }
                            try {
                                encCertInfo.set("key", (Object)new CertificateX509Key(key));
                            }
                            catch (CertificateException e) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                            }
                            catch (IOException e) {
                                logger.error(CMS.getLogMessage((String)"CMSGW_FAILED_SET_KEY_FROM_CERT_AUTH_ENROLL_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_KEY_FROM_CERT_AUTH_ENROLL_FAILED", (String[])new String[]{e.toString()}), (Exception)e);
                            }
                            this.fillCertInfoFromAuthToken((X509CertInfo)encCertInfo, authToken);
                            cInfoArray[i++] = encCertInfo;
                            certInfoArray = cInfoArray;
                            gotEncCert = true;
                            break;
                        }
                    }
                    if (!gotEncCert) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_ENCRYPTION_CERT_NOT_FOUND", (Object[])new Object[0]));
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_ENCRYPTION_CERT_NOT_FOUND", (String[])new String[0]));
                    }
                    break block66;
                } else {
                    if (certauthEnrollType.equals(CERT_AUTH_ENCRYPTION)) {
                        if (!CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) || CertUtils.isSigningCert((X509CertImpl)((X509CertImpl)sslClientCert)) && CertUtils.isEncryptionCert((X509CertImpl)((X509CertImpl)sslClientCert))) {
                            logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_CERT_TYPE", (Object[])new Object[0]));
                            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_TYPE", (String[])new String[0]));
                        }
                        if (crmf != null && crmf != "") {
                            certInfoArray = this.fillCRMF(crmf, authToken, httpParams, req);
                            req.setExtData(CLIENT_ISSUER, sslClientCert.getIssuerDN().toString());
                            logger.debug("HashEnrollServlet: sslClientCert issuerDN = " + sslClientCert.getIssuerDN());
                            break block66;
                        } else {
                            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
                        }
                    }
                    if (certauthEnrollType.equals(CERT_AUTH_SINGLE)) {
                        if (crmf != null && crmf != "") {
                            certInfoArray = this.fillCRMF(crmf, authToken, httpParams, req);
                            req.setExtData(CLIENT_ISSUER, sslClientCert.getIssuerDN().toString());
                            break block66;
                        } else {
                            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
                        }
                    }
                }
                break block66;
            }
            if (crmf != null && crmf != "") {
                certInfoArray = this.fillCRMF(crmf, authToken, httpParams, req);
            } else {
                logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_KEYGEN_INFO", (Object[])new Object[0]));
                throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(httpReq), (String)"CMS_GW_MISSING_KEYGEN_INFO", (String[])new String[0]));
            }
        }
        req.setExtData("CERT_INFO", certInfoArray);
        if (challengePassword != null && !challengePassword.equals("")) {
            String pwd = this.hashPassword(challengePassword);
            req.setExtData(CHALLENGE_PASSWORD, pwd);
        }
        this.mRequestQueue.processRequest(req);
        if (httpParams.getValueAsString(OLD_CERT_TYPE, null) != null) {
            try {
                this.renderServerEnrollResult(cmsReq);
                cmsReq.setStatus(CMSRequest.SUCCESS);
                return;
            }
            catch (Exception ex) {
                cmsReq.setStatus(CMSRequest.ERROR);
            }
            return;
        }
        Object initiative = null;
        String agentID = null;
        if (!authMgr.equals("certUserDBAuthMgr")) {
            initiative = "fromUser";
        } else {
            agentID = authToken.getInString("userid");
            initiative = "fromAgent agentID: " + agentID;
        }
        RequestStatus status = req.getRequestStatus();
        if (status != RequestStatus.COMPLETE) {
            cmsReq.setIRequestStatus();
            try {
                if (status != RequestStatus.REJECTED) {
                    logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, certInfo.get(SUBJECT_NAME), ""});
                    return;
                }
                Vector messages = req.getExtDataInStringVector("errors");
                if (messages == null) {
                    logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, certInfo.get(SUBJECT_NAME), ""});
                    return;
                }
                Enumeration msgs = messages.elements();
                StringBuffer wholeMsg = new StringBuffer();
                while (true) {
                    if (!msgs.hasMoreElements()) {
                        logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, certInfo.get(SUBJECT_NAME), " violation: " + wholeMsg});
                        return;
                    }
                    wholeMsg.append("\n");
                    wholeMsg.append((String)msgs.nextElement());
                }
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
                return;
            }
            catch (CertificateException e) {
                logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            return;
        }
        Integer result = req.getExtDataInInteger("Result");
        if (!result.equals(Request.RES_ERROR)) {
            cmsReq.setStatus(CMSRequest.SUCCESS);
            X509CertImpl[] issuedCerts = req.getExtDataInCertArray("issuedCerts");
            logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId(), initiative, authMgr, "completed", issuedCerts[0].getSubjectDN(), "cert issued serial number: 0x" + issuedCerts[0].getSerialNumber().toString(16)});
            if (this.checkImportCertToNav(cmsReq.getHttpResp(), httpParams, issuedCerts[0])) {
                cmsReq.setStatus(CMSRequest.SUCCESS);
                return;
            }
            try {
                cmsReq.setResult((Object)issuedCerts);
                this.renderTemplate(cmsReq, this.mEnrollSuccessTemplate, this.mEnrollSuccessFiller);
                cmsReq.setStatus(CMSRequest.SUCCESS);
                return;
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_TEMP_REND_ERR", (Object[])new Object[]{this.mEnrollSuccessFiller.toString(), e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_RETURNING_RESULT_ERROR", (String[])new String[0]), (Exception)e);
            }
        }
        cmsReq.setStatus(CMSRequest.ERROR);
        cmsReq.setError(req.getExtDataInString("Error"));
        String[] svcErrors = req.getExtDataInStringArray("serviceErrors");
        if (svcErrors == null) return;
        if (svcErrors.length <= 0) return;
        int i = 0;
        while (i < svcErrors.length) {
            String err = svcErrors[i];
            if (err != null) {
                cmsReq.setErrorDescription(err);
                try {
                    logger.info("Enrollment request reqID {} {} authenticated by {} is {}. DN requested: {} {}", new Object[]{req.getRequestId(), initiative, authMgr, "completed with error: " + err, certInfo.get(SUBJECT_NAME), ""});
                }
                catch (IOException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (CertificateException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_CANT_GET_CERT_SUBJ_AUDITING", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void fillCertInfoFromAuthToken(X509CertInfo certInfo, AuthToken authToken) throws EBaseException {
        try {
            String subjectname = authToken.getInString("tokenCertSubject");
            if (subjectname != null) {
                CertificateSubjectName certSubject = new CertificateSubjectName(new X500Name(subjectname));
                certInfo.set(SUBJECT_NAME, (Object)certSubject);
                logger.info("cert subject set to " + certSubject + " from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_SUBJECT_NAME_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_SUBJECT_NAME_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_SUBJECT_NAME_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_SUBJECT_NAME_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            CertificateValidity validity = null;
            Date notBefore = authToken.getInDate("tokenCertNotBefore");
            Date notAfter = authToken.getInDate("tokenCertNotAfter");
            if (notBefore != null && notAfter != null) {
                validity = new CertificateValidity(notBefore, notAfter);
                certInfo.set("validity", (Object)validity);
                logger.info("cert validity set to " + validity + " from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_VALIDITY_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_VALIDITY_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_VALIDITY_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_VALIDITY_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            CertificateExtensions extensions = authToken.getInCertExts("extensions");
            if (extensions != null) {
                certInfo.set("extensions", (Object)extensions);
                logger.info("cert extensions set from authtoken");
            }
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_EXTENSIONS_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_EXTENSIONS_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SET_EXTENSIONS_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SET_EXTENSIONS_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    protected X509CertInfo[] fillCRMF(String crmf, AuthToken authToken, ArgBlock httpParams, Request req) throws EBaseException {
        try {
            byte[] crmfBlob = Utils.base64decode((String)crmf);
            ByteArrayInputStream crmfBlobIn = new ByteArrayInputStream(crmfBlob);
            SEQUENCE crmfMsgs = (SEQUENCE)new SEQUENCE.OF_Template((ASN1Template)new CertReqMsg.Template()).decode((InputStream)crmfBlobIn);
            int nummsgs = crmfMsgs.size();
            X509CertInfo[] certInfoArray = new X509CertInfo[nummsgs];
            for (int i = 0; i < nummsgs; ++i) {
                CertReqMsg certReqMsg = (CertReqMsg)crmfMsgs.elementAt(i);
                CertRequest certReq = certReqMsg.getCertReq();
                INTEGER certReqId = certReq.getCertReqId();
                int srcId = certReqId.intValue();
                req.setExtData(CRMF_REQID, String.valueOf(srcId));
                CertTemplate certTemplate = certReq.getCertTemplate();
                CertInfo certInfo = new CertInfo();
                SubjectPublicKeyInfo spki = certTemplate.getPublicKey();
                ByteArrayOutputStream keyout = new ByteArrayOutputStream();
                spki.encode((OutputStream)keyout);
                byte[] keybytes = keyout.toByteArray();
                X509Key key = new X509Key();
                key.decode(keybytes);
                certInfo.set("key", (Object)new CertificateX509Key(key));
                if (certTemplate.getNotBefore() != null || certTemplate.getNotAfter() != null) {
                    CertificateValidity certValidity = new CertificateValidity(certTemplate.getNotBefore(), certTemplate.getNotAfter());
                    certInfo.set("validity", (Object)certValidity);
                }
                if (certTemplate.hasSubject()) {
                    Name subjectdn = certTemplate.getSubject();
                    ByteArrayOutputStream subjectEncStream = new ByteArrayOutputStream();
                    subjectdn.encode((OutputStream)subjectEncStream);
                    byte[] subjectEnc = subjectEncStream.toByteArray();
                    X500Name subject = new X500Name(subjectEnc);
                    certInfo.set(SUBJECT_NAME, (Object)new CertificateSubjectName(subject));
                } else if (authToken == null || authToken.getInString("tokenCertSubject") == null) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", (Object[])new Object[0]));
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_SUBJECT_NAME_FROM_AUTHTOKEN", (String[])new String[0]));
                }
                CertificateExtensions extensions = null;
                try {
                    extensions = (CertificateExtensions)certInfo.get("extensions");
                }
                catch (CertificateException e) {
                    extensions = null;
                }
                catch (IOException e) {
                    extensions = null;
                }
                if (certTemplate.hasExtensions()) {
                    if (extensions == null) {
                        extensions = new CertificateExtensions();
                    }
                    int numexts = certTemplate.numExtensions();
                    for (int j = 0; j < numexts; ++j) {
                        org.mozilla.jss.pkix.cert.Extension jssext = certTemplate.extensionAt(j);
                        boolean isCritical = jssext.getCritical();
                        OBJECT_IDENTIFIER jssoid = jssext.getExtnId();
                        long[] numbers = jssoid.getNumbers();
                        int[] oidNumbers = new int[numbers.length];
                        for (int k = numbers.length - 1; k >= 0; --k) {
                            oidNumbers[k] = (int)numbers[k];
                        }
                        ObjectIdentifier oid = new ObjectIdentifier(oidNumbers);
                        OCTET_STRING jssvalue = jssext.getExtnValue();
                        ByteArrayOutputStream jssvalueout = new ByteArrayOutputStream();
                        jssvalue.encode((OutputStream)jssvalueout);
                        byte[] extValue = jssvalueout.toByteArray();
                        Extension ext = new Extension(oid, isCritical, extValue);
                        extensions.parseExtension(ext);
                    }
                    certInfo.set("version", (Object)new CertificateVersion(2));
                    certInfo.set("extensions", (Object)extensions);
                }
                if (authToken != null && authToken.getInString("tokenCertSubject") != null) {
                    this.fillCertInfoFromAuthToken((X509CertInfo)certInfo, authToken);
                }
                certInfoArray[i] = certInfo;
            }
            this.do_testbed_hack(nummsgs, certInfoArray, httpParams);
            return certInfoArray;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_CRMF_TO_CERTINFO_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRMF_TO_CERTINFO_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_CRMF_TO_CERTINFO_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRMF_TO_CERTINFO_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (InvalidBERException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_CRMF_TO_CERTINFO_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRMF_TO_CERTINFO_ERROR", (String[])new String[0]), (Exception)((Object)e));
        }
        catch (InvalidKeyException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_CRMF_TO_CERTINFO_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_CRMF_TO_CERTINFO_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    protected void renderServerEnrollResult(CMSRequest cmsReq) throws Exception {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        httpResp.setContentType("text/html");
        ServletOutputStream out = null;
        out = httpResp.getOutputStream();
        out.println("<HTML>");
        out.println("<TITLE>");
        out.println("Server Enrollment");
        out.println("</TITLE>");
        if (cmsReq.getRequest().getRequestStatus().equals((Object)RequestStatus.COMPLETE)) {
            out.println("<H1>");
            out.println("SUCCESS");
            out.println("</H1>");
            out.println("Your request is submitted and approved. Please cut and paste the certificate into your server.");
            out.println("<P>");
            out.println("Request Creation Time: ");
            out.println(cmsReq.getRequest().getCreationTime().toString());
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Request ID: ");
            out.println(cmsReq.getRequest().getRequestId().toString());
            out.println("<P>");
            out.println("Certificate: ");
            out.println("<P>");
            out.println("<PRE>");
            X509CertImpl[] certs = cmsReq.getRequest().getExtDataInCertArray("issuedCerts");
            out.println(CertUtil.toPEM((X509Certificate)certs[0]));
            out.println("</PRE>");
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_CREATION_TIME=" + cmsReq.getRequest().getCreationTime().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_ID=" + cmsReq.getRequest().getRequestId().toString() + ">");
            out.println("<!HTTP_OUTPUT X509_CERTIFICATE=" + CertUtil.toPEM((X509Certificate)certs[0]) + ">");
        } else if (cmsReq.getRequest().getRequestStatus().equals((Object)RequestStatus.PENDING)) {
            out.println("<H1>");
            out.println("PENDING");
            out.println("</H1>");
            out.println("Your request is submitted. You can check on the status of your request with an authorized agent or local administrator by referring to the request ID.");
            out.println("<P>");
            out.println("Request Creation Time: ");
            out.println(cmsReq.getRequest().getCreationTime().toString());
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Request ID: ");
            out.println(cmsReq.getRequest().getRequestId().toString());
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_CREATION_TIME=" + cmsReq.getRequest().getCreationTime().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT REQUEST_ID=" + cmsReq.getRequest().getRequestId().toString() + ">");
        } else {
            out.println("<H1>");
            out.println("ERROR");
            out.println("</H1>");
            out.println("<!INFO>");
            out.println("Please consult your local administrator for assistance.");
            out.println("<!/INFO>");
            out.println("<P>");
            out.println("Request Status: ");
            out.println(cmsReq.getStatus().toString());
            out.println("<P>");
            out.println("Error: ");
            out.println(cmsReq.getError());
            out.println("<P>");
            out.println("<!HTTP_OUTPUT REQUEST_STATUS=" + cmsReq.getStatus().toString() + ">");
            out.println("<!HTTP_OUTPUT ERROR=" + cmsReq.getError() + ">");
        }
        out.println("</HTML>");
    }

    private void init_testbed_hack(ConfigStore config) throws EBaseException {
        this.mIsTestBed = config.getBoolean("isTestBed", true);
    }

    private void do_testbed_hack(int nummsgs, X509CertInfo[] certinfo, ArgBlock httpParams) throws EBaseException {
        if (!this.mIsTestBed) {
            return;
        }
        for (int i = 0; i < certinfo.length; ++i) {
            try {
                byte[] value;
                KeyUsageExtension ext;
                X509CertInfo cert = certinfo[i];
                CertificateExtensions exts = (CertificateExtensions)cert.get("extensions");
                if (exts == null || (ext = (KeyUsageExtension)exts.get("KeyUsage")) == null || (value = ext.getExtensionValue())[0] != 3 || value[1] != 2 || value[2] != 7) continue;
                byte[] newvalue = new byte[value.length + 1];
                newvalue[0] = 3;
                newvalue[1] = 3;
                newvalue[2] = 7;
                newvalue[3] = value[3];
                if (value[3] == 32 && httpParams.getValueAsBoolean("dual-use-hack", true)) {
                    newvalue[3] = -32;
                }
                newvalue[4] = 0;
                KeyUsageExtension newext = new KeyUsageExtension(Boolean.valueOf(true), (Object)newvalue);
                exts.delete("KeyUsage");
                exts.set("KeyUsage", (Object)newext);
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
    }
}

