/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.RequestQueue;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProfileApprove", urlPatterns={"/agent/ca/profileApprove"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caProfileApprove"), @WebInitParam(name="unauthorizedTemplate", value="/agent/GenUnauthorized.template"), @WebInitParam(name="templatePath", value="/agent/ca/ProfileApprove.template"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.profile")})
public class ProfileApproveServlet
extends ProfileServlet {
    public static final Logger logger = LoggerFactory.getLogger(ProfileApproveServlet.class);
    private static final long serialVersionUID = 3956879326742839550L;
    private static final String PROP_AUTHORITY_ID = "authorityId";
    private String mAuthorityId = null;
    private static final String OP_APPROVE = "approve";
    private static final String OP_DISAPPROVE = "disapprove";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mAuthorityId = sc.getInitParameter(PROP_AUTHORITY_ID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(CMSRequest cmsReq) throws Exception {
        ProfileSubsystem ps;
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        String auditProfileID = this.auditProfileID(request);
        String auditProfileOp = this.auditProfileOp(request);
        String userid = null;
        AuthToken authToken = null;
        ArgSet args = new ArgSet();
        Locale locale = this.getLocale(request);
        Profile profile = null;
        String profileId = null;
        try {
            try {
                authToken = this.authenticate(cmsReq);
                auditSubjectID = this.auditSubjectID();
                logger.debug("uid=" + authToken.getInString("userid"));
                userid = authToken.getInString("userid");
            }
            catch (Exception e) {
                auditSubjectID = this.auditSubjectID();
                logger.error("ProfileApproveServlet: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}));
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, OP_APPROVE);
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
            logger.debug("ProfileApproveServlet: start serving");
            if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
                this.mProfileSubId = "profile";
            }
            logger.debug("ProfileApproveServlet: SubId=" + this.mProfileSubId);
            ps = engine.getProfileSubsystem(this.mProfileSubId);
            if (ps == null) {
                logger.error("ProfileApproveServlet: ProfileSubsystem not found");
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
            IAuthority authority = (IAuthority)engine.getSubsystem(this.mAuthorityId);
            if (authority == null) {
                logger.error("ProfileApproveServlet: Authority " + this.mAuthorityId + " not found");
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
            RequestQueue queue = engine.getRequestQueue();
            if (queue == null) {
                logger.error("ProfileApproveServlet: Request Queue of " + this.mAuthorityId + " not found");
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
            profileId = request.getParameter("profileId");
            logger.debug("ProfileApproveServlet: profileId=" + profileId);
            args.set("errorCode", "0");
            args.set("errorReason", "");
            try {
                if (ps.isProfileEnable(profileId)) {
                    if (ps.checkOwner()) {
                        if (!ps.getProfileEnableBy(profileId).equals(userid)) {
                            args.set("errorCode", "1");
                            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_OWNER", (String[])new String[0]));
                            this.outputTemplate(request, response, args);
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                            auditor.log(auditMessage);
                            return;
                        }
                        ps.disableProfile(profileId);
                        ps.commitProfile(profileId);
                    } else {
                        ps.disableProfile(profileId);
                        ps.commitProfile(profileId);
                    }
                } else {
                    ps.enableProfile(profileId, userid);
                    ps.commitProfile(profileId);
                }
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Success", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
            }
            catch (EProfileException e) {
                logger.error("ProfileApproveServlet: profile not enabled: " + e.getMessage(), (Throwable)e);
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
                auditor.log(auditMessage);
                return;
            }
        }
        catch (EBaseException eAudit1) {
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CERT_PROFILE_APPROVAL_4", (Object[])new Object[]{auditSubjectID, "Failure", auditProfileID, auditProfileOp});
            auditor.log(auditMessage);
            throw eAudit1;
        }
        try {
            profile = ps.getProfile(profileId);
        }
        catch (EProfileException e) {
            logger.error("ProfileApproveServlet: profile not found: " + e.getMessage(), (Throwable)e);
            args.set("errorCode", "1");
            args.set("errorReason", e.toString());
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            this.outputTemplate(request, response, args);
            return;
        }
        if (profile == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            this.outputTemplate(request, response, args);
            return;
        }
        Enumeration<String> policySetIds = profile.getProfilePolicySetIds();
        ArgList setlist = new ArgList();
        while (true) {
            if (!policySetIds.hasMoreElements()) {
                args.set("policySetList", setlist);
                args.set("profileId", profileId);
                args.set("profileIsEnable", Boolean.toString(ps.isProfileEnable(profileId)));
                args.set("profileEnableBy", ps.getProfileEnableBy(profileId));
                args.set("profileName", profile.getName(locale));
                args.set("profileDesc", profile.getDescription(locale));
                this.outputTemplate(request, response, args);
                return;
            }
            String setId = policySetIds.nextElement();
            Enumeration<String> policyIds = profile.getProfilePolicyIds(setId);
            ArgList list = new ArgList();
            while (policyIds.hasMoreElements()) {
                String id = policyIds.nextElement();
                ProfilePolicy policy = profile.getProfilePolicy(setId, id);
                this.handlePolicy(list, locale, id, policy);
            }
            ArgSet setArg = new ArgSet();
            setArg.set("setId", setId);
            setArg.set("policy", list);
            setlist.add(setArg);
        }
    }

    private void handlePolicy(ArgList list, Locale locale, String id, ProfilePolicy policy) {
        ArgSet set = new ArgSet();
        set.set("policyId", id);
        PolicyDefault def = policy.getDefault();
        String dDesc = def.getText(locale);
        set.set("defDesc", dDesc);
        ArgList deflist = new ArgList();
        Enumeration<String> defNames = def.getValueNames();
        if (defNames != null) {
            while (defNames.hasMoreElements()) {
                ArgSet defset = new ArgSet();
                String defName = defNames.nextElement();
                IDescriptor defDesc = def.getValueDescriptor(locale, defName);
                if (defDesc == null) {
                    logger.debug("defName=" + defName);
                    continue;
                }
                String defSyntax = defDesc.getSyntax();
                String defConstraint = defDesc.getConstraint();
                String defValueName = defDesc.getDescription(locale);
                String defValue = null;
                defset.set("defId", defName);
                defset.set("defSyntax", defSyntax);
                defset.set("defConstraint", defConstraint);
                defset.set("defName", defValueName);
                defset.set("defVal", defValue);
                deflist.add(defset);
            }
        }
        set.set("defList", deflist);
        PolicyConstraint con = policy.getConstraint();
        String conDesc = con.getText(locale);
        set.set("conDesc", conDesc);
        list.add(set);
    }

    private String auditProfileID(HttpServletRequest req) {
        String profileID = null;
        profileID = req.getParameter("profileId");
        return profileID == null ? "$Unidentified$" : profileID.trim();
    }

    private String auditProfileOp(HttpServletRequest req) throws Exception {
        CAEngine engine;
        ProfileSubsystem ps;
        if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
            this.mProfileSubId = "profile";
        }
        if ((ps = (engine = CAEngine.getInstance()).getProfileSubsystem(this.mProfileSubId)) == null) {
            return "<null>";
        }
        String profileID = this.auditProfileID(req);
        if (profileID == "$Unidentified$") {
            return "<null>";
        }
        return ps.isProfileEnable(profileID) ? OP_DISAPPROVE : OP_APPROVE;
    }
}

