/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.provider.RSAPublicKey;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAKeyConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(RSAKeyConstraints.class);
    private Vector<BigInt> mExponents;
    private int mMinSize;
    private int mMaxSize;
    private static final int DEF_MIN_SIZE = 512;
    private static final int DEF_MAX_SIZE = 2048;
    private static final String PROP_MIN_SIZE = "minSize";
    private static final String PROP_MAX_SIZE = "maxSize";
    private static final String PROP_EXPONENTS = "exponents";
    private static final String RSA = "RSA";
    private static final Vector<String> defConfParams = new Vector();

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"minSize;number;Minimum size of user's RSA key (bits)", "maxSize;number;Maximum size of user's RSA key (bits)", "exponents;string;Comma-separated list of permissible exponents", "HELP_TOKEN;configuration-policyrules-rsakeyconstraints", "HELP_TEXT;Reject request if RSA key length is not within the specified constraints"};
        return params;
    }

    public RSAKeyConstraints() {
        this.NAME = "RSAKeyConstraints";
        this.DESC = "Enforces RSA Key Constraints.";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        if (config == null || config.size() == 0) {
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_MISSING_POLICY_CONFIG", (String[])new String[]{this.getInstanceName()}));
        }
        String exponents = null;
        this.mMinSize = config.getInteger(PROP_MIN_SIZE, 512);
        this.mMaxSize = config.getInteger(PROP_MAX_SIZE, 2048);
        if (this.mMinSize <= 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_MUST_BE_POSITIVE_NUMBER", (String[])new String[]{PROP_MIN_SIZE}));
        }
        if (this.mMaxSize <= 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_MUST_BE_POSITIVE_NUMBER", (String[])new String[]{PROP_MAX_SIZE}));
        }
        if (this.mMinSize > this.mMaxSize) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_A_GREATER_THAN_EQUAL_B", (String[])new String[]{PROP_MIN_SIZE, PROP_MAX_SIZE}));
        }
        this.mExponents = new Vector();
        exponents = config.getString(PROP_EXPONENTS, null);
        if (exponents != null) {
            StringTokenizer tok = new StringTokenizer(exponents, ",");
            try {
                while (tok.hasMoreTokens()) {
                    String exp = tok.nextToken().trim();
                    this.mExponents.addElement(new BigInt(Integer.parseInt(exp)));
                }
            }
            catch (Exception e) {
                String[] params = new String[]{this.getInstanceName(), exponents, PROP_EXPONENTS};
                throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_CONFIG_PARAM", (String[])params));
            }
        }
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfo = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfo == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfo.length; ++i) {
                BigInt exp;
                CertificateX509Key certKey = (CertificateX509Key)certInfo[i].get("key");
                X509Key key = (X509Key)certKey.get("value");
                String alg = key.getAlgorithmId().toString();
                if (!alg.equalsIgnoreCase(RSA)) continue;
                X509Key newkey = null;
                try {
                    newkey = new X509Key(AlgorithmId.get((String)RSA), key.getKey());
                }
                catch (Exception e) {
                    logger.warn("RSAKeyConstraints::apply(): " + e.getMessage(), (Throwable)e);
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_KEY_SIZE_VIOLATION", (String[])new String[]{this.getInstanceName()}), "");
                    return PolicyResult.REJECTED;
                }
                RSAPublicKey rsaKey = new RSAPublicKey(newkey.getEncoded());
                int keySize = rsaKey.getKeySize();
                if (keySize < this.mMinSize || keySize > this.mMaxSize) {
                    String[] params = new String[]{this.getInstanceName(), String.valueOf(keySize), String.valueOf(this.mMinSize), String.valueOf(this.mMaxSize)};
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_KEY_SIZE_VIOLATION", (String[])params), "");
                    result = PolicyResult.REJECTED;
                }
                if (this.mExponents.size() <= 0 || this.mExponents.contains(exp = rsaKey.getPublicExponent())) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration<BigInt> e = this.mExponents.elements();
                while (e.hasMoreElements()) {
                    BigInt bi = e.nextElement();
                    sb.append(bi.toBigInteger().toString());
                    sb.append(" ");
                }
                String[] params = new String[]{this.getInstanceName(), exp.toBigInteger().toString(), new String(sb)};
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_EXPONENT_VIOLATION", (String[])params), "");
                result = PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("minSize=" + this.mMinSize);
        confParams.addElement("maxSize=" + this.mMaxSize);
        StringBuffer sb = new StringBuffer();
        Enumeration<BigInt> e = this.mExponents.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement().toInt());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        confParams.addElement("exponents=" + sb.toString());
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        return defConfParams;
    }

    static {
        defConfParams.addElement("minSize=512");
        defConfParams.addElement("maxSize=2048");
        defConfParams.addElement("exponents= ");
    }
}

