/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.OCSPRemoveCARequestEvent;
import com.netscape.certsrv.logging.event.OCSPRemoveCARequestProcessedEvent;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCAServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(RemoveCAServlet.class);
    private static final long serialVersionUID = -4519898238552366358L;
    private static final String TPL_FILE = "removeCA.template";
    private String mFormPath = null;
    private OCSPAuthority mOCSPAuthority;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ocsp/removeCA.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSPAuthority = engine.getOCSP();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        String caID;
        String uid;
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "add");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        if ((auditSubjectID.equals("$NonRoleUser$") || auditSubjectID.equals("$Unidentified$")) && (uid = authToken.getInString("userid")) != null) {
            logger.debug("RemoveCAServlet: auditSubjectID set to " + uid);
            auditSubjectID = uid;
        }
        if ((caID = cmsReq.getHttpReq().getParameter("caID")) == null) {
            auditor.log((LogEvent)OCSPRemoveCARequestEvent.createFailureEvent((String)auditSubjectID));
            throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CA_ID", (String[])new String[0]));
        }
        auditor.log((LogEvent)OCSPRemoveCARequestEvent.createSuccessEvent((String)auditSubjectID, (String)caID));
        IDefStore defStore = this.mOCSPAuthority.getDefaultStore();
        try {
            defStore.deleteCRLIssuingPointRecord(caID);
        }
        catch (EBaseException e) {
            auditor.log((LogEvent)OCSPRemoveCARequestProcessedEvent.createFailureEvent((String)auditSubjectID, (String)caID));
            logger.error("RemoveCAServlet:Error deleting CRL IssuingPoint: " + caID + ": " + e.getMessage(), (Throwable)e);
            throw new EBaseException(e.toString());
        }
        logger.debug("RemoveCAServlet::process: CRL IssuingPoint for CA successfully removed: " + caID);
        auditor.log((LogEvent)OCSPRemoveCARequestProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)caID));
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }
}

