/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.kra.KRAEngine;

public class KRAAdminServlet
extends AdminServlet {
    private static final long serialVersionUID = -5794220348195666729L;
    protected static final String PROP_ENABLED = "enabled";
    private static final String INFO = "KRAAdminServlet";
    private KeyRecoveryAuthority mKRA;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        KRAEngine engine = KRAEngine.getInstance();
        this.mKRA = (KeyRecoveryAuthority)engine.getSubsystem("kra");
    }

    public String getServletInfo() {
        return INFO;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        super.authenticate(req);
        String scope = req.getParameter("OP_SCOPE");
        if (scope == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", (String[])new String[0]), null, resp);
            return;
        }
        String op = req.getParameter("OP_TYPE");
        if (op == null) {
            this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_OP_TYPE", (String[])new String[]{op}), null, resp);
            return;
        }
        try {
            AUTHZ_RES_NAME = "certServer.kra.configuration";
            if (op.equals("OP_READ")) {
                this.mOp = "read";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.getGeneralConfig(req, resp);
                    return;
                }
            } else if (op.equals("OP_MODIFY")) {
                this.mOp = "modify";
                this.mToken = super.authorize(req);
                if (this.mToken == null) {
                    this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_AUTHZ_FAILED", (String[])new String[0]), null, resp);
                    return;
                }
                if (scope.equals("general")) {
                    this.setGeneralConfig(req, resp);
                }
            }
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sendResponse(ERROR, CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_ADMIN_SRVLT_INVALID_PROTOCOL", (String[])new String[0]), null, resp);
    }

    private void getGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        int value = 1;
        value = this.mKRA.getNoOfRequiredAgents();
        params.put((Object)"noOfRequiredRecoveryAgents", (Object)Integer.toString(value));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setGeneralConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        Enumeration enum1 = req.getParameterNames();
        boolean restart = false;
        KRAEngine engine = KRAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            String value = req.getParameter(key);
            if (!key.equals("noOfRequiredRecoveryAgents")) continue;
            try {
                int number = Integer.parseInt(value);
                this.mKRA.setNoOfRequiredAgents(number);
            }
            catch (NumberFormatException e) {
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_DRM_3", (Object[])new Object[]{auditSubjectID, "Failure", this.auditParams(req)});
                auditor.log(auditMessage);
                throw new EBaseException("Number of agents must be an integer");
            }
        }
        this.commit(true);
        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CONFIG_DRM_3", (Object[])new Object[]{auditSubjectID, "Success", this.auditParams(req)});
        auditor.log(auditMessage);
        if (restart) {
            this.sendResponse(RESTART, null, null, resp);
        } else {
            this.sendResponse(SUCCESS, null, null, resp);
        }
    }
}

