/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRecordMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(KeyRecordMapper.class);
    private KeyRepository mDB;

    public KeyRecordMapper(KeyRepository db) {
        this.mDB = db;
    }

    public Enumeration<String> getSupportedLDAPAttributeNames() {
        Vector<String> v = new Vector<String>();
        v.addElement("keyRecordId");
        return v.elements();
    }

    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_DBS_SERIALIZE_FAILED", (String[])new String[]{name}));
        }
        try {
            KeyRecord rec = (KeyRecord)obj;
            logger.debug("KeyRecordMapper: Mapping " + name + " to keyRecordId");
            attrs.add(new LDAPAttribute("keyRecordId", rec.getSerialNumber().toString()));
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_DBS_KEYRECORD_MAPPER_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EDBException(CMS.getUserMessage((String)"CMS_DBS_SERIALIZE_FAILED", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        try {
            LDAPAttribute attr = attrs.getAttribute("keyRecordId");
            if (attr == null) {
                return;
            }
            String serialno = (String)attr.getStringValues().nextElement();
            KeyRecord rec = this.mDB.readKeyRecord(new BigInteger(serialno));
            parent.set(name, (Object)rec);
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_DBS_KEYRECORD_MAPPER_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EDBException(CMS.getUserMessage((String)"CMS_DBS_DESERIALIZE_FAILED", (String[])new String[]{name}), (Throwable)e);
        }
    }

    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return name + op + value;
    }
}

