/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.KeyCertData;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.dbs.BigIntegerMapper;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.X509CertImplMapper;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.extensions.OCSPNoCheckExtension;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgIdDSA;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500Signer;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11ECPublicKey;
import org.mozilla.jss.util.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCertUtil {
    public static Logger logger = LoggerFactory.getLogger(KeyCertUtil.class);
    public static final String CA_SIGNINGCERT_NICKNAME = "caSigningCert";

    public static void checkCertificateExt(String ext) throws EBaseException {
        byte[] b = null;
        if (ext != null) {
            try {
                b = Utils.base64decode((String)ext);
                DerValue b_der = new DerValue(b);
                while (b_der.data.available() != 0) {
                    new Extension(b_der.data.getDerValue());
                }
            }
            catch (IOException e) {
                try {
                    new Extension(new DerValue(b));
                }
                catch (IOException ex) {
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_CERT_EXTENSION", new String[0]));
                }
            }
        }
    }

    public static String getTokenNames(CryptoManager manager) throws TokenException {
        StringBuffer tokenList = new StringBuffer();
        Enumeration tokens = manager.getExternalTokens();
        int num = 0;
        while (tokens.hasMoreElements()) {
            CryptoToken c = (CryptoToken)tokens.nextElement();
            if (num++ != 0) {
                tokenList.append(",");
            }
            tokenList.append(c.getName());
        }
        if (tokenList.length() == 0) {
            return "internal";
        }
        return tokenList.toString() + ",internal";
    }

    public static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    public static byte[] makeDSSParms(BigInteger P, BigInteger Q, BigInteger G) throws IOException {
        try (DerOutputStream sequence = new DerOutputStream();){
            DerOutputStream contents = new DerOutputStream();
            contents.putInteger(new BigInt(P));
            contents.putInteger(new BigInt(Q));
            contents.putInteger(new BigInt(G));
            sequence.write((byte)48, contents);
            byte[] byArray = sequence.toByteArray();
            return byArray;
        }
    }

    public static PrivateKey getPrivateKey(String tokenname, String nickname) throws TokenException, EBaseException, NoSuchTokenException, NotInitializedException, CertificateException, CertificateEncodingException, EBaseException, ObjectNotFoundException {
        X509Certificate cert = KeyCertUtil.getCertificate(tokenname, nickname);
        return CryptoManager.getInstance().findPrivKeyByCert(cert);
    }

    public static String getCertSubjectName(String tokenname, String nickname) throws TokenException, EBaseException, NoSuchTokenException, NotInitializedException, CertificateException, CertificateEncodingException, EBaseException {
        X509Certificate cert = KeyCertUtil.getCertificate(tokenname, nickname);
        X509CertImpl impl = new X509CertImpl(cert.getEncoded());
        return impl.getSubjectName().getName();
    }

    public static SignatureAlgorithm getSigningAlgorithm(String keyType) {
        SignatureAlgorithm sAlg = null;
        sAlg = keyType.equals("RSA") ? SignatureAlgorithm.RSASignatureWithMD5Digest : SignatureAlgorithm.DSASignatureWithSHA1Digest;
        return sAlg;
    }

    public static SignatureAlgorithm getSigningAlgorithm(String keyType, String hashtype) {
        SignatureAlgorithm sAlg = null;
        if (keyType.equals("RSA")) {
            if (hashtype.equals("MD2")) {
                sAlg = SignatureAlgorithm.RSASignatureWithMD2Digest;
            } else if (hashtype.equals("MD5")) {
                sAlg = SignatureAlgorithm.RSASignatureWithMD5Digest;
            } else if (hashtype.equals("SHA1")) {
                sAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
            } else if (hashtype.equals("SHA256")) {
                sAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
            } else if (hashtype.equals("SHA512")) {
                sAlg = SignatureAlgorithm.RSASignatureWithSHA512Digest;
            }
        } else {
            sAlg = SignatureAlgorithm.DSASignatureWithSHA1Digest;
        }
        return sAlg;
    }

    public static AlgorithmId getAlgorithmId(String algname, ConfigStore store) throws EBaseException {
        try {
            if (algname.equals("DSA")) {
                byte[] p = store.getByteArray("ca.dsaP", null);
                byte[] q = store.getByteArray("ca.dsaQ", null);
                byte[] g = store.getByteArray("ca.dsaG", null);
                if (p != null && q != null && g != null) {
                    BigInteger P = new BigInteger(p);
                    BigInteger Q = new BigInteger(q);
                    BigInteger G = new BigInteger(g);
                    return new AlgIdDSA(P, Q, G);
                }
            }
            return AlgorithmId.get((String)algname);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", new String[0]));
        }
    }

    public static X509Certificate getCertificate(String tokenname, String nickname) throws NotInitializedException, NoSuchTokenException, EBaseException, TokenException {
        CryptoManager manager = CryptoManager.getInstance();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenname);
        StringBuffer certname = new StringBuffer();
        if (!token.equals((Object)manager.getInternalKeyStorageToken())) {
            certname.append(tokenname);
            certname.append(":");
        }
        certname.append(nickname);
        try {
            return manager.findCertByNickname(certname.toString());
        }
        catch (ObjectNotFoundException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CA_SIGNINGCERT_NOT_FOUND", new String[0]));
        }
    }

    public static KeyPair getKeyPair(String tokenname, String nickname) throws NotInitializedException, NoSuchTokenException, TokenException, ObjectNotFoundException, EBaseException {
        X509Certificate cert = KeyCertUtil.getCertificate(tokenname, nickname);
        org.mozilla.jss.crypto.PrivateKey priKey = CryptoManager.getInstance().findPrivKeyByCert(cert);
        PublicKey publicKey = cert.getPublicKey();
        return new KeyPair(publicKey, (PrivateKey)priKey);
    }

    public static PQGParams getPQG(int keysize) {
        try {
            return PQGParams.generate((int)keysize);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PQGParams getCAPQG(int keysize, ConfigStore store) throws EBaseException {
        if (store != null) {
            try {
                int pqgKeySize = store.getInteger("ca.dsaPQG.keyLength", 0);
                if (pqgKeySize > 0 && pqgKeySize == keysize) {
                    byte[] p = store.getByteArray("ca.dsaP", null);
                    byte[] q = store.getByteArray("ca.dsaQ", null);
                    byte[] g = store.getByteArray("ca.dsaG", null);
                    byte[] seed = store.getByteArray("ca.dsaSeed", null);
                    byte[] H = store.getByteArray("ca.dsaH", null);
                    int counter = store.getInteger("ca.dsaCounter", 0);
                    if (p != null && q != null && g != null) {
                        BigInteger P = new BigInteger(p);
                        BigInteger Q = new BigInteger(q);
                        BigInteger G = new BigInteger(g);
                        BigInteger pqgSeed = new BigInteger(seed);
                        BigInteger pqgH = new BigInteger(H);
                        return new PQGParams(P, Q, G, pqgSeed, counter, pqgH);
                    }
                }
                PQGParams pqg = PQGParams.generate((int)keysize);
                store.putInteger("ca.dsaPQG.keyLength", keysize);
                store.putString("ca.dsaP", KeyCertUtil.base64Encode(pqg.getP().toByteArray()));
                store.putString("ca.dsaQ", KeyCertUtil.base64Encode(pqg.getQ().toByteArray()));
                store.putString("ca.dsaG", KeyCertUtil.base64Encode(pqg.getG().toByteArray()));
                store.putString("ca.dsaSeed", KeyCertUtil.base64Encode(pqg.getSeed().toByteArray()));
                store.putInteger("ca.dsaCounter", pqg.getCounter());
                store.putString("ca.dsaH", KeyCertUtil.base64Encode(pqg.getH().toByteArray()));
                store.putString("ca.DSSParms", KeyCertUtil.base64Encode(KeyCertUtil.makeDSSParms(pqg.getP(), pqg.getQ(), pqg.getG())));
                store.commit(false);
                return pqg;
            }
            catch (IOException ee) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_PQG_GEN_FAILED", new String[0]));
            }
            catch (EBaseException ee) {
                throw ee;
            }
            catch (PQGParamGenException ee) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_PQG_GEN_FAILED", new String[0]));
            }
        }
        return null;
    }

    public static KeyPair generateKeyPair(CryptoToken token, KeyPairAlgorithm kpAlg, int keySize, PQGParams pqg) throws NoSuchAlgorithmException, TokenException, InvalidAlgorithmParameterException, InvalidParameterException, PQGParamGenException {
        KeyPairGenerator kpGen = token.getKeyPairGenerator(kpAlg);
        if (kpAlg == KeyPairAlgorithm.DSA) {
            if (pqg == null) {
                kpGen.initialize(keySize);
            } else {
                kpGen.initialize((AlgorithmParameterSpec)pqg);
            }
        } else {
            kpGen.initialize(keySize);
        }
        if (pqg == null) {
            return kpGen.genKeyPair();
        }
        KeyPair kp = null;
        while (KeyCertUtil.isBadDSAKeyPair(kp = kpGen.genKeyPair())) {
        }
        return kp;
    }

    public static boolean isBadDSAKeyPair(KeyPair pair) {
        try {
            byte[] pubkBytes = pair.getPublic().getEncoded();
            SEQUENCE.Template outerSeq = new SEQUENCE.Template();
            outerSeq.addElement((ASN1Template)new ANY.Template());
            outerSeq.addElement((ASN1Template)new BIT_STRING.Template());
            SEQUENCE seq = (SEQUENCE)ASN1Util.decode((ASN1Template)outerSeq, (byte[])pubkBytes);
            BIT_STRING bs = (BIT_STRING)seq.elementAt(1);
            ByteArrayInputStream bitstream = new ByteArrayInputStream(bs.getBits());
            ASN1Header wrapper = new ASN1Header((InputStream)bitstream);
            byte[] valBytes = new byte[(int)wrapper.getContentLength()];
            ASN1Util.readFully((byte[])valBytes, (InputStream)bitstream);
            boolean isBroken = valBytes[0] == 0;
            return isBroken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static KeyPair generateKeyPair(String tokenName, String alg, int keySize, PQGParams pqg) throws EBaseException {
        CryptoToken token = null;
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            tokenName = "internal";
        }
        try {
            token = CryptoUtil.getKeyStorageToken((String)tokenName);
        }
        catch (NoSuchTokenException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", tokenName));
        }
        catch (NotInitializedException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        KeyPairAlgorithm kpAlg = null;
        kpAlg = alg.equals("RSA") ? KeyPairAlgorithm.RSA : KeyPairAlgorithm.DSA;
        try {
            KeyPair kp = KeyCertUtil.generateKeyPair(token, kpAlg, keySize, pqg);
            return kp;
        }
        catch (InvalidParameterException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_KEYSIZE_PARAMS", "" + keySize));
        }
        catch (PQGParamGenException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_PQG_GEN_FAILED", new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", kpAlg.toString()));
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_ERROR_1", e.toString()));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", "DSA"));
        }
    }

    public static PKCS10 getCertRequest(String subjectName, KeyPair keyPair) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException, CertificateException, SignatureException {
        PublicKey pubk = keyPair.getPublic();
        X509Key key = CryptoUtil.createX509Key((PublicKey)pubk);
        String alg = pubk instanceof RSAPublicKey ? "MD5/RSA" : (pubk instanceof PK11ECPublicKey ? "SHA256withEC" : "DSA");
        Signature sig = Signature.getInstance(alg, "Mozilla-JSS");
        sig.initSign(keyPair.getPrivate());
        PKCS10 pkcs10 = new PKCS10(key);
        X500Name name = new X500Name(subjectName);
        X500Signer signer = new X500Signer(sig, name);
        pkcs10.encodeAndSign(signer);
        return pkcs10;
    }

    public static PKCS10 getCertRequest(String subjectName, KeyPair keyPair, Extensions exts) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException, CertificateException, SignatureException {
        PublicKey pubk = keyPair.getPublic();
        X509Key key = CryptoUtil.createX509Key((PublicKey)pubk);
        String alg = pubk instanceof RSAPublicKey ? "MD5/RSA" : (pubk instanceof PK11ECPublicKey ? "SHA256withEC" : "DSA");
        Signature sig = Signature.getInstance(alg, "Mozilla-JSS");
        sig.initSign(keyPair.getPrivate());
        PKCS10 pkcs10 = null;
        if (exts != null) {
            PKCS10Attribute attr = new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, (CertAttrSet)exts);
            PKCS10Attributes attrs = new PKCS10Attributes();
            attrs.setAttribute(attr.getAttributeValue().getName(), attr);
            pkcs10 = new PKCS10(key, attrs);
        } else {
            pkcs10 = new PKCS10(key);
        }
        X500Name name = new X500Name(subjectName);
        X500Signer signer = new X500Signer(sig, name);
        pkcs10.encodeAndSign(signer);
        return pkcs10;
    }

    public static X509Certificate importCert(X509CertImpl signedCert, String nickname, String certType) throws NotInitializedException, TokenException, CertificateEncodingException, UserCertConflictException, NicknameConflictException, NoSuchItemOnTokenException, CertificateException {
        return KeyCertUtil.importCert(signedCert.getEncoded(), nickname, certType);
    }

    public static X509Certificate importCert(String b64E, String nickname, String certType) throws NotInitializedException, TokenException, CertificateEncodingException, UserCertConflictException, NicknameConflictException, NoSuchItemOnTokenException, CertificateException {
        byte[] b = b64E.getBytes();
        X509Certificate cert = KeyCertUtil.getInternalCertificate(b, nickname, certType);
        if (cert instanceof InternalCertificate) {
            KeyCertUtil.setTrust(certType, (InternalCertificate)cert);
        }
        return cert;
    }

    public static X509Certificate importCert(byte[] b, String nickname, String certType) throws NotInitializedException, TokenException, CertificateEncodingException, UserCertConflictException, NicknameConflictException, NoSuchItemOnTokenException, CertificateException {
        X509Certificate cert = KeyCertUtil.getInternalCertificate(b, nickname, certType);
        if (cert instanceof InternalCertificate) {
            KeyCertUtil.setTrust(certType, (InternalCertificate)cert);
        }
        return cert;
    }

    public static X509Certificate getInternalCertificate(byte[] b, String nickname, String certType) throws NotInitializedException, TokenException, CertificateEncodingException, UserCertConflictException, NicknameConflictException, NoSuchItemOnTokenException, CertificateException {
        X509Certificate cert = null;
        if (certType.equals(CA_SIGNINGCERT_NICKNAME)) {
            cert = CryptoManager.getInstance().importUserCACertPackage(b, nickname);
        } else if (certType.equals("raSigningCert") || certType.equals("kraTransportCert") || certType.equals("ocspSigningCert") || certType.equals("serverCert") || certType.equals("serverCertRadm") || certType.equals("otherCert") || certType.equals("subsystemCert")) {
            cert = CryptoManager.getInstance().importCertPackage(b, nickname);
        } else if (certType.equals("serverCertChain")) {
            cert = CryptoManager.getInstance().importCACertPackage(b);
        } else if (certType.equals("trustedCACert")) {
            cert = CryptoManager.getInstance().importCACertPackage(b);
            X509Certificate[] certchain = CryptoManager.getInstance().buildCertificateChain(cert);
            if (certchain != null) {
                cert = certchain[certchain.length - 1];
            }
        }
        return cert;
    }

    public static void setTrust(String certType, InternalCertificate inCert) {
        if (certType.equals(CA_SIGNINGCERT_NICKNAME)) {
            int flag = 216;
            inCert.setSSLTrust(flag);
            inCert.setObjectSigningTrust(flag);
            inCert.setEmailTrust(flag);
        } else if (certType.equals("raSigningCert")) {
            int flag = 72;
            inCert.setSSLTrust(flag);
            inCert.setObjectSigningTrust(flag);
            inCert.setEmailTrust(flag);
        } else if (certType.equals("ocspSigningCert")) {
            int flag = 72;
            inCert.setSSLTrust(flag);
            inCert.setObjectSigningTrust(flag);
            inCert.setEmailTrust(flag);
        } else if (certType.equals("serverCert") || certType.equals("subsystemCert")) {
            int flag = 72;
            inCert.setSSLTrust(flag);
            inCert.setObjectSigningTrust(flag);
            inCert.setEmailTrust(flag);
        } else if (certType.equals("trustedCACert")) {
            inCert.setSSLTrust(152);
        }
    }

    public static byte[] convertB64EToByteArray(String b64E) throws CertificateException, IOException {
        String str = CertUtils.stripCertBrackets(b64E);
        byte[] bCert = Utils.base64decode((String)str);
        return bCert;
    }

    public static void setDERExtension(CertificateExtensions ext, KeyCertData properties) throws IOException {
        String b64E = properties.getDerExtension();
        if (b64E != null) {
            byte[] b = Utils.base64decode((String)b64E);
            try {
                DerValue b_der = new DerValue(b);
                while (b_der.data.available() != 0) {
                    Extension de = new Extension(b_der.data.getDerValue());
                    ext.set(de.getExtensionId().toString(), (Object)de);
                }
            }
            catch (IOException e) {
                Extension de = new Extension(new DerValue(b));
                ext.set(de.getExtensionId().toString(), (Object)de);
            }
        }
    }

    public static void setBasicConstraintsExtension(CertificateExtensions ext, KeyCertData properties) throws IOException {
        String isCA = properties.isCA();
        String certLen = properties.getCertLen();
        if (isCA == null) {
            return;
        }
        if (isCA.equals("null")) {
            return;
        }
        int len = 0;
        boolean bool = false;
        len = certLen == null || certLen.equals("") ? 0 : Integer.parseInt(certLen);
        bool = isCA != null && !isCA.equals("") && !isCA.equals("false");
        BasicConstraintsExtension basic = new BasicConstraintsExtension(bool, len);
        ext.set("BasicConstraints", (Object)basic);
    }

    public static void setExtendedKeyUsageExtension(CertificateExtensions ext, KeyCertData properties) throws IOException, CertificateException {
        String ocspSigning;
        String timestamping;
        String objectSigning;
        String sslMail;
        String sslServer;
        ExtendedKeyUsageExtension ns = new ExtendedKeyUsageExtension();
        boolean anyExt = false;
        String sslClient = properties.getSSLClientBit();
        if (sslClient != null && sslClient.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.2"));
            anyExt = true;
        }
        if ((sslServer = properties.getSSLServerBit()) != null && sslServer.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.1"));
            anyExt = true;
        }
        if ((sslMail = properties.getSSLMailBit()) != null && sslMail.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.4"));
            anyExt = true;
        }
        if ((objectSigning = properties.getObjectSigningBit()) != null && objectSigning.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.3"));
            anyExt = true;
        }
        if ((timestamping = properties.getTimeStampingBit()) != null && timestamping.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.8"));
            anyExt = true;
        }
        if ((ocspSigning = properties.getOCSPSigning()) != null && ocspSigning.equals("true")) {
            ns.addOID(new ObjectIdentifier("1.3.6.1.5.5.7.3.9"));
            anyExt = true;
        }
        if (anyExt) {
            ext.set("ExtendedKeyUsageExtension", (Object)ns);
        }
    }

    public static void setNetscapeCertificateExtension(CertificateExtensions ext, KeyCertData properties) throws IOException, CertificateException {
        String objectSigningCA;
        String mailCA;
        String objectSigning;
        String sslCA;
        String sslMail;
        String sslServer;
        NSCertTypeExtension ns = new NSCertTypeExtension();
        boolean anyExt = false;
        String sslClient = properties.getSSLClientBit();
        if (sslClient != null && sslClient.equals("true")) {
            ns.set("ssl_client", (Object)true);
            anyExt = true;
        }
        if ((sslServer = properties.getSSLServerBit()) != null && sslServer.equals("true")) {
            ns.set("ssl_server", (Object)true);
            anyExt = true;
        }
        if ((sslMail = properties.getSSLMailBit()) != null && sslMail.equals("true")) {
            ns.set("email", (Object)true);
            anyExt = true;
        }
        if ((sslCA = properties.getSSLCABit()) != null && sslCA.equals("true")) {
            ns.set("ssl_ca", (Object)true);
            anyExt = true;
        }
        if ((objectSigning = properties.getObjectSigningBit()) != null && objectSigning.equals("true")) {
            ns.set("object_signing", (Object)true);
            anyExt = true;
        }
        if ((mailCA = properties.getMailCABit()) != null && mailCA.equals("true")) {
            ns.set("email_ca", (Object)true);
            anyExt = true;
        }
        if ((objectSigningCA = properties.getObjectSigningCABit()) != null && objectSigningCA.equals("true")) {
            ns.set("object_signing_ca", (Object)true);
            anyExt = true;
        }
        if (anyExt) {
            ext.set("NSCertType", (Object)ns);
        }
    }

    public static void setOCSPNoCheck(KeyPair keypair, CertificateExtensions ext, KeyCertData properties) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String noCheck = properties.getOCSPNoCheck();
        if (noCheck != null && noCheck.equals("true")) {
            OCSPNoCheckExtension noCheckExt = new OCSPNoCheckExtension();
            ext.set("OCSPNoCheckExtension", (Object)noCheckExt);
        }
    }

    public static void setOCSPSigning(KeyPair keypair, CertificateExtensions ext, KeyCertData properties) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String signing = properties.getOCSPSigning();
        if (signing != null && signing.equals("true")) {
            Vector<ObjectIdentifier> oidSet = new Vector<ObjectIdentifier>();
            oidSet.addElement(ObjectIdentifier.getObjectIdentifier((String)"1.3.6.1.5.5.7.3.9"));
            ExtendedKeyUsageExtension ocspExt = new ExtendedKeyUsageExtension(false, oidSet);
            ext.set("ExtendedKeyUsageExtension", (Object)ocspExt);
        }
    }

    public static void setAuthorityKeyIdentifier(KeyPair keypair, CertificateExtensions ext, KeyCertData properties) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String aki = properties.getAKI();
        if (aki != null && aki.equals("true")) {
            KeyIdentifier id = KeyCertUtil.createKeyIdentifier(keypair);
            AuthorityKeyIdentifierExtension akiExt = new AuthorityKeyIdentifierExtension(id, null, null);
            ext.set("AuthorityKeyIdentifier", (Object)akiExt);
        }
    }

    public static void setSubjectKeyIdentifier(KeyPair keypair, CertificateExtensions ext, KeyCertData properties) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String ski = properties.getSKI();
        if (ski != null && ski.equals("true")) {
            KeyIdentifier id = KeyCertUtil.createKeyIdentifier(keypair);
            SubjectKeyIdentifierExtension skiExt = new SubjectKeyIdentifierExtension(id.getIdentifier());
            ext.set("SubjectKeyIdentifier", (Object)skiExt);
        }
    }

    public static void setKeyUsageExtension(CertificateExtensions ext, KeyUsageExtension keyUsage) throws IOException {
        ext.set("KeyUsage", (Object)keyUsage);
    }

    public static KeyIdentifier createKeyIdentifier(KeyPair keypair) throws NoSuchAlgorithmException, InvalidKeyException {
        X509Key subjectKeyInfo = CryptoUtil.createX509Key((PublicKey)keypair.getPublic());
        byte[] hash = CryptoUtil.generateKeyIdentifier((byte[])subjectKeyInfo.getKey());
        if (hash == null) {
            logger.warn("KeyCertUtil: createKeyIdentifier CryptoUtil.generateKeyIdentifier returns null");
            return null;
        }
        return new KeyIdentifier(hash);
    }

    public static BigInteger getSerialNumber(LDAPConnection conn, String baseDN) throws LDAPException, EBaseException {
        String dn = "ou=certificateRepository,ou=ca," + baseDN;
        BigInteger serialno = null;
        LDAPEntry entry = conn.read(dn);
        LDAPAttribute serialNo = entry.getAttribute("serialno");
        if (serialNo == null) {
            throw new LDAPException("No value for attribute serial number in LDAP entry " + entry.getDN());
        }
        String serialnoStr = (String)serialNo.getStringValues().nextElement();
        serialno = BigIntegerMapper.BigIntegerFromDB(serialnoStr);
        LDAPAttribute attr = new LDAPAttribute("serialno");
        attr.addValue(BigIntegerMapper.BigIntegerToDB(serialno.add(new BigInteger("1"))));
        LDAPModification mod = new LDAPModification(2, attr);
        conn.modify(dn, mod);
        return serialno;
    }

    public static void setSerialNumber(LDAPConnection conn, String baseDN, BigInteger serial) throws LDAPException, EBaseException {
        String dn = "ou=certificateRepository,ou=ca," + baseDN;
        LDAPAttribute attr = new LDAPAttribute("serialno");
        attr.addValue(BigIntegerMapper.BigIntegerToDB(serial));
        LDAPModification mod = new LDAPModification(2, attr);
        conn.modify(dn, mod);
    }

    public static void addCertToDB(LDAPConnection conn, String dn, X509CertImpl cert) throws LDAPException, EBaseException {
        BigInteger serialno = cert.getSerialNumber();
        X509CertImplMapper mapper = new X509CertImplMapper();
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        mapper.mapObjectToLDAPAttributeSet(null, null, cert, attrs);
        attrs.add(new LDAPAttribute("objectclass", "top"));
        attrs.add(new LDAPAttribute("objectclass", "certificateRecord"));
        attrs.add(new LDAPAttribute("serialno", BigIntegerMapper.BigIntegerToDB(serialno)));
        attrs.add(new LDAPAttribute("dateOfCreate", DateMapper.dateToDB(new Date())));
        attrs.add(new LDAPAttribute("dateOfModify", DateMapper.dateToDB(new Date())));
        attrs.add(new LDAPAttribute("certStatus", "VALID"));
        attrs.add(new LDAPAttribute("autoRenew", "ENABLED"));
        attrs.add(new LDAPAttribute("issuedBy", "installation"));
        LDAPEntry entry = new LDAPEntry("cn=" + serialno.toString() + "," + dn, attrs);
        conn.add(entry);
    }

    public static CertificateExtensions getExtensions(String tokenname, String nickname) throws NotInitializedException, TokenException, ObjectNotFoundException, IOException, CertificateException {
        Object fullnickname = nickname;
        if (!CryptoUtil.isInternalToken((String)tokenname)) {
            fullnickname = tokenname + ":" + nickname;
        }
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate cert = manager.findCertByNickname((String)fullnickname);
        X509CertImpl impl = new X509CertImpl(cert.getEncoded());
        X509CertInfo info = (X509CertInfo)impl.get("x509.info");
        return (CertificateExtensions)info.get("extensions");
    }
}

