/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.util.JSONSerializer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMERetention
implements JSONSerializer {
    private Long length;
    private ChronoUnit unit;

    public ACMERetention() {
    }

    public ACMERetention(Long length, ChronoUnit unit) {
        this.length = length;
        this.unit = unit;
    }

    public ACMERetention(Integer length, ChronoUnit unit) {
        this.length = (long)length;
        this.unit = unit;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public void setUnit(ChronoUnit unit) {
        this.unit = unit;
    }

    public Date getExpirationTime(Date currentTime) {
        if (this.length == null || this.unit == null) {
            return null;
        }
        Instant now = currentTime.toInstant();
        Instant expirationTime = now.plus((long)this.length, this.unit);
        return Date.from(expirationTime);
    }

    public void setProperty(String key, String value) throws Exception {
        if (key.equals("length")) {
            this.length = StringUtils.isEmpty((CharSequence)value) ? null : Long.valueOf(value);
        } else if (key.equals("unit")) {
            this.unit = StringUtils.isEmpty((CharSequence)value) ? null : ChronoUnit.valueOf(value);
        }
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ACMERetention retention = new ACMERetention(30, ChronoUnit.MINUTES);
        System.out.println(retention);
    }
}

