/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.key.KeyArchivalRequest;
import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyArchiveCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyArchiveCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyArchiveCLI(KRAKeyCLI keyCLI) {
        super("archive", "Archive a secret in the DRM.", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "clientKeyID", true, "Unique client key identifier.");
        option.setArgName("Client Key Identifier");
        this.options.addOption(option);
        option = new Option(null, "input-data", true, "Input file containing the data to be stored.");
        option.setArgName("Path");
        this.options.addOption(option);
        option = new Option(null, "passphrase", true, "Passphrase to be stored.");
        option.setArgName("Passphrase");
        this.options.addOption(option);
        option = new Option(null, "input-format", true, "Input format: xml (default), json");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Location of the request file.\nUsed for archiving already encrypted data.");
        option.setArgName("Input file path");
        this.options.addOption(option);
        option = new Option(null, "realm", true, "Authorization realm.");
        option.setArgName("Realm");
        this.options.addOption(option);
        option = new Option(null, "transport", true, "Transport certificate nickname.");
        option.setArgName("Nickname");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: none (default), json");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "oaep", false, "Use OAEP key wrap algorithm.");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String inputDataFile = cmd.getOptionValue("input-data");
        String passphrase = cmd.getOptionValue("passphrase");
        String clientKeyId = cmd.getOptionValue("clientKeyID");
        String realm = cmd.getOptionValue("realm");
        String inputFormat = cmd.getOptionValue("input-format", "xml");
        String requestFile = cmd.getOptionValue("input");
        String transportNickname = cmd.getOptionValue("transport");
        String outputFormat = cmd.getOptionValue("output-format", "none");
        boolean useOAEP = cmd.hasOption("oaep");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyRequestResponse response = null;
        KeyClient keyClient = this.keyCLI.getKeyClient(transportNickname);
        keyClient.setUseOAEP(useOAEP);
        if (inputDataFile != null) {
            if (clientKeyId == null) {
                throw new Exception("Missing Client Key ID.");
            }
            Path path = Paths.get(inputDataFile, new String[0]);
            byte[] data = Files.readAllBytes(path);
            response = keyClient.archiveSecret(clientKeyId, data, realm);
        } else if (passphrase != null) {
            if (clientKeyId == null) {
                throw new Exception("Missing Client Key ID.");
            }
            byte[] data = passphrase.getBytes("UTF-8");
            response = keyClient.archiveSecret(clientKeyId, data, realm);
        } else if (requestFile != null) {
            Path path = Paths.get(requestFile, new String[0]);
            String input = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            if (!"json".equalsIgnoreCase(inputFormat)) {
                throw new Exception("Unsupported input format: " + inputFormat);
            }
            KeyArchivalRequest req = (KeyArchivalRequest)JSONSerializer.fromJSON((String)input, KeyArchivalRequest.class);
            logger.info("Request: " + req.toJSON());
            response = req.getPKIArchiveOptions() != null ? keyClient.archivePKIOptions(req.getClientKeyId(), req.getDataType(), req.getKeyAlgorithm(), req.getKeySize().intValue(), Utils.base64decode((String)req.getPKIArchiveOptions()), req.getRealm()) : keyClient.archiveEncryptedData(req.getClientKeyId(), req.getDataType(), req.getKeyAlgorithm(), req.getKeySize(), req.getAlgorithmOID(), Utils.base64decode((String)req.getSymmetricAlgorithmParams()), Utils.base64decode((String)req.getWrappedPrivateData()), Utils.base64decode((String)req.getTransWrappedSessionKey()), req.getRealm());
        } else {
            throw new Exception("Missing input data, passphrase, or request.");
        }
        if (outputFormat.equalsIgnoreCase("json")) {
            System.out.println(response.toJSON());
        } else if (outputFormat.equalsIgnoreCase("none")) {
            MainCLI.printMessage("Archival request details");
            KRAKeyCLI.printKeyRequestInfo(response.getRequestInfo());
        } else {
            throw new Exception("Unsupported output format: " + outputFormat);
        }
    }
}

