/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.client.ClientConfig;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCertCLI;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCertImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCertImportCLI.class);

    public NSSCertImportCLI(NSSCertCLI nssCertCLI) {
        super("import", "Import certificate", (CLI)nssCertCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nickname]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "cert", true, "Certificate to import");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "trust", true, "Trust flags");
        option.setArgName("flags");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String nickname = null;
        if (cmdArgs.length >= 1) {
            nickname = cmdArgs[0];
        }
        String filename = cmd.getOptionValue("cert");
        String format = cmd.getOptionValue("format");
        String trustFlags = cmd.getOptionValue("trust");
        if (trustFlags == null) {
            trustFlags = ",,";
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        byte[] bytes = filename == null ? IOUtils.toByteArray((InputStream)System.in) : Files.readAllBytes(Paths.get(filename, new String[0]));
        if (format == null || "PEM".equalsIgnoreCase(format)) {
            bytes = Cert.parseCertificate((String)new String(bytes));
        } else if (!"DER".equalsIgnoreCase(format)) {
            throw new Exception("Unsupported format: " + format);
        }
        X509CertImpl cert = new X509CertImpl(bytes);
        ClientConfig clientConfig = mainCLI.getConfig();
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        String tokenName = clientConfig.getTokenName();
        if (nickname == null) {
            nssdb.addCertificate((X509Certificate)cert, trustFlags);
        } else {
            nssdb.addCertificate(tokenName, nickname, (X509Certificate)cert, trustFlags);
        }
    }
}

