/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSKeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.KeyPair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.nss.NSSDatabase;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkcs11.PK11PrivKey;

public class NSSKeyCreateCLI
extends CommandCLI {
    public NSSKeyCLI keyCLI;

    public NSSKeyCreateCLI(NSSKeyCLI keyCLI) {
        super("create", "Create key in NSS database", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nickname]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "key-type", true, "Key type: RSA (default), EC, AES");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "key-size", true, "Key size (RSA default: 2048, AES default: 256)");
        option.setArgName("size");
        this.options.addOption(option);
        this.options.addOption(null, "key-wrap", false, "Generate RSA key for wrapping/unwrapping.");
        option = new Option(null, "curve", true, "Elliptic curve name (default: nistp256)");
        option.setArgName("name");
        this.options.addOption(option);
        this.options.addOption(null, "ssl-ecdh", false, "Generate EC key for SSL with ECDH ECDSA.");
        this.options.addOption(null, "temporary", false, "Generate temporary key");
        option = new Option(null, "sensitive", true, "Generate sensitive key");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "extractable", true, "Generate extractable key");
        option.setArgName("boolean");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: text (default), json.");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        String[] cmdArgs = cmd.getArgs();
        String nickname = null;
        if (cmdArgs.length >= 1) {
            nickname = cmdArgs[0];
        }
        String keyType = cmd.getOptionValue("key-type", "RSA");
        String keySize = cmd.getOptionValue("key-size");
        boolean keyWrap = cmd.hasOption("key-wrap");
        String curve = cmd.getOptionValue("curve", "nistp256");
        boolean sslECDH = cmd.hasOption("ssl-ecdh");
        boolean temporary = cmd.hasOption("temporary");
        String sensitiveStr = cmd.getOptionValue("sensitive");
        Boolean sensitive = null;
        if (sensitiveStr != null) {
            sensitive = Boolean.valueOf(sensitiveStr);
        }
        String extractableStr = cmd.getOptionValue("extractable");
        Boolean extractable = null;
        if (extractableStr != null) {
            extractable = Boolean.valueOf(extractableStr);
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        NSSDatabase nssdb = mainCLI.getNSSDatabase();
        String tokenName = this.getConfig().getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        KeyInfo keyInfo = new KeyInfo();
        logger.info("Creating " + keyType + " in token " + tokenName);
        if ("RSA".equalsIgnoreCase(keyType)) {
            if (keySize == null) {
                keySize = "2048";
            }
            usages = keyWrap ? CryptoUtil.RSA_KEYPAIR_USAGES : null;
            KeyPairGeneratorSpi.Usage[] usagesMask = keyWrap ? CryptoUtil.RSA_KEYPAIR_USAGES_MASK : null;
            KeyPair keyPair = nssdb.createRSAKeyPair(token, Integer.parseInt(keySize), Boolean.valueOf(temporary), sensitive, extractable, usages, usagesMask);
            PK11PrivKey privateKey = (PK11PrivKey)keyPair.getPrivate();
            String hexKeyID = "0x" + Utils.HexEncode((byte[])privateKey.getUniqueID());
            keyInfo.setKeyId(new KeyId(hexKeyID));
            keyInfo.setType(privateKey.getType().toString());
            keyInfo.setAlgorithm(privateKey.getAlgorithm());
        } else if ("EC".equalsIgnoreCase(keyType)) {
            usages = null;
            KeyPairGeneratorSpi.Usage[] usagesMask = sslECDH ? CryptoUtil.ECDH_USAGES_MASK : CryptoUtil.ECDHE_USAGES_MASK;
            KeyPair keyPair = nssdb.createECKeyPair(token, curve, Boolean.valueOf(temporary), sensitive, extractable, usages, usagesMask);
            PK11PrivKey privateKey = (PK11PrivKey)keyPair.getPrivate();
            String hexKeyID = "0x" + Utils.HexEncode((byte[])privateKey.getUniqueID());
            keyInfo.setKeyId(new KeyId(hexKeyID));
            keyInfo.setType(privateKey.getType().toString());
            keyInfo.setAlgorithm(privateKey.getAlgorithm());
        } else if ("AES".equalsIgnoreCase(keyType)) {
            if (keySize == null) {
                keySize = "256";
            }
            if (nickname == null) {
                throw new CLIException("Missing key nickname");
            }
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.AES);
            kg.initialize(Integer.parseInt(keySize));
            kg.temporaryKeys(temporary);
            if (sensitive != null) {
                kg.sensitiveKeys(sensitive.booleanValue());
            }
            SymmetricKey symmetricKey = kg.generate();
            symmetricKey.setNickName(nickname);
            keyInfo.setNickname(nickname);
            keyInfo.setType(symmetricKey.getType().toString());
            keyInfo.setAlgorithm(symmetricKey.getAlgorithm());
        } else {
            throw new Exception("Unsupported key type: " + keyType);
        }
        String outputFormat = cmd.getOptionValue("output-format", "text");
        if (outputFormat.equalsIgnoreCase("json")) {
            System.out.println(keyInfo.toJSON());
        } else if (outputFormat.equalsIgnoreCase("text")) {
            NSSKeyCLI.printKeyInfo(keyInfo);
        } else {
            throw new Exception("Unsupported output format: " + outputFormat);
        }
    }
}

