/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.cmstools.tks.TKSKeyCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSKeyReplaceCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TKSKeyReplaceCLI.class);
    public TKSKeyCLI tksKeyCLI;

    public TKSKeyReplaceCLI(TKSKeyCLI tksKeyCLI) {
        super("replace", "Replace key in TKS", (CLI)tksKeyCLI);
        this.tksKeyCLI = tksKeyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <Key ID>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output-format", true, "Output format: text (default), json");
        option.setArgName("format");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing key ID");
        }
        String keyID = cmdArgs[0];
        String outputFormat = cmd.getOptionValue("output-format", "text");
        PKIClient client = this.getClient();
        TPSConnectorClient tpsConnectorClient = this.tksKeyCLI.getTPSConnectorClient();
        KeyData keyData = tpsConnectorClient.replaceSharedSecret(keyID);
        if ("json".equalsIgnoreCase(outputFormat)) {
            System.out.println(keyData.toJSON());
        } else {
            TKSKeyCLI.printKeyInfo(keyID, keyData);
        }
    }
}

