/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.connector;

import com.netscape.certsrv.tps.connector.ConnectorClient;
import com.netscape.certsrv.tps.connector.ConnectorCollection;
import com.netscape.certsrv.tps.connector.ConnectorData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.connector.ConnectorCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConnectorFindCLI.class);
    public ConnectorCLI connectorCLI;

    public ConnectorFindCLI(ConnectorCLI connectorCLI) {
        super("find", "Find connectors", (CLI)connectorCLI);
        this.connectorCLI = connectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [FILTER] [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "start", true, "Page start");
        option.setArgName("start");
        this.options.addOption(option);
        option = new Option(null, "size", true, "Page size");
        option.setArgName("size");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        String filter = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String s = cmd.getOptionValue("start");
        Integer start = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("size");
        Integer size = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConnectorClient connectorClient = this.connectorCLI.getConnectorClient();
        ConnectorCollection result = connectorClient.findConnectors(filter, start, size);
        MainCLI.printMessage(result.getTotal() + " entries matched");
        if (result.getTotal() == 0) {
            return;
        }
        Collection connectors = result.getEntries();
        boolean first = true;
        for (ConnectorData connectorData : connectors) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            ConnectorCLI.printConnectorData(connectorData, false);
        }
        MainCLI.printMessage("Number of entries returned " + connectors.size());
    }
}

