/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCertCLI;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCertAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserCertAddCLI.class);
    public UserCertCLI userCertCLI;

    public UserCertAddCLI(UserCertCLI userCertCLI) {
        super("add", "Add user certificate", (CLI)userCertCLI);
        this.userCertCLI = userCertCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "input", true, "Input file");
        option.setArgName("file");
        this.options.addOption(option);
        option = new Option(null, "serial", true, "Serial number of certificate in CA");
        option.setArgName("serial number");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String encoded;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No User ID specified.");
        }
        String userID = cmdArgs[0];
        String inputFile = cmd.getOptionValue("input");
        String serialNumber = cmd.getOptionValue("serial");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        if (inputFile != null && serialNumber != null) {
            throw new Exception("Conflicting options: --input and --serial.");
        }
        if (inputFile != null) {
            logger.info("Reading certificate from " + inputFile);
            encoded = new String(Files.readAllBytes(Paths.get(inputFile, new String[0])));
            logger.info("Certificate:\n" + encoded);
        } else if (serialNumber != null) {
            logger.info("Downloading certificate " + serialNumber);
            CAClient caClient = MainCLI.createCAClient(this.parent.getClient());
            CACertClient certClient = new CACertClient((SubsystemClient)caClient);
            CertData certData = certClient.getCert(new CertId(serialNumber));
            encoded = certData.getEncoded();
            logger.info("Certificate:\n" + encoded);
        } else {
            throw new Exception("Missing input file or serial number.");
        }
        UserCertData userCertData = new UserCertData();
        userCertData.setEncoded(encoded);
        logger.info("Request:\n" + userCertData);
        UserClient userClient = this.userCertCLI.getUserClient();
        userCertData = userClient.addUserCert(userID, userCertData);
        MainCLI.printMessage("Added certificate \"" + userCertData.getID() + "\"");
        UserCertCLI.printCert(userCertData, false, false);
    }
}

