/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.persist.FieldInfo;
import com.unboundid.ldap.sdk.persist.GetterInfo;
import com.unboundid.ldap.sdk.persist.LDAPDNField;
import com.unboundid.ldap.sdk.persist.LDAPEntryField;
import com.unboundid.ldap.sdk.persist.LDAPField;
import com.unboundid.ldap.sdk.persist.LDAPGetter;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPSetter;
import com.unboundid.ldap.sdk.persist.OIDAllocator;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.persist.PersistUtils;
import com.unboundid.ldap.sdk.persist.SetterInfo;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPObjectHandler<T>
implements Serializable {
    private static final long serialVersionUID = -1480360011153517161L;
    @NotNull
    private final Attribute objectClassAttribute;
    @NotNull
    private final Class<T> type;
    @NotNull
    private final Constructor<T> constructor;
    @NotNull
    private final DN defaultParentDN;
    @Nullable
    private final Field dnField;
    @Nullable
    private final Field entryField;
    @NotNull
    private final LDAPObject ldapObject;
    @Nullable
    private final LDAPObjectHandler<? super T> superclassHandler;
    @NotNull
    private final List<FieldInfo> alwaysAllowedFilterFields;
    @NotNull
    private final List<FieldInfo> conditionallyAllowedFilterFields;
    @NotNull
    private final List<FieldInfo> requiredFilterFields;
    @NotNull
    private final List<FieldInfo> rdnFields;
    @NotNull
    private final List<GetterInfo> alwaysAllowedFilterGetters;
    @NotNull
    private final List<GetterInfo> conditionallyAllowedFilterGetters;
    @NotNull
    private final List<GetterInfo> requiredFilterGetters;
    @NotNull
    private final List<GetterInfo> rdnGetters;
    @NotNull
    private final Map<String, FieldInfo> fieldMap;
    @NotNull
    private final Map<String, GetterInfo> getterMap;
    @NotNull
    private final Map<String, SetterInfo> setterMap;
    @Nullable
    private final Method postDecodeMethod;
    @Nullable
    private final Method postEncodeMethod;
    @NotNull
    private final String structuralClass;
    @NotNull
    private final String[] attributesToRequest;
    @NotNull
    private final String[] auxiliaryClasses;
    @NotNull
    private final String[] explicitAttributesToRequest;
    @NotNull
    private final String[] lazilyLoadedAttributes;
    @NotNull
    private final String[] superiorClasses;

    LDAPObjectHandler(@NotNull Class<T> type) throws LDAPPersistException {
        LDAPObject superclassAnnotation;
        this.type = type;
        Class<T> superclassType = type.getSuperclass();
        this.superclassHandler = superclassType == null ? null : ((superclassAnnotation = superclassType.getAnnotation(LDAPObject.class)) == null ? null : new LDAPObjectHandler<T>(superclassType));
        TreeMap<String, FieldInfo> fields = new TreeMap<String, FieldInfo>();
        TreeMap<String, Serializable> getters = new TreeMap<String, Serializable>();
        TreeMap<String, Serializable> setters = new TreeMap<String, Serializable>();
        this.ldapObject = type.getAnnotation(LDAPObject.class);
        if (this.ldapObject == null) {
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_OBJECT_NOT_ANNOTATED.get(type.getName()));
        }
        LinkedHashMap<String, String> objectClasses = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        String oc = this.ldapObject.structuralClass();
        this.structuralClass = oc.isEmpty() ? StaticUtils.getUnqualifiedClassName(type) : oc;
        StringBuilder invalidReason = new StringBuilder();
        if (!PersistUtils.isValidLDAPName(this.structuralClass, invalidReason)) {
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_STRUCTURAL_CLASS.get(type.getName(), this.structuralClass, invalidReason.toString()));
        }
        objectClasses.put(StaticUtils.toLowerCase(this.structuralClass), this.structuralClass);
        for (String auxiliaryClass : this.auxiliaryClasses = this.ldapObject.auxiliaryClass()) {
            if (!PersistUtils.isValidLDAPName(auxiliaryClass, invalidReason)) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_AUXILIARY_CLASS.get(type.getName(), auxiliaryClass, invalidReason.toString()));
            }
            objectClasses.put(StaticUtils.toLowerCase(auxiliaryClass), auxiliaryClass);
        }
        this.superiorClasses = this.ldapObject.superiorClass();
        for (String superiorClass : this.superiorClasses) {
            if (!PersistUtils.isValidLDAPName(superiorClass, invalidReason)) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_SUPERIOR_CLASS.get(type.getName(), superiorClass, invalidReason.toString()));
            }
            objectClasses.put(StaticUtils.toLowerCase(superiorClass), superiorClass);
        }
        if (this.superclassHandler != null) {
            for (String s : this.superclassHandler.objectClassAttribute.getValues()) {
                objectClasses.put(StaticUtils.toLowerCase(s), s);
            }
        }
        this.objectClassAttribute = new Attribute("objectClass", objectClasses.values());
        String parentDNStr = this.ldapObject.defaultParentDN();
        try {
            this.defaultParentDN = parentDNStr.isEmpty() && this.superclassHandler != null ? this.superclassHandler.getDefaultParentDN() : new DN(parentDNStr);
        }
        catch (LDAPException le) {
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_DEFAULT_PARENT.get(type.getName(), parentDNStr, le.getMessage()), (Throwable)le);
        }
        String postDecodeMethodName = this.ldapObject.postDecodeMethod();
        if (!postDecodeMethodName.isEmpty()) {
            try {
                this.postDecodeMethod = type.getDeclaredMethod(postDecodeMethodName, new Class[0]);
                this.postDecodeMethod.setAccessible(true);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_POST_DECODE_METHOD.get(type.getName(), postDecodeMethodName, StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        } else {
            this.postDecodeMethod = null;
        }
        String postEncodeMethodName = this.ldapObject.postEncodeMethod();
        if (!postEncodeMethodName.isEmpty()) {
            try {
                this.postEncodeMethod = type.getDeclaredMethod(postEncodeMethodName, Entry.class);
                this.postEncodeMethod.setAccessible(true);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_POST_ENCODE_METHOD.get(type.getName(), postEncodeMethodName, StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        } else {
            this.postEncodeMethod = null;
        }
        try {
            this.constructor = type.getDeclaredConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_NO_DEFAULT_CONSTRUCTOR.get(type.getName()), (Throwable)e);
        }
        Field tmpDNField = null;
        Field tmpEntryField = null;
        LinkedList<FieldInfo> tmpRFilterFields = new LinkedList<FieldInfo>();
        LinkedList<FieldInfo> tmpAAFilterFields = new LinkedList<FieldInfo>();
        LinkedList<FieldInfo> tmpCAFilterFields = new LinkedList<FieldInfo>();
        LinkedList<FieldInfo> tmpRDNFields = new LinkedList<FieldInfo>();
        for (Field f : type.getDeclaredFields()) {
            Class<?> fieldType;
            LDAPField fieldAnnotation = f.getAnnotation(LDAPField.class);
            LDAPDNField dnFieldAnnotation = f.getAnnotation(LDAPDNField.class);
            LDAPEntryField entryFieldAnnotation = f.getAnnotation(LDAPEntryField.class);
            if (fieldAnnotation != null) {
                f.setAccessible(true);
                FieldInfo fieldInfo = new FieldInfo(f, type);
                String attrName = StaticUtils.toLowerCase(fieldInfo.getAttributeName());
                if (fields.containsKey(attrName)) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ATTR_CONFLICT.get(type.getName(), fieldInfo.getAttributeName()));
                }
                fields.put(attrName, fieldInfo);
                switch (fieldInfo.getFilterUsage()) {
                    case REQUIRED: {
                        tmpRFilterFields.add(fieldInfo);
                        break;
                    }
                    case ALWAYS_ALLOWED: {
                        tmpAAFilterFields.add(fieldInfo);
                        break;
                    }
                    case CONDITIONALLY_ALLOWED: {
                        tmpCAFilterFields.add(fieldInfo);
                        break;
                    }
                }
                if (fieldInfo.includeInRDN()) {
                    tmpRDNFields.add(fieldInfo);
                }
            }
            if (dnFieldAnnotation != null) {
                f.setAccessible(true);
                if (fieldAnnotation != null) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_CONFLICTING_FIELD_ANNOTATIONS.get(type.getName(), "LDAPField", "LDAPDNField", f.getName()));
                }
                if (tmpDNField != null) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_MULTIPLE_DN_FIELDS.get(type.getName()));
                }
                int modifiers = f.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_DN_FIELD_FINAL.get(f.getName(), type.getName()));
                }
                if (Modifier.isStatic(modifiers)) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_DN_FIELD_STATIC.get(f.getName(), type.getName()));
                }
                fieldType = f.getType();
                if (fieldType.equals(String.class)) {
                    tmpDNField = f;
                } else {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_DN_FIELD_TYPE.get(type.getName(), f.getName(), fieldType.getName()));
                }
            }
            if (entryFieldAnnotation == null) continue;
            f.setAccessible(true);
            if (fieldAnnotation != null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_CONFLICTING_FIELD_ANNOTATIONS.get(type.getName(), "LDAPField", "LDAPEntryField", f.getName()));
            }
            if (tmpEntryField != null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_MULTIPLE_ENTRY_FIELDS.get(type.getName()));
            }
            int modifiers = f.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ENTRY_FIELD_FINAL.get(f.getName(), type.getName()));
            }
            if (Modifier.isStatic(modifiers)) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ENTRY_FIELD_STATIC.get(f.getName(), type.getName()));
            }
            fieldType = f.getType();
            if (fieldType.equals(ReadOnlyEntry.class)) {
                tmpEntryField = f;
                continue;
            }
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_ENTRY_FIELD_TYPE.get(type.getName(), f.getName(), fieldType.getName()));
        }
        this.dnField = tmpDNField;
        this.entryField = tmpEntryField;
        this.requiredFilterFields = Collections.unmodifiableList(tmpRFilterFields);
        this.alwaysAllowedFilterFields = Collections.unmodifiableList(tmpAAFilterFields);
        this.conditionallyAllowedFilterFields = Collections.unmodifiableList(tmpCAFilterFields);
        this.rdnFields = Collections.unmodifiableList(tmpRDNFields);
        LinkedList<Serializable> tmpRFilterGetters = new LinkedList<Serializable>();
        LinkedList<Serializable> tmpAAFilterGetters = new LinkedList<Serializable>();
        LinkedList<Serializable> tmpCAFilterGetters = new LinkedList<Serializable>();
        LinkedList<Serializable> tmpRDNGetters = new LinkedList<Serializable>();
        for (Method m : type.getDeclaredMethods()) {
            String attrName;
            Serializable methodInfo;
            LDAPGetter getter = m.getAnnotation(LDAPGetter.class);
            LDAPSetter setter = m.getAnnotation(LDAPSetter.class);
            if (getter != null) {
                m.setAccessible(true);
                if (setter != null) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_CONFLICTING_METHOD_ANNOTATIONS.get(type.getName(), "LDAPGetter", "LDAPSetter", m.getName()));
                }
                methodInfo = new GetterInfo(m, type);
                attrName = StaticUtils.toLowerCase(((GetterInfo)methodInfo).getAttributeName());
                if (fields.containsKey(attrName) || getters.containsKey(attrName)) {
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ATTR_CONFLICT.get(type.getName(), ((GetterInfo)methodInfo).getAttributeName()));
                }
                getters.put(attrName, methodInfo);
                switch (((GetterInfo)methodInfo).getFilterUsage()) {
                    case REQUIRED: {
                        tmpRFilterGetters.add(methodInfo);
                        break;
                    }
                    case ALWAYS_ALLOWED: {
                        tmpAAFilterGetters.add(methodInfo);
                        break;
                    }
                    case CONDITIONALLY_ALLOWED: {
                        tmpCAFilterGetters.add(methodInfo);
                        break;
                    }
                }
                if (((GetterInfo)methodInfo).includeInRDN()) {
                    tmpRDNGetters.add(methodInfo);
                }
            }
            if (setter == null) continue;
            m.setAccessible(true);
            methodInfo = new SetterInfo(m, type);
            attrName = StaticUtils.toLowerCase(((SetterInfo)methodInfo).getAttributeName());
            if (fields.containsKey(attrName) || setters.containsKey(attrName)) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ATTR_CONFLICT.get(type.getName(), ((SetterInfo)methodInfo).getAttributeName()));
            }
            setters.put(attrName, methodInfo);
        }
        this.requiredFilterGetters = Collections.unmodifiableList(tmpRFilterGetters);
        this.alwaysAllowedFilterGetters = Collections.unmodifiableList(tmpAAFilterGetters);
        this.conditionallyAllowedFilterGetters = Collections.unmodifiableList(tmpCAFilterGetters);
        this.rdnGetters = Collections.unmodifiableList(tmpRDNGetters);
        if (this.rdnFields.isEmpty() && this.rdnGetters.isEmpty() && this.superclassHandler == null) {
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_NO_RDN_DEFINED.get(type.getName()));
        }
        this.fieldMap = Collections.unmodifiableMap(fields);
        this.getterMap = Collections.unmodifiableMap(getters);
        this.setterMap = Collections.unmodifiableMap(setters);
        TreeSet<String> attrSet = new TreeSet<String>();
        TreeSet<String> lazySet = new TreeSet<String>();
        for (Serializable i : fields.values()) {
            if (((FieldInfo)i).lazilyLoad()) {
                lazySet.add(((FieldInfo)i).getAttributeName());
                continue;
            }
            attrSet.add(((FieldInfo)i).getAttributeName());
        }
        for (Serializable i : setters.values()) {
            attrSet.add(((SetterInfo)i).getAttributeName());
        }
        if (this.superclassHandler != null) {
            attrSet.addAll(Arrays.asList(this.superclassHandler.explicitAttributesToRequest));
            lazySet.addAll(Arrays.asList(this.superclassHandler.lazilyLoadedAttributes));
        }
        this.explicitAttributesToRequest = new String[attrSet.size()];
        attrSet.toArray(this.explicitAttributesToRequest);
        this.attributesToRequest = this.requestAllAttributes() ? new String[]{"*", "+"} : this.explicitAttributesToRequest;
        this.lazilyLoadedAttributes = new String[lazySet.size()];
        lazySet.toArray(this.lazilyLoadedAttributes);
    }

    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    @Nullable
    public LDAPObjectHandler<?> getSuperclassHandler() {
        return this.superclassHandler;
    }

    @NotNull
    public LDAPObject getLDAPObjectAnnotation() {
        return this.ldapObject;
    }

    @NotNull
    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    @Nullable
    public Field getDNField() {
        return this.dnField;
    }

    @Nullable
    public Field getEntryField() {
        return this.entryField;
    }

    @NotNull
    public DN getDefaultParentDN() {
        return this.defaultParentDN;
    }

    @NotNull
    public String getStructuralClass() {
        return this.structuralClass;
    }

    @NotNull
    public String[] getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    @NotNull
    public String[] getSuperiorClasses() {
        return this.superiorClasses;
    }

    public boolean requestAllAttributes() {
        return this.ldapObject.requestAllAttributes() || this.superclassHandler != null && this.superclassHandler.requestAllAttributes();
    }

    @NotNull
    public String[] getAttributesToRequest() {
        return this.attributesToRequest;
    }

    @NotNull
    public String[] getLazilyLoadedAttributes() {
        return this.lazilyLoadedAttributes;
    }

    @Nullable
    public String getEntryDN(@NotNull T o) throws LDAPPersistException {
        String dnFieldValue = this.getDNFieldValue(o);
        if (dnFieldValue != null) {
            return dnFieldValue;
        }
        ReadOnlyEntry entry = this.getEntry(o);
        if (entry != null) {
            return entry.getDN();
        }
        return null;
    }

    @Nullable
    private String getDNFieldValue(@NotNull T o) throws LDAPPersistException {
        if (this.dnField != null) {
            try {
                Object dnObject = this.dnField.get(o);
                if (dnObject == null) {
                    return null;
                }
                return String.valueOf(dnObject);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_ACCESSING_DN_FIELD.get(this.dnField.getName(), this.type.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        if (this.superclassHandler != null) {
            return super.getDNFieldValue((T)o);
        }
        return null;
    }

    @Nullable
    public ReadOnlyEntry getEntry(@NotNull T o) throws LDAPPersistException {
        if (this.entryField != null) {
            try {
                Object entryObject = this.entryField.get(o);
                if (entryObject == null) {
                    return null;
                }
                return (ReadOnlyEntry)entryObject;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_ACCESSING_ENTRY_FIELD.get(this.entryField.getName(), this.type.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
            }
        }
        if (this.superclassHandler != null) {
            return this.superclassHandler.getEntry(o);
        }
        return null;
    }

    @NotNull
    public Map<String, FieldInfo> getFields() {
        return this.fieldMap;
    }

    @NotNull
    public Map<String, GetterInfo> getGetters() {
        return this.getterMap;
    }

    @NotNull
    public Map<String, SetterInfo> getSetters() {
        return this.setterMap;
    }

    @NotNull
    List<ObjectClassDefinition> constructObjectClasses(@NotNull OIDAllocator a) throws LDAPPersistException {
        String lowerStructuralClass;
        LinkedHashMap<String, ObjectClassDefinition> ocMap = new LinkedHashMap<String, ObjectClassDefinition>(StaticUtils.computeMapCapacity(1 + this.auxiliaryClasses.length));
        if (this.superclassHandler != null) {
            for (ObjectClassDefinition d : this.superclassHandler.constructObjectClasses(a)) {
                ocMap.put(StaticUtils.toLowerCase(d.getNameOrOID()), d);
            }
        }
        if (!ocMap.containsKey(lowerStructuralClass = StaticUtils.toLowerCase(this.structuralClass))) {
            if (this.superclassHandler == null) {
                ocMap.put(lowerStructuralClass, this.constructObjectClass(this.structuralClass, "top", ObjectClassType.STRUCTURAL, a));
            } else {
                ocMap.put(lowerStructuralClass, this.constructObjectClass(this.structuralClass, this.superclassHandler.getStructuralClass(), ObjectClassType.STRUCTURAL, a));
            }
        }
        for (String s : this.auxiliaryClasses) {
            String lowerName = StaticUtils.toLowerCase(s);
            if (ocMap.containsKey(lowerName)) continue;
            ocMap.put(lowerName, this.constructObjectClass(s, "top", ObjectClassType.AUXILIARY, a));
        }
        return Collections.unmodifiableList(new ArrayList(ocMap.values()));
    }

    @NotNull
    private ObjectClassDefinition constructObjectClass(@NotNull String name, @NotNull String sup, @NotNull ObjectClassType type, @NotNull OIDAllocator a) {
        String attrName;
        boolean found;
        TreeMap<String, String> requiredAttrs = new TreeMap<String, String>();
        TreeMap<String, String> optionalAttrs = new TreeMap<String, String>();
        for (FieldInfo fieldInfo : this.fieldMap.values()) {
            found = false;
            for (String s : fieldInfo.getObjectClasses()) {
                if (!name.equalsIgnoreCase(s)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            attrName = fieldInfo.getAttributeName();
            String lowerName = StaticUtils.toLowerCase(attrName);
            if (fieldInfo.includeInRDN() || fieldInfo.isRequiredForDecode() && fieldInfo.isRequiredForEncode()) {
                requiredAttrs.put(lowerName, attrName);
                continue;
            }
            optionalAttrs.put(lowerName, attrName);
        }
        for (GetterInfo getterInfo : this.getterMap.values()) {
            found = false;
            for (String s : getterInfo.getObjectClasses()) {
                if (!name.equalsIgnoreCase(s)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            attrName = getterInfo.getAttributeName();
            String lowerName = StaticUtils.toLowerCase(attrName);
            if (getterInfo.includeInRDN()) {
                requiredAttrs.put(lowerName, attrName);
                continue;
            }
            optionalAttrs.put(lowerName, attrName);
        }
        if (name.equalsIgnoreCase(this.structuralClass)) {
            for (SetterInfo setterInfo : this.setterMap.values()) {
                String attrName2 = setterInfo.getAttributeName();
                String lowerName = StaticUtils.toLowerCase(attrName2);
                if (requiredAttrs.containsKey(lowerName) || optionalAttrs.containsKey(lowerName)) continue;
                optionalAttrs.put(lowerName, attrName2);
            }
        }
        String[] reqArray = new String[requiredAttrs.size()];
        requiredAttrs.values().toArray(reqArray);
        String[] stringArray = new String[optionalAttrs.size()];
        optionalAttrs.values().toArray(stringArray);
        return new ObjectClassDefinition(a.allocateObjectClassOID(name), new String[]{name}, null, false, new String[]{sup}, type, reqArray, stringArray, null);
    }

    @NotNull
    T decode(@NotNull Entry e) throws LDAPPersistException {
        T o;
        try {
            o = this.constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            if (ex instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_INVOKING_CONSTRUCTOR.get(this.type.getName(), StaticUtils.getExceptionMessage(targetException)), targetException);
            }
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_INVOKING_CONSTRUCTOR.get(this.type.getName(), StaticUtils.getExceptionMessage(ex)), (Throwable)ex);
        }
        this.decode(o, e);
        return o;
    }

    void decode(@NotNull T o, @NotNull Entry e) throws LDAPPersistException {
        if (this.superclassHandler != null) {
            this.superclassHandler.decode(o, e);
        }
        this.setDNAndEntryFields(o, e);
        ArrayList<String> failureReasons = new ArrayList<String>(5);
        boolean successful = true;
        for (FieldInfo fieldInfo : this.fieldMap.values()) {
            successful &= fieldInfo.decode(o, e, failureReasons);
        }
        for (SetterInfo setterInfo : this.setterMap.values()) {
            successful &= setterInfo.invokeSetter(o, e, failureReasons);
        }
        Throwable cause = null;
        if (this.postDecodeMethod != null) {
            try {
                this.postDecodeMethod.invoke(o, new Object[0]);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                StaticUtils.rethrowIfError(exception);
                cause = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
                successful = false;
                failureReasons.add(PersistMessages.ERR_OBJECT_HANDLER_ERROR_INVOKING_POST_DECODE_METHOD.get(this.postDecodeMethod.getName(), this.type.getName(), StaticUtils.getExceptionMessage(exception)));
            }
        }
        if (!successful) {
            throw new LDAPPersistException(StaticUtils.concatenateStrings(failureReasons), o, cause);
        }
    }

    @NotNull
    Entry encode(@NotNull T o, @Nullable String parentDN) throws LDAPPersistException {
        Attribute a;
        Serializable i;
        LinkedHashMap<String, Attribute> attrMap = new LinkedHashMap<String, Attribute>(StaticUtils.computeMapCapacity(20));
        attrMap.put("objectClass", this.objectClassAttribute);
        for (Map.Entry<String, FieldInfo> entry : this.fieldMap.entrySet()) {
            i = entry.getValue();
            if (!((FieldInfo)i).includeInAdd() || (a = ((FieldInfo)i).encode(o, false)) == null) continue;
            attrMap.put(entry.getKey(), a);
        }
        for (Map.Entry<String, Serializable> entry : this.getterMap.entrySet()) {
            i = (GetterInfo)entry.getValue();
            if (!((GetterInfo)i).includeInAdd() || (a = ((GetterInfo)i).encode(o)) == null) continue;
            attrMap.put(entry.getKey(), a);
        }
        String dn = this.constructDN(o, parentDN, attrMap);
        Entry entry = new Entry(dn, attrMap.values());
        if (this.postEncodeMethod != null) {
            try {
                this.postEncodeMethod.invoke(o, entry);
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                if (ex instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                    throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_INVOKING_POST_ENCODE_METHOD.get(this.postEncodeMethod.getName(), this.type.getName(), StaticUtils.getExceptionMessage(targetException)), targetException);
                }
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_INVOKING_POST_ENCODE_METHOD.get(this.postEncodeMethod.getName(), this.type.getName(), StaticUtils.getExceptionMessage(ex)), (Throwable)ex);
            }
        }
        this.setDNAndEntryFields(o, entry);
        if (this.superclassHandler != null) {
            Entry e = this.superclassHandler.encode(o, parentDN);
            for (Attribute a2 : e.getAttributes()) {
                entry.addAttribute(a2);
            }
        }
        return entry;
    }

    private void setDNAndEntryFields(@NotNull T o, @NotNull Entry e) throws LDAPPersistException {
        if (this.dnField != null) {
            try {
                if (this.dnField.get(o) == null) {
                    this.dnField.set(o, e.getDN());
                }
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_SETTING_DN.get(this.type.getName(), e.getDN(), this.dnField.getName(), StaticUtils.getExceptionMessage(ex)), (Throwable)ex);
            }
        }
        if (this.entryField != null) {
            try {
                if (this.entryField.get(o) == null) {
                    this.entryField.set(o, new ReadOnlyEntry(e));
                }
            }
            catch (Exception ex) {
                Debug.debugException(ex);
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_ERROR_SETTING_ENTRY.get(this.type.getName(), this.entryField.getName(), StaticUtils.getExceptionMessage(ex)), (Throwable)ex);
            }
        }
        if (this.superclassHandler != null) {
            super.setDNAndEntryFields((T)o, e);
        }
    }

    @NotNull
    public String constructDN(@NotNull T o, @Nullable String parentDN) throws LDAPPersistException {
        Attribute a;
        String existingDN = this.getEntryDN(o);
        if (existingDN != null) {
            return existingDN;
        }
        int numRDNs = this.rdnFields.size() + this.rdnGetters.size();
        if (numRDNs == 0) {
            return this.superclassHandler.constructDN(o, parentDN);
        }
        LinkedHashMap<String, Attribute> attrMap = new LinkedHashMap<String, Attribute>(StaticUtils.computeMapCapacity(numRDNs));
        for (FieldInfo fieldInfo : this.rdnFields) {
            a = fieldInfo.encode(o, true);
            if (a == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_RDN_FIELD_MISSING_VALUE.get(this.type.getName(), fieldInfo.getField().getName()));
            }
            attrMap.put(StaticUtils.toLowerCase(fieldInfo.getAttributeName()), a);
        }
        for (GetterInfo getterInfo : this.rdnGetters) {
            a = getterInfo.encode(o);
            if (a == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_RDN_GETTER_MISSING_VALUE.get(this.type.getName(), getterInfo.getMethod().getName()));
            }
            attrMap.put(StaticUtils.toLowerCase(getterInfo.getAttributeName()), a);
        }
        return this.constructDN(o, parentDN, attrMap);
    }

    @NotNull
    String constructDN(@NotNull T o, @Nullable String parentDN, @NotNull Map<String, Attribute> attrMap) throws LDAPPersistException {
        Attribute a;
        String existingDN = this.getEntryDN(o);
        if (existingDN != null) {
            return existingDN;
        }
        int numRDNs = this.rdnFields.size() + this.rdnGetters.size();
        if (numRDNs == 0) {
            return this.superclassHandler.constructDN(o, parentDN);
        }
        ArrayList<String> rdnNameList = new ArrayList<String>(numRDNs);
        ArrayList<byte[]> rdnValueList = new ArrayList<byte[]>(numRDNs);
        for (FieldInfo fieldInfo : this.rdnFields) {
            a = attrMap.get(StaticUtils.toLowerCase(fieldInfo.getAttributeName()));
            if (a == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_RDN_FIELD_MISSING_VALUE.get(this.type.getName(), fieldInfo.getField().getName()));
            }
            rdnNameList.add(a.getName());
            rdnValueList.add(a.getValueByteArray());
        }
        for (GetterInfo getterInfo : this.rdnGetters) {
            a = attrMap.get(StaticUtils.toLowerCase(getterInfo.getAttributeName()));
            if (a == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_RDN_GETTER_MISSING_VALUE.get(this.type.getName(), getterInfo.getMethod().getName()));
            }
            rdnNameList.add(a.getName());
            rdnValueList.add(a.getValueByteArray());
        }
        String[] rdnNames = new String[rdnNameList.size()];
        rdnNameList.toArray(rdnNames);
        byte[][] byArrayArray = new byte[rdnNames.length][];
        rdnValueList.toArray((T[])byArrayArray);
        RDN rdn = new RDN(rdnNames, byArrayArray);
        if (parentDN == null) {
            return new DN(rdn, this.defaultParentDN).toString();
        }
        try {
            DN parsedParentDN = new DN(parentDN);
            return new DN(rdn, parsedParentDN).toString();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_INVALID_PARENT_DN.get(this.type.getName(), parentDN, le.getMessage()), (Throwable)le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    List<Modification> getModifications(@NotNull T o, boolean deleteNullValues, boolean byteForByte, String ... attributes) throws LDAPPersistException {
        Attribute originalAttr;
        Serializable i;
        String attrName;
        HashSet<String> attrSet;
        ReadOnlyEntry originalEntry = this.entryField != null ? this.getEntry(o) : null;
        if (originalEntry != null) {
            try {
                Object iterator;
                T decodedOrig = this.decode(originalEntry);
                Entry reEncodedOriginal = this.encode(decodedOrig, originalEntry.getParentDNString());
                Entry newEntry = this.encode(o, originalEntry.getParentDNString());
                List<Modification> list = Entry.diff(reEncodedOriginal, newEntry, true, false, byteForByte, attributes);
                if (!deleteNullValues) {
                    Iterator<Modification> iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        Modification m = iterator2.next();
                        if (m.getRawValues().length != 0) continue;
                        iterator2.remove();
                    }
                }
                HashSet<String> stripAttrs = null;
                for (FieldInfo fieldInfo : this.fieldMap.values()) {
                    if (fieldInfo.includeInModify()) continue;
                    if (stripAttrs == null) {
                        stripAttrs = new HashSet<String>(StaticUtils.computeMapCapacity(10));
                    }
                    stripAttrs.add(StaticUtils.toLowerCase(fieldInfo.getAttributeName()));
                }
                for (GetterInfo getterInfo : this.getterMap.values()) {
                    if (getterInfo.includeInModify()) continue;
                    if (stripAttrs == null) {
                        stripAttrs = new HashSet(StaticUtils.computeMapCapacity(10));
                    }
                    stripAttrs.add(StaticUtils.toLowerCase(getterInfo.getAttributeName()));
                }
                if (stripAttrs != null) {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Modification modification = (Modification)iterator.next();
                        if (!stripAttrs.contains(StaticUtils.toLowerCase(modification.getAttributeName()))) continue;
                        iterator.remove();
                    }
                }
                iterator = list;
                return iterator;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            finally {
                this.setDNAndEntryFields(o, originalEntry);
            }
        }
        if (attributes == null || attributes.length == 0) {
            attrSet = null;
        } else {
            void var9_16;
            attrSet = new HashSet<String>(StaticUtils.computeMapCapacity(attributes.length));
            String[] arr$ = attributes;
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_16 < len$) {
                String s = arr$[var9_16];
                attrSet.add(StaticUtils.toLowerCase(s));
                ++var9_16;
            }
        }
        ArrayList<Modification> mods = new ArrayList<Modification>(5);
        for (Map.Entry<String, FieldInfo> entry : this.fieldMap.entrySet()) {
            attrName = StaticUtils.toLowerCase(entry.getKey());
            if (attrSet != null && !attrSet.contains(attrName) || !((FieldInfo)(i = entry.getValue())).includeInModify()) continue;
            Attribute attribute = ((FieldInfo)i).encode(o, false);
            if (attribute == null) {
                if (!deleteNullValues || originalEntry != null && !originalEntry.hasAttribute(attrName)) continue;
                mods.add(new Modification(ModificationType.REPLACE, ((FieldInfo)i).getAttributeName()));
                continue;
            }
            if (originalEntry != null && (originalAttr = originalEntry.getAttribute(attrName)) != null && originalAttr.equals(attribute)) continue;
            mods.add(new Modification(ModificationType.REPLACE, ((FieldInfo)i).getAttributeName(), attribute.getRawValues()));
        }
        for (Map.Entry<String, Serializable> entry : this.getterMap.entrySet()) {
            attrName = StaticUtils.toLowerCase(entry.getKey());
            if (attrSet != null && !attrSet.contains(attrName) || !((GetterInfo)(i = (GetterInfo)entry.getValue())).includeInModify()) continue;
            Attribute attribute = ((GetterInfo)i).encode(o);
            if (attribute == null) {
                if (!deleteNullValues || originalEntry != null && !originalEntry.hasAttribute(attrName)) continue;
                mods.add(new Modification(ModificationType.REPLACE, ((GetterInfo)i).getAttributeName()));
                continue;
            }
            if (originalEntry != null && (originalAttr = originalEntry.getAttribute(attrName)) != null && originalAttr.equals(attribute)) continue;
            mods.add(new Modification(ModificationType.REPLACE, ((GetterInfo)i).getAttributeName(), attribute.getRawValues()));
        }
        if (this.superclassHandler != null) {
            List<Modification> superMods = this.superclassHandler.getModifications(o, deleteNullValues, byteForByte, attributes);
            ArrayList<Modification> arrayList = new ArrayList<Modification>(superMods.size());
            for (Modification sm : superMods) {
                boolean bl = true;
                for (Modification m : mods) {
                    if (!m.getAttributeName().equalsIgnoreCase(sm.getAttributeName())) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(sm);
            }
            mods.addAll(arrayList);
        }
        return Collections.unmodifiableList(mods);
    }

    @NotNull
    public Filter createBaseFilter() {
        if (this.auxiliaryClasses.length == 0) {
            return Filter.createEqualityFilter("objectClass", this.structuralClass);
        }
        ArrayList<Filter> comps = new ArrayList<Filter>(1 + this.auxiliaryClasses.length);
        comps.add(Filter.createEqualityFilter("objectClass", this.structuralClass));
        for (String s : this.auxiliaryClasses) {
            comps.add(Filter.createEqualityFilter("objectClass", s));
        }
        return Filter.createANDFilter(comps);
    }

    @NotNull
    public Filter createFilter(@NotNull T o) throws LDAPPersistException {
        AtomicBoolean addedRequiredOrAllowed = new AtomicBoolean(false);
        Filter f = this.createFilter(o, addedRequiredOrAllowed);
        if (!addedRequiredOrAllowed.get()) {
            throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_FILTER_MISSING_REQUIRED_OR_ALLOWED.get());
        }
        return f;
    }

    @NotNull
    private Filter createFilter(@NotNull T o, @NotNull AtomicBoolean addedRequiredOrAllowed) throws LDAPPersistException {
        Attribute a2;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(5);
        attrs.add(this.objectClassAttribute);
        for (FieldInfo fieldInfo : this.requiredFilterFields) {
            Attribute a2 = fieldInfo.encode(o, true);
            if (a2 == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_FILTER_MISSING_REQUIRED_FIELD.get(fieldInfo.getField().getName()));
            }
            attrs.add(a2);
            addedRequiredOrAllowed.set(true);
        }
        for (GetterInfo getterInfo : this.requiredFilterGetters) {
            a2 = getterInfo.encode(o);
            if (a2 == null) {
                throw new LDAPPersistException(PersistMessages.ERR_OBJECT_HANDLER_FILTER_MISSING_REQUIRED_GETTER.get(getterInfo.getMethod().getName()));
            }
            attrs.add(a2);
            addedRequiredOrAllowed.set(true);
        }
        for (FieldInfo fieldInfo : this.alwaysAllowedFilterFields) {
            a2 = fieldInfo.encode(o, true);
            if (a2 == null) continue;
            attrs.add(a2);
            addedRequiredOrAllowed.set(true);
        }
        for (GetterInfo getterInfo : this.alwaysAllowedFilterGetters) {
            a2 = getterInfo.encode(o);
            if (a2 == null) continue;
            attrs.add(a2);
            addedRequiredOrAllowed.set(true);
        }
        for (FieldInfo fieldInfo : this.conditionallyAllowedFilterFields) {
            a2 = fieldInfo.encode(o, true);
            if (a2 == null) continue;
            attrs.add(a2);
        }
        for (GetterInfo getterInfo : this.conditionallyAllowedFilterGetters) {
            a2 = getterInfo.encode(o);
            if (a2 == null) continue;
            attrs.add(a2);
        }
        ArrayList<Filter> comps = new ArrayList<Filter>(attrs.size());
        for (Attribute a2 : attrs) {
            for (ASN1OctetString v : a2.getRawValues()) {
                comps.add(Filter.createEqualityFilter(a2.getName(), v.getValue()));
            }
        }
        if (this.superclassHandler != null) {
            Filter filter = super.createFilter((T)o, addedRequiredOrAllowed);
            if (filter.getFilterType() == -96) {
                comps.addAll(Arrays.asList(filter.getComponents()));
            } else {
                comps.add(filter);
            }
        }
        return Filter.createANDFilter(comps);
    }
}

