/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_NOT_THREADSAFE)
public final class WakeableSleeper
implements Serializable {
    private static final long serialVersionUID = 755656862953269760L;
    @NotNull
    private final AtomicBoolean sleeping = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean shutDown = new AtomicBoolean(false);
    @NotNull
    private final AtomicLong wakeupCount = new AtomicLong(0L);

    public boolean isShutDown() {
        return this.shutDown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
    public boolean sleep(long time) {
        AtomicLong atomicLong = this.wakeupCount;
        synchronized (atomicLong) {
            boolean bl;
            if (this.isShutDown()) {
                return false;
            }
            Validator.ensureTrue(this.sleeping.compareAndSet(false, true), "WakeableSleeper.sleep() must not be invoked concurrently by multiple threads against the same instance.");
            try {
                long beforeCount = this.wakeupCount.get();
                this.wakeupCount.wait(time);
                long afterCount = this.wakeupCount.get();
                bl = beforeCount == afterCount;
                this.sleeping.set(false);
            }
            catch (InterruptedException ie) {
                boolean bl2;
                try {
                    Debug.debugException(ie);
                    bl2 = false;
                    this.sleeping.set(false);
                }
                catch (Throwable throwable) {
                    this.sleeping.set(false);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    @ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
    public void shutDown() {
        this.shutDown.set(true);
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
    public void wakeup() {
        AtomicLong atomicLong = this.wakeupCount;
        synchronized (atomicLong) {
            this.wakeupCount.incrementAndGet();
            this.wakeupCount.notifyAll();
        }
    }
}

