description: 'Payment Card Industry - Data Security Standard (PCI-DSS) is a set of

    security standards designed to ensure the secure handling of payment card

    data, with the goal of preventing data breaches and protecting sensitive

    financial information.


    This profile ensures Red Hat Enterprise Linux 8 is configured in alignment

    with PCI-DSS v4.0 requirements.'
extends: null
hidden: ''
metadata:
    version: '4.0'
    SMEs:
    - marcusburghardt
    - mab879
    - vojtapolasek
reference: https://docs-prv.pcisecuritystandards.org/PCI%20DSS/Standard/PCI-DSS-v4_0.pdf
selections:
- directory_access_var_log_audit
- audit_rules_login_events_faillock
- account_disable_post_pw_expiration
- auditd_data_retention_space_left
- audit_rules_file_deletion_events_rmdir
- audit_sudo_log_events
- audit_rules_dac_modification_chmod
- sshd_set_idle_timeout
- sshd_use_strong_kex
- file_groupowner_backup_etc_passwd
- file_groupowner_cron_daily
- file_permissions_ungroupowned
- sshd_set_maxstartups
- grub2_audit_argument
- file_groupowner_backup_etc_shadow
- aide_periodic_cron_checking
- package_ypserv_removed
- package_sudo_installed
- dconf_db_up_to_date
- accounts_maximum_age_login_defs
- security_patches_up_to_date
- set_password_hashing_algorithm_libuserconf
- file_owner_etc_passwd
- sshd_do_not_permit_user_env
- sshd_use_approved_macs
- file_permissions_etc_group
- group_unique_id
- file_owner_cron_monthly
- audit_rules_dac_modification_fchownat
- file_groupowner_cron_allow
- service_nftables_disabled
- file_groupowner_cron_d
- rpm_verify_hashes
- accounts_passwords_pam_faillock_deny
- sshd_limit_user_access
- audit_rules_time_stime
- package_aide_installed
- accounts_password_pam_unix_remember
- audit_rules_usergroup_modification_opasswd
- package_tftp_removed
- accounts_root_gid_zero
- sysctl_net_ipv4_ip_forward
- auditd_data_retention_space_left_action
- file_cron_deny_not_exist
- service_rsyncd_disabled
- dconf_gnome_disable_automount_open
- wireless_disable_interfaces
- audit_rules_dac_modification_lchown
- dconf_gnome_screensaver_idle_activation_enabled
- file_permissions_cron_monthly
- audit_rules_session_events
- file_permissions_cron_daily
- sysctl_net_ipv4_conf_default_send_redirects
- file_owner_crontab
- file_permissions_cron_allow
- no_password_auth_for_systemaccounts
- audit_rules_dac_modification_lremovexattr
- file_permissions_backup_etc_shadow
- audit_rules_suid_privilege_function
- file_permissions_grub2_cfg
- selinux_confinement_of_daemons
- package_tftp-server_removed
- file_owner_etc_group
- set_password_hashing_algorithm_logindefs
- sudo_require_reauthentication
- file_owner_backup_etc_passwd
- package_telnet-server_removed
- securetty_root_login_console_only
- bios_enable_execution_restrictions
- file_owner_cron_daily
- service_firewalld_enabled
- use_pam_wheel_group_for_su
- accounts_password_pam_minlen
- chronyd_run_as_chrony_user
- file_group_ownership_var_log_audit
- file_ownership_var_log_audit
- file_permissions_at_allow
- package_dhcp_removed
- auditd_name_format
- kernel_module_usb-storage_disabled
- rsyslog_files_groupownership
- disable_host_auth
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- audit_rules_immutable
- file_permissions_backup_etc_passwd
- audit_rules_time_clock_settime
- accounts_password_warn_age_login_defs
- file_permissions_cron_hourly
- sysctl_kernel_core_pattern
- audit_rules_networkconfig_modification
- rsyslog_files_ownership
- audit_rules_usergroup_modification_passwd
- network_sniffer_disabled
- audit_rules_usergroup_modification_shadow
- file_groupowner_backup_etc_group
- sshd_set_max_sessions
- no_files_unowned_by_user
- file_groupowner_cron_hourly
- file_permissions_etc_issue_net
- file_groupowner_crontab
- configure_crypto_policy
- sudo_add_use_pty
- set_firewalld_default_zone
- sudo_custom_logfile
- grub2_audit_backlog_limit_argument
- grub2_enable_selinux
- accounts_password_pam_pwhistory_remember_password_auth
- file_groupowner_grub2_cfg
- package_ypbind_removed
- file_owner_cron_weekly
- audit_rules_time_adjtimex
- ensure_gpgcheck_globally_activated
- ensure_pam_wheel_group_empty
- network_nmcli_permissions
- package_net-snmp_removed
- sysctl_net_ipv4_conf_all_secure_redirects
- sshd_disable_root_login
- ensure_redhat_gpgkey_installed
- service_avahi-daemon_disabled
- no_shelllogin_for_systemaccounts
- auditd_data_retention_admin_space_left_action
- install_PAE_kernel_on_x86-32
- package_audispd-plugins_installed
- package_chrony_installed
- account_unique_id
- dconf_gnome_screensaver_mode_blank
- audit_rules_dac_modification_fchown
- sshd_disable_empty_passwords
- sysctl_net_ipv4_conf_all_rp_filter
- package_telnet_removed
- file_permissions_var_log_audit
- package_ftp_removed
- no_empty_passwords
- file_permissions_cron_weekly
- file_permissions_user_cfg
- package_firewalld_installed
- package_nftables_installed
- audit_rules_login_events_tallylog
- gid_passwd_group_same
- audit_rules_dac_modification_removexattr
- service_auditd_enabled
- ensure_root_password_configured
- audit_rules_dac_modification_chown
- ensure_gpgcheck_never_disabled
- audit_rules_dac_modification_fremovexattr
- file_owner_grub2_cfg
- file_permissions_cron_d
- accounts_password_set_max_life_existing
- enable_authselect
- group_unique_name
- service_chronyd_or_ntpd_enabled
- selinux_policytype
- file_permissions_sshd_pub_key
- aide_build_database
- file_permissions_etc_shadow
- audit_rules_dac_modification_fsetxattr
- selinux_state
- dconf_gnome_session_idle_user_locks
- audit_rules_time_settimeofday
- audit_rules_time_watch_localtime
- gnome_gdm_disable_guest_login
- file_groupowner_etc_passwd
- audit_rules_dac_modification_fchmod
- file_groupowner_cron_monthly
- account_unique_name
- audit_rules_sysadmin_actions
- sysctl_net_ipv6_conf_default_accept_source_route
- package_logrotate_installed
- sysctl_kernel_randomize_va_space
- no_empty_passwords_etc_shadow
- dconf_gnome_screensaver_lock_delay
- service_rpcbind_disabled
- file_groupowner_etc_group
- sshd_disable_rhosts
- file_permissions_sshd_config
- sshd_disable_tcp_forwarding
- dconf_gnome_screensaver_idle_delay
- dconf_gnome_disable_automount
- package_xinetd_removed
- sysctl_net_ipv4_conf_all_send_redirects
- sysctl_fs_suid_dumpable
- accounts_passwords_pam_faillock_unlock_time
- configure_ssh_crypto_policy
- file_owner_cron_allow
- file_owner_cron_d
- set_ip6tables_default_rule
- sudo_require_authentication
- sshd_set_keepalive
- firewalld_loopback_traffic_trusted
- sshd_use_approved_ciphers
- kernel_module_dccp_disabled
- accounts_set_post_pw_existing
- audit_rules_file_deletion_events_rename
- file_permissions_backup_etc_group
- file_permissions_crontab
- audit_rules_mac_modification
- file_groupowner_at_allow
- firewalld_loopback_traffic_restricted
- file_permissions_etc_passwd
- audit_rules_usergroup_modification_group
- audit_rules_dac_modification_setxattr
- file_owner_etc_shadow
- package_audit_installed
- audit_rules_login_events_lastlog
- no_direct_root_logins
- display_login_attempts
- audit_rules_usergroup_modification_gshadow
- sshd_set_login_grace_time
- audit_rules_media_export
- file_permissions_sshd_private_key
- audit_rules_dac_modification_fchmodat
- sysctl_net_ipv4_tcp_syncookies
- package_libselinux_installed
- kernel_module_sctp_disabled
- accounts_password_all_shadowed
- file_groupowner_etc_issue_net
- rpm_verify_ownership
- accounts_password_pam_pwhistory_remember_system_auth
- accounts_password_pam_dcredit
- file_groupowner_user_cfg
- accounts_no_uid_except_zero
- sysctl_net_ipv4_conf_default_accept_redirects
- accounts_tmout
- accounts_password_set_warn_age_existing
- postfix_network_listening_disabled
- accounts_password_last_change_is_in_past
- coredump_disable_storage
- gnome_gdm_disable_automatic_login
- disable_users_coredumps
- audit_rules_file_deletion_events_unlink
- set_password_hashing_algorithm_systemauth
- dir_perms_world_writable_sticky_bits
- file_at_deny_not_exist
- sshd_set_loglevel_verbose
- coredump_disable_backtraces
- audit_rules_file_deletion_events_renameat
- audit_rules_dac_modification_lsetxattr
- auditd_audispd_syslog_plugin_activated
- sshd_disable_x11_forwarding
- sshd_enable_pam
- file_owner_backup_etc_group
- file_owner_backup_etc_shadow
- file_permissions_unauthorized_world_writable
- configure_firewalld_ports
- accounts_password_pam_lcredit
- file_groupowner_cron_weekly
- file_owner_cron_hourly
- sshd_set_max_auth_tries
- chronyd_specify_remote_server
- file_groupowner_etc_shadow
- file_owner_etc_issue_net
- rsyslog_files_permissions
- audit_rules_file_deletion_events_unlinkat
- file_owner_user_cfg
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- dconf_gnome_screensaver_lock_enabled
- var_multiple_time_servers=generic
- var_auditd_admin_space_left_action=single
- var_auditd_space_left=100MB
- var_auditd_space_left_action=email
- var_auditd_name_format=fqd
- var_accounts_maximum_age_login_defs=90
- var_accounts_password_warn_age_login_defs=7
- var_password_pam_unix_remember=4
- var_password_pam_remember=4
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_dcredit=1
- var_password_pam_lcredit=1
- var_password_pam_minlen=12
- var_accounts_passwords_pam_faillock_deny=10
- var_accounts_passwords_pam_faillock_unlock_time=1800
- var_password_pam_tally2=10
- var_accounts_passwords_pam_tally2_unlock_time=1800
- var_password_hashing_algorithm=SHA512
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=10_seconds
- sshd_idle_timeout_value=15_minutes
- var_sshd_set_keepalive=1
- var_account_disable_post_pw_expiration=90
- var_system_crypto_policy=default_policy
- var_sshd_set_login_grace_time=60
- var_postfix_inet_interfaces=loopback-only
- var_selinux_policy_name=targeted
- var_selinux_state=enforcing
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- pcidss_4
title: PCI-DSS v4.0 Control Baseline for Red Hat Enterprise Linux 8
documentation_complete: true
