import React from 'react';
import PropTypes from 'prop-types';

const UilSnapchatSquare = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M21.97333,6.68079a6.124,6.124,0,0,0-.09876-1.074,4.37223,4.37223,0,0,0-.4057-1.24566,4.32419,4.32419,0,0,0-.83166-1.11036,4.12544,4.12544,0,0,0-1.81574-1.03607,7.36011,7.36011,0,0,0-1.92-.20483L16.89777,2H7.09906l-.00055.00989a10.48784,10.48784,0,0,0-1.10089.04925,5.243,5.243,0,0,0-1.17609.26477A4.26175,4.26175,0,0,0,2.21918,5.17023a7.33786,7.33786,0,0,0-.20484,1.9046L2.00775,16.913v.00086a9.44465,9.44465,0,0,0,.09058,1.33179,4.61631,4.61631,0,0,0,.40924,1.3457,4.30506,4.30506,0,0,0,1.20166,1.45331,3.9027,3.9027,0,0,0,1.20239.65173,6.51637,6.51637,0,0,0,1.97687.29047c.41937.00262.83844.01312,1.258.01135,3.04664-.01282,6.09333.022,9.14008-.0188a7.18977,7.18977,0,0,0,1.19879-.12738,4.06007,4.06007,0,0,0,2.00769-.97668,4.16178,4.16178,0,0,0,1.32642-2.21228,8.06159,8.06159,0,0,0,.17273-1.75019v-.11718C21.99219,16.75024,21.97491,6.81219,21.97333,6.68079ZM19.29724,15.9306c-.12787.29938-.774.54761-1.86792.71656-.10266.01586-.14593.18182-.20508.45349-.02447.11218-.04937.22216-.08343.33777a.20428.20428,0,0,1-.21631.1618h-.01715a1.74575,1.74575,0,0,1-.31122-.03937,4.09738,4.09738,0,0,0-.82037-.08685,3.63726,3.63726,0,0,0-.59162.05,2.836,2.836,0,0,0-1.12286.57354,3.25673,3.25673,0,0,1-1.97064.77674c-.04151,0-.08112-.00147-.11121-.00293-.02392.00207-.04858.00293-.0733.00293a3.25323,3.25323,0,0,1-1.96948-.77619,2.83977,2.83977,0,0,0-1.124-.57422,3.63334,3.63334,0,0,0-.59149-.05,4.04744,4.04744,0,0,0-.82031.09283,1.82073,1.82073,0,0,1-.31116.04462.21421.21421,0,0,1-.2337-.16754c-.03449-.11713-.05921-.23059-.08307-.33991-.05969-.27307-.103-.43976-.2052-.45556C5.474,16.47955,4.82782,16.231,4.69916,15.93a.27773.27773,0,0,1-.02271-.095.17561.17561,0,0,1,.14679-.1831,3.8182,3.8182,0,0,0,2.29535-1.36481,5.145,5.145,0,0,0,.7829-1.217l.004-.00842a.78492.78492,0,0,0,.07483-.65741c-.14093-.33228-.60761-.48035-.91639-.57831-.07678-.02429-.14941-.0473-.20727-.07031-.27374-.1081-.72388-.33655-.66394-.65186a.6107.6107,0,0,1,.59356-.39.42052.42052,0,0,1,.17963.03588,1.79643,1.79643,0,0,0,.74243.196.62144.62144,0,0,0,.42749-.13062q-.01207-.2189-.02636-.43768a7.38812,7.38812,0,0,1,.17663-2.95166A3.83671,3.83671,0,0,1,11.8479,5.12848l.29468-.00275a3.84306,3.84306,0,0,1,3.56824,2.29871,7.39771,7.39771,0,0,1,.17639,2.95422l-.003.04779c-.00861.13562-.01654.264-.02332.38843a.60229.60229,0,0,0,.38782.12976,1.85974,1.85974,0,0,0,.6994-.19482.55227.55227,0,0,1,.22913-.04547.69414.69414,0,0,1,.26092.04992l.00409.00159a.485.485,0,0,1,.36719.39807c.00274.15277-.11084.38117-.66937.60181-.05719.02264-.13019.04577-.20728.07025-.309.09808-.77533.24609-.91626.57818a.78359.78359,0,0,0,.07483.65723l.004.00861a4.52238,4.52238,0,0,0,3.07831,2.58172.17581.17581,0,0,1,.14678.18311A.28042.28042,0,0,1,19.29724,15.9306Z'
  }));
};

UilSnapchatSquare.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilSnapchatSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilSnapchatSquare;