'use strict';

const NodeType = {
  NAME: 'NAME',
  MEMBER: 'MEMBER',
  UNION: 'UNION',
  INTERSECTION: 'INTERSECTION',
  VARIADIC: 'VARIADIC',
  RECORD: 'RECORD',
  RECORD_ENTRY: 'RECORD_ENTRY',
  TUPLE: 'TUPLE',
  GENERIC: 'GENERIC',
  MODULE: 'MODULE',
  OPTIONAL: 'OPTIONAL',
  NULLABLE: 'NULLABLE',
  NOT_NULLABLE: 'NOT_NULLABLE',
  FUNCTION: 'FUNCTION',
  ARROW: 'ARROW',
  NAMED_PARAMETER: 'NAMED_PARAMETER',
  ANY: 'ANY',
  UNKNOWN: 'UNKNOWN',
  INNER_MEMBER: 'INNER_MEMBER',
  INSTANCE_MEMBER: 'INSTANCE_MEMBER',
  STRING_VALUE: 'STRING_VALUE',
  NUMBER_VALUE: 'NUMBER_VALUE',
  EXTERNAL: 'EXTERNAL',
  FILE_PATH: 'FILE_PATH',
  PARENTHESIS: 'PARENTHESIS',
  TYPE_QUERY: 'TYPE_QUERY',
  KEY_QUERY: 'KEY_QUERY',
  IMPORT: 'IMPORT',
};

/** @typedef {keyof typeof NodeType} Type */

module.exports = /** @type {{readonly [T in Type]: T}} */ (NodeType);
