/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.nss;

import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLSignatureScheme;
import org.mozilla.jss.ssl.SSLVersion;

public class SSLPreliminaryChannelInfo {
    private long valuesSet;
    private SSLVersion protocolVersion;
    private SSLCipher cipherSuite;
    private boolean canSendEarlyData;
    private long maxEarlyDataSize;
    private boolean haveNSS343;
    private SSLCipher zeroRttCipherSuite;
    private boolean haveNSS348;
    private boolean peerDelegCred;
    private int authKeyBits;
    private SSLSignatureScheme signatureScheme;

    public SSLPreliminaryChannelInfo(long valuesSet, int protocolVersion, int cipherSuite, boolean canSendEarlyData, long maxEarlyDataSize, boolean haveNSS343, int zeroRttCipherSuite, boolean haveNSS348, boolean peerDelegCred, int authKeyBits, int signatureScheme) {
        this.valuesSet = valuesSet;
        if (this.haveProtocolVersion()) {
            try {
                this.protocolVersion = SSLVersion.valueOf(protocolVersion);
            }
            catch (IllegalArgumentException iae) {
                this.protocolVersion = null;
            }
        }
        if (this.haveCipherSuite()) {
            this.cipherSuite = SSLCipher.valueOf(cipherSuite);
        }
        this.canSendEarlyData = canSendEarlyData;
        this.maxEarlyDataSize = maxEarlyDataSize;
        this.haveNSS343 = haveNSS343;
        if (this.haveZeroRttCipherSuite()) {
            this.zeroRttCipherSuite = SSLCipher.valueOf(zeroRttCipherSuite);
        }
        this.haveNSS348 = haveNSS348;
        if (this.havePeerAuth()) {
            this.peerDelegCred = peerDelegCred;
            this.authKeyBits = authKeyBits;
            this.signatureScheme = SSLSignatureScheme.valueOf(signatureScheme);
        }
    }

    private boolean haveField(long mask) {
        return (this.valuesSet & mask) == mask;
    }

    public boolean haveProtocolVersion() {
        long ssl_preinfo_version = 1L;
        return this.haveField(ssl_preinfo_version);
    }

    public boolean haveCipherSuite() {
        long ssl_preinfo_cipher_suite = 2L;
        return this.haveField(ssl_preinfo_cipher_suite);
    }

    public boolean haveZeroRttCipherSuite() {
        long ssl_preinfo_0rtt_cipher_suite = 4L;
        return this.haveField(ssl_preinfo_0rtt_cipher_suite) && this.haveNSS343;
    }

    public boolean havePeerAuth() {
        long ssl_preinfo_peer_auth = 8L;
        return this.haveField(ssl_preinfo_peer_auth) && this.haveNSS348;
    }

    public SSLVersion getProtocolVersion() throws ObjectNotFoundException {
        if (!this.haveProtocolVersion()) {
            Object msg = "The protocolVersion field isn't yet available at ";
            msg = (String)msg + "this point in the TLS handshake; wait for ";
            msg = (String)msg + "haveProtocolVersion(...) to return true before calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.protocolVersion;
    }

    public SSLCipher getCipherSuite() throws ObjectNotFoundException {
        if (!this.haveCipherSuite()) {
            Object msg = "The cipherSuite field isn't yet available at this ";
            msg = (String)msg + "point in the TLS handshake; wait for ";
            msg = (String)msg + "haveCipherSuite(...) to return true before calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.cipherSuite;
    }

    public SSLCipher getZeroRttCipherSuite() throws ObjectNotFoundException {
        if (!this.haveNSS343) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLPreliminaryChannelInfo. Either ";
            msg = (String)msg + "backport this feature or upgrade to at least NSS v3.43. ";
            msg = (String)msg + "Check the value of ";
            msg = (String)msg + "HAVE_NSS_PRELIMINARY_CHANNEL_INFO_ZERO_RTT_CIPHER_SUITE ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        if (!this.haveZeroRttCipherSuite()) {
            Object msg = "The zeroRttCipherSuite field isn't yet available ";
            msg = (String)msg + "at this point in the TLS handshake; wait for ";
            msg = (String)msg + "haveZeroRttCipherSuite(...) to return true before ";
            msg = (String)msg + "calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.zeroRttCipherSuite;
    }

    public boolean getPeerDelegCred() throws ObjectNotFoundException {
        if (!this.haveNSS348) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLPreliminaryChannelInfo. Either ";
            msg = (String)msg + "backport this feature or upgrade to at least NSS v3.48. ";
            msg = (String)msg + "Check the value of ";
            msg = (String)msg + "HAVE_NSS_PRELIMINARY_CHANNEL_INFO_PEER_DELEG_CRED ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        if (!this.havePeerAuth()) {
            Object msg = "The peerDelegCred field isn't yet available at ";
            msg = (String)msg + "this point in the TLS handshake; wait for ";
            msg = (String)msg + "havePeerAuth(...) to return true before calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.peerDelegCred;
    }

    public int getAuthKeyBits() throws ObjectNotFoundException {
        if (!this.haveNSS348) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLPreliminaryChannelInfo. Either ";
            msg = (String)msg + "backport this feature or upgrade to at least NSS v3.48. ";
            msg = (String)msg + "Check the value of ";
            msg = (String)msg + "HAVE_NSS_PRELIMINARY_CHANNEL_INFO_PEER_DELEG_CRED ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        if (!this.havePeerAuth()) {
            Object msg = "The authKeyBits field isn't yet available at ";
            msg = (String)msg + "this point in the TLS handshake; wait for ";
            msg = (String)msg + "havePeerAuth(...) to return true before calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.authKeyBits;
    }

    public SSLSignatureScheme getSignatureScheme() throws ObjectNotFoundException {
        if (!this.haveNSS348) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLPreliminaryChannelInfo. Either ";
            msg = (String)msg + "backport this feature or upgrade to at least NSS v3.48. ";
            msg = (String)msg + "Check the value of ";
            msg = (String)msg + "HAVE_NSS_PRELIMINARY_CHANNEL_INFO_PEER_DELEG_CRED ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        if (!this.havePeerAuth()) {
            Object msg = "The signatureScheme field isn't yet available at ";
            msg = (String)msg + "this point in the TLS handshake; wait for ";
            msg = (String)msg + "havePeerAuth(...) to return true before calling.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.signatureScheme;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SSLPreliminaryChannelInfo:");
        if (this.haveProtocolVersion()) {
            result.append("\n- protocolVersion: " + this.protocolVersion);
        }
        if (this.haveCipherSuite()) {
            result.append("\n- cipherSuite: " + this.cipherSuite);
        }
        result.append("\n- canSendEarlyData: " + this.canSendEarlyData);
        result.append("\n- maxEarlyDataSize: " + this.maxEarlyDataSize);
        if (this.haveZeroRttCipherSuite()) {
            result.append("\n- zeroRttCipherSuite: " + this.zeroRttCipherSuite);
        }
        if (this.havePeerAuth()) {
            result.append("\n- peerDelegCred: " + this.peerDelegCred);
            result.append("\n- authKeyBits: " + this.authKeyBits);
            result.append("\n- signatureScheme: " + this.signatureScheme);
        }
        return result.toString();
    }
}

