/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.mapping;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import org.dogtagpki.server.tps.mapping.BaseMappingResolver;
import org.dogtagpki.server.tps.mapping.FilterMappingParams;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMappingResolver
extends BaseMappingResolver {
    public static Logger logger = LoggerFactory.getLogger(FilterMappingResolver.class);

    @Override
    public String getResolvedMapping(FilterMappingParams mappingParams) throws TPSException {
        return this.getResolvedMapping(mappingParams, "tokenType");
    }

    @Override
    public String getResolvedMapping(FilterMappingParams mappingParams, String nameToMap) throws TPSException {
        String method = "FilterMappingResolver.getResolvedMapping for " + nameToMap + ": ";
        String tokenType = null;
        String keySet = null;
        String mappingOrder = null;
        int major_version = 0;
        int minor_version = 0;
        String cuid = null;
        String extTokenType = null;
        String extTokenATR = null;
        String extKeySet = null;
        String targetMappedName = null;
        String selectedMappedName = null;
        logger.debug(method + " starts");
        major_version = mappingParams.getInt("fp_major_version");
        logger.debug(method + " param major_version: " + major_version);
        minor_version = mappingParams.getInt("fp_minor_version");
        logger.debug(method + " param minor_version: " + minor_version);
        cuid = mappingParams.getString("fp_cuid");
        logger.debug(method + " param cuid: " + cuid);
        extTokenType = mappingParams.getString("fp_ext_tokenType", null);
        logger.debug(method + " param tokenType extension: " + extTokenType);
        extTokenATR = mappingParams.getString("fp_ext_tokenATR", null);
        logger.debug(method + " param tokenATR extension: " + extTokenATR);
        extKeySet = mappingParams.getString("fp_ext_keySet", null);
        logger.debug(method + " param keySet extension: " + extKeySet);
        String configName = this.prefix + ".mapping.order";
        try {
            logger.debug(method + " getting mapping order:" + configName);
            mappingOrder = this.configStore.getString(configName);
        }
        catch (EPropertyNotFound e) {
            logger.error(method + " exception:" + e.getMessage(), (Throwable)e);
            throw new TPSException(method + " configuration incorrect! Mising mapping order:" + configName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
        }
        catch (EBaseException e1) {
            logger.error(method + " exception:" + e1.getMessage(), (Throwable)e1);
            throw new TPSException(method + " Internal error obtaining config value:" + configName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
        }
        for (String mappingId : mappingOrder.split(",")) {
            int minor;
            int major;
            logger.debug(method + "  mapping: " + mappingId);
            String mappingConfigName = this.prefix + ".mapping." + mappingId + ".target." + nameToMap;
            logger.debug(method + "  mappingConfigName: " + mappingConfigName);
            try {
                targetMappedName = this.configStore.getString(mappingConfigName);
            }
            catch (EPropertyNotFound e) {
                throw new TPSException(method + " Mapping Resolver configuration incorrect! No target name config value found! Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + "  targetMappedName: " + targetMappedName);
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.tokenType";
            logger.debug(method + "  mappingConfigName: " + mappingConfigName);
            try {
                tokenType = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " tokenType: " + tokenType);
            if (tokenType != null && tokenType.length() > 0 && (extTokenType == null || !extTokenType.equals(tokenType))) continue;
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.keySet";
            logger.debug(method + " mappingConfigName: " + mappingConfigName);
            try {
                keySet = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " keySet: " + keySet);
            if (keySet != null && keySet.length() > 0 && (extKeySet == null || !extKeySet.equals(keySet))) continue;
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.tokenATR";
            logger.debug(method + " mappingConfigName: " + mappingConfigName);
            String tokenATR = null;
            try {
                tokenATR = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " tokenATR: " + tokenATR);
            if (tokenATR != null && tokenATR.length() > 0 && (extTokenATR == null || !extTokenATR.equals(tokenATR))) continue;
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.tokenCUID.start";
            logger.debug(method + " mappingConfigName: " + mappingConfigName);
            String tokenCUIDStart = null;
            try {
                tokenCUIDStart = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " tokenCUIDStart: " + tokenCUIDStart);
            if (tokenCUIDStart != null && tokenCUIDStart.length() > 0) {
                if (cuid == null || tokenCUIDStart.length() != 20) continue;
                if (cuid.compareToIgnoreCase(tokenCUIDStart) < 0) {
                    logger.debug(method + " cuid < tokenCUIDStart ... out of range");
                    continue;
                }
            }
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.tokenCUID.end";
            logger.debug(method + " mappingConfigName: " + mappingConfigName);
            String tokenCUIDEnd = null;
            try {
                tokenCUIDEnd = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " tokenCUIDEnd: " + tokenCUIDEnd);
            if (tokenCUIDEnd != null && tokenCUIDEnd.length() > 0) {
                if (cuid == null || tokenCUIDEnd.length() != 20) continue;
                if (cuid.compareToIgnoreCase(tokenCUIDEnd) > 0) {
                    logger.debug(method + " cuid > tokenCUIDEnd ... out of range");
                    continue;
                }
            }
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.appletMajorVersion";
            logger.debug(method + " mappingConfigName: " + mappingConfigName);
            String majorVersion = null;
            String minorVersion = null;
            try {
                majorVersion = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " majorVersion: " + majorVersion);
            if (majorVersion != null && majorVersion.length() > 0 && (major = Integer.parseInt(majorVersion)) != major_version) continue;
            mappingConfigName = this.prefix + ".mapping." + mappingId + ".filter.appletMinorVersion";
            logger.debug(method + "  mappingConfigName: " + mappingConfigName);
            try {
                minorVersion = this.configStore.getString(mappingConfigName, null);
            }
            catch (EBaseException e) {
                throw new TPSException(method + " Internal error obtaining config value. Config: " + mappingConfigName, EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
            }
            logger.debug(method + " minorVersion " + minorVersion);
            if (minorVersion != null && minorVersion.length() > 0 && (minor = Integer.parseInt(minorVersion)) != minor_version) continue;
            selectedMappedName = targetMappedName;
            logger.debug(method + " Selected mapped name: " + selectedMappedName);
            break;
        }
        if (selectedMappedName == null) {
            logger.error(method + " ends, found: " + selectedMappedName);
            throw new TPSException(method + " Can't map to target name!", EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
        }
        return selectedMappedName;
    }
}

