/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertDataInfo;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.ca.CACertExportCLI;
import com.netscape.cmstools.ca.CACertFindCLI;
import com.netscape.cmstools.ca.CACertHoldCLI;
import com.netscape.cmstools.ca.CACertReleaseHoldCLI;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.ca.CACertRevokeCLI;
import com.netscape.cmstools.ca.CACertShowCLI;
import com.netscape.cmstools.ca.CACertSigningExportCLI;
import com.netscape.cmstools.ca.CACertSigningShowCLI;
import com.netscape.cmstools.ca.CACertStatusCLI;
import com.netscape.cmstools.ca.CACertSubsystemExportCLI;
import com.netscape.cmstools.ca.CACertSubsystemShowCLI;
import com.netscape.cmstools.ca.CACertTransportExportCLI;
import com.netscape.cmstools.ca.CACertTransportShowCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(CACertCLI.class);
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public CACertClient certClient;

    public CACertCLI(CLI parent) {
        super("cert", "Certificate management commands", parent);
        this.addModule((CLI)new CACertFindCLI(this));
        this.addModule((CLI)new CACertShowCLI(this));
        this.addModule((CLI)new CACertExportCLI(this));
        this.addModule((CLI)new CACertRevokeCLI(this));
        this.addModule((CLI)new CACertHoldCLI(this));
        this.addModule((CLI)new CACertReleaseHoldCLI(this));
        this.addModule((CLI)new CACertStatusCLI(this));
        this.addModule(new CACertRequestCLI(this));
        this.addModule((CLI)new CACertSigningShowCLI(this));
        this.addModule((CLI)new CACertSigningExportCLI(this));
        this.addModule((CLI)new CACertSubsystemShowCLI(this));
        this.addModule((CLI)new CACertSubsystemExportCLI(this));
        this.addModule((CLI)new CACertTransportShowCLI(this));
        this.addModule((CLI)new CACertTransportExportCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-cert";
    }

    public CACertClient getCertClient() throws Exception {
        String subsystem;
        if (this.certClient != null) {
            return this.certClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = "ca";
        }
        this.certClient = new CACertClient(client, subsystem);
        return this.certClient;
    }

    public static String getAlgorithmNameFromOID(String oid) {
        if (oid == null) {
            return "";
        }
        if (oid.equals("1.2.840.113549.1.1.1")) {
            return "PKCS #1 RSA";
        }
        if (oid.equals("1.2.840.113549.1.1.4")) {
            return "PKCS #1 MD5 With RSA";
        }
        if (oid.equals("1.2.840.10040.4.1")) {
            return "DSA";
        }
        return "OID." + oid;
    }

    public static void printCertInfo(CertDataInfo info) {
        String revokedBy;
        System.out.println("  Serial Number: " + info.getID().toHexString());
        System.out.println("  Subject DN: " + info.getSubjectDN());
        System.out.println("  Issuer DN: " + info.getIssuerDN());
        System.out.println("  Status: " + info.getStatus());
        Object type = info.getType();
        Integer version = info.getVersion();
        if (version != null) {
            type = (String)type + " version " + (version + 1);
        }
        System.out.println("  Type: " + (String)type);
        Object keyAlgorithm = CACertCLI.getAlgorithmNameFromOID(info.getKeyAlgorithmOID());
        Integer keyLength = info.getKeyLength();
        if (keyLength != null) {
            keyAlgorithm = (String)keyAlgorithm + " with " + keyLength + "-bit key";
        }
        System.out.println("  Key Algorithm: " + (String)keyAlgorithm);
        System.out.println("  Not Valid Before: " + info.getNotValidBefore());
        System.out.println("  Not Valid After: " + info.getNotValidAfter());
        System.out.println("  Issued On: " + info.getIssuedOn());
        System.out.println("  Issued By: " + info.getIssuedBy());
        Date revokedOn = info.getRevokedOn();
        if (revokedOn != null) {
            System.out.println("  Revoked On: " + revokedOn);
        }
        if ((revokedBy = info.getRevokedBy()) != null) {
            System.out.println("  Revoked By: " + revokedBy);
        }
    }

    public static void printCertData(CertData certData, boolean showPrettyPrint, boolean showEncoded) {
        String revokedBy;
        System.out.println("  Serial Number: " + certData.getSerialNumber().toHexString());
        System.out.println("  Subject DN: " + certData.getSubjectDN());
        System.out.println("  Issuer DN: " + certData.getIssuerDN());
        System.out.println("  Status: " + certData.getStatus());
        System.out.println("  Not Valid Before: " + certData.getNotBefore());
        System.out.println("  Not Valid After: " + certData.getNotAfter());
        Date revokedOn = certData.getRevokedOn();
        if (revokedOn != null) {
            System.out.println("  Revoked On: " + revokedOn);
        }
        if ((revokedBy = certData.getRevokedBy()) != null) {
            System.out.println("  Revoked By: " + revokedBy);
        }
        String prettyPrint = certData.getPrettyPrint();
        if (showPrettyPrint && prettyPrint != null) {
            System.out.println();
            System.out.println(prettyPrint);
        }
        String encoded = certData.getEncoded();
        if (showEncoded && encoded != null) {
            System.out.println();
            System.out.print(encoded);
        }
    }
}

