/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.util.Arrays;
import java.util.Objects;
import org.mozilla.jss.netscape.security.util.Utils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Key
implements JSONSerializer {
    private byte[] encryptedData;
    private byte[] nonceData;
    private String p12Data;
    private String algorithm;
    private Integer size;
    private byte[] data;
    private RequestId requestId;
    private String wrapAlgorithm;
    private String encryptAlgorithmOID;
    private String type;
    private String publicKey;

    public Key() {
    }

    public Key(KeyData data) {
        if (data.getWrappedPrivateData() != null) {
            this.encryptedData = Utils.base64decode((String)data.getWrappedPrivateData());
        }
        if (data.getNonceData() != null) {
            this.nonceData = Utils.base64decode((String)data.getNonceData());
        }
        this.p12Data = data.getP12Data();
        this.algorithm = data.getAlgorithm();
        this.size = data.getSize();
        this.requestId = data.requestID;
        this.wrapAlgorithm = data.getWrapAlgorithm();
        this.encryptAlgorithmOID = data.getEncryptAlgorithmOID();
        this.type = data.getType();
        this.publicKey = data.getPublicKey();
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    public byte[] getNonceData() {
        return this.nonceData;
    }

    public void setNonceData(byte[] nonceData) {
        this.nonceData = nonceData;
    }

    public String getP12Data() {
        return this.p12Data;
    }

    public void setP12Data(String p12Data) {
        this.p12Data = p12Data;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public void setRequestId(RequestId requestId) {
        this.requestId = requestId;
    }

    public String getWrapAlgorithm() {
        return this.wrapAlgorithm;
    }

    public void setWrapAlgorithm(String wrapAlgorithm) {
        this.wrapAlgorithm = wrapAlgorithm;
    }

    public String getEncryptAlgorithmOID() {
        return this.encryptAlgorithmOID;
    }

    public void setEncryptAlgorithmOID(String encryptAlgorithmOID) {
        this.encryptAlgorithmOID = encryptAlgorithmOID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void clearSensitiveData() {
        CryptoUtil.obscureBytes(this.data, "random");
        this.data = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + Arrays.hashCode(this.encryptedData);
        result = 31 * result + Arrays.hashCode(this.nonceData);
        result = 31 * result + Objects.hash(this.algorithm, this.encryptAlgorithmOID, this.p12Data, this.publicKey, this.requestId, this.size, this.type, this.wrapAlgorithm);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        return Objects.equals(this.algorithm, other.algorithm) && Arrays.equals(this.data, other.data) && Objects.equals(this.encryptAlgorithmOID, other.encryptAlgorithmOID) && Arrays.equals(this.encryptedData, other.encryptedData) && Arrays.equals(this.nonceData, other.nonceData) && Objects.equals(this.p12Data, other.p12Data) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals(this.requestId, other.requestId) && Objects.equals(this.size, other.size) && Objects.equals(this.type, other.type) && Objects.equals(this.wrapAlgorithm, other.wrapAlgorithm);
    }
}

