/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.jobs.EJobsException;
import com.netscape.certsrv.jobs.JobPlugin;
import com.netscape.cms.jobs.Job;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.jobs.JobConfig;
import com.netscape.cmscore.jobs.JobPluginsConfig;
import com.netscape.cmscore.jobs.JobsConfig;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.jobs.JobsSchedulerConfig;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(JobsAdminServlet.class);
    private static final long serialVersionUID = 561767449283982015L;
    private static final String VISIBLE = ";visible";
    private static final String ENABLED = ";enabled";
    private static final String DISABLED = ";disabled";
    private static final String INFO = "JobsAdminServlet";
    private JobsScheduler mJobsSched;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CMSEngine engine = this.getCMSEngine();
        this.mJobsSched = (JobsScheduler)engine.getSubsystem("jobsScheduler");
    }

    public String getServletInfo() {
        return INFO;
    }

    private void getExtendedPluginInfo(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        int colon = id.indexOf(58);
        String implName = id.substring(colon + 1);
        NameValuePairs params = this.getExtendedPluginInfo(implName);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private NameValuePairs getExtendedPluginInfo(String implName) {
        IExtendedPluginInfo ext_info = null;
        IExtendedPluginInfo impl = null;
        JobPlugin jp = this.mJobsSched.getPlugins().get(implName);
        if (jp != null) {
            impl = JobsAdminServlet.getClassByNameAsExtendedPluginInfo(jp.getClassPath());
        }
        if (impl != null && impl instanceof IExtendedPluginInfo) {
            ext_info = impl;
        }
        NameValuePairs nvps = null;
        nvps = ext_info == null ? new NameValuePairs() : this.convertStringArrayToNVPairs(ext_info.getExtendedPluginInfo());
        return nvps;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block29: {
            super.service(req, resp);
            String scope = req.getParameter("OP_SCOPE");
            String op = req.getParameter("OP_TYPE");
            if (op == null) {
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_PROTOCOL", new String[0]), null, resp);
                return;
            }
            try {
                super.authenticate(req);
            }
            catch (IOException e) {
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHS_FAILED", new String[0]), null, resp);
                return;
            }
            try {
                AUTHZ_RES_NAME = "certServer.job.configuration";
                if (op.equals("OP_READ")) {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("jobScheduler")) {
                        this.getSettings(req, resp);
                        break block29;
                    }
                    if (scope.equals("impl")) {
                        this.getConfig(req, resp);
                        break block29;
                    }
                    if (scope.equals("job")) {
                        this.getInstConfig(req, resp);
                        break block29;
                    }
                    if (scope.equals("extendedPluginInfo")) {
                        try {
                            this.getExtendedPluginInfo(req, resp);
                            break block29;
                        }
                        catch (EBaseException e) {
                            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                            return;
                        }
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_MODIFY")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("jobScheduler")) {
                        this.setSettings(req, resp);
                        break block29;
                    }
                    if (scope.equals("job")) {
                        this.modJobsInst(req, resp, scope);
                        break block29;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_SEARCH")) {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.listJobPlugins(req, resp);
                        break block29;
                    }
                    if (scope.equals("job")) {
                        this.listJobsInsts(req, resp);
                        break block29;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_ADD")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.addJobPlugin(req, resp, scope);
                        break block29;
                    }
                    if (scope.equals("job")) {
                        this.addJobsInst(req, resp, scope);
                        break block29;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                if (op.equals("OP_DELETE")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.delJobPlugin(req, resp, scope);
                        break block29;
                    }
                    if (scope.equals("job")) {
                        this.delJobsInst(req, resp, scope);
                        break block29;
                    }
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                    return;
                }
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_TYPE", op), null, resp);
                return;
            }
            catch (EBaseException e) {
                this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
            }
        }
    }

    private synchronized void addJobPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        if (this.mJobsSched.getPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ILL_JOB_PLUGIN_ID", id)).toString(), null, resp);
            return;
        }
        String classPath = req.getParameter("class");
        if (classPath == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_NULL_CLASS", new String[0]), null, resp);
            return;
        }
        JobsSchedulerConfig destStore = this.mConfig.getJobsSchedulerConfig();
        JobPluginsConfig instancesConfig = destStore.getJobPluginsConfig();
        Class<?> newImpl = null;
        try {
            newImpl = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_NO_CLASS", new String[0]), null, resp);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_NO_CLASS", new String[0]), null, resp);
            return;
        }
        try {
            if (!Job.class.isAssignableFrom(newImpl)) {
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ILL_CLASS", new String[0]), null, resp);
                return;
            }
        }
        catch (NullPointerException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ILL_CLASS", new String[0]), null, resp);
            return;
        }
        ConfigStore substore = instancesConfig.makeSubStore(id);
        substore.put("class", classPath);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
            return;
        }
        JobPlugin plugin = new JobPlugin(id, classPath);
        this.mJobsSched.getPlugins().put(id, plugin);
        logger.info(CMS.getLogMessage("ADMIN_SRVLT_JS_PLUGIN_ADD", id));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addJobsInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        CMSEngine engine = this.getCMSEngine();
        if (this.mJobsSched.getInstances().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ILL_JOB_INST_ID", new String[0]), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ADD_MISSING_PARAMS", new String[0]), null, resp);
            return;
        }
        JobPlugin plugin = this.mJobsSched.getPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_PLUGIN_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        String[] configParams = this.mJobsSched.getConfigParams(implname);
        JobsSchedulerConfig destStore = this.mConfig.getJobsSchedulerConfig();
        JobsConfig instancesConfig = destStore.getJobsConfig();
        JobConfig substore = instancesConfig.createJobConfig(id);
        if (configParams != null) {
            for (int i = 0; i < configParams.length; ++i) {
                String key = configParams[i];
                String val = req.getParameter(key);
                if (val != null && !val.equals("")) {
                    substore.put(key, val);
                    continue;
                }
                if (key.equals("profileId")) continue;
                this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_MISSING_INST_PARAM_VAL", key)).toString(), null, resp);
                return;
            }
        }
        substore.setPluginName(implname);
        String className = plugin.getClassPath();
        Job jobsInst = null;
        try {
            jobsInst = (Job)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            instancesConfig.removeJobConfig(id);
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_LOAD_CLASS_FAILED", className)).toString(), null, resp);
            return;
        }
        JobsScheduler scheduler = engine.getJobsScheduler();
        try {
            jobsInst.setCMSEngine(engine);
            jobsInst.init(scheduler, id, implname, substore);
        }
        catch (EBaseException e) {
            instancesConfig.removeJobConfig(id);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            instancesConfig.removeJobConfig(id);
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
            return;
        }
        this.mJobsSched.getInstances().put(id, jobsInst);
        logger.info(CMS.getLogMessage("ADMIN_SRVLT_JOB_INST_ADD", id));
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)implname);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listJobPlugins(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mJobsSched.getPlugins().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            JobPlugin value = this.mJobsSched.getPlugins().get(name);
            params.put((Object)name, (Object)value.getClassPath());
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void listJobsInsts(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<String> e = this.mJobsSched.getInstances().keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Job value = this.mJobsSched.getInstances().get(name);
            params.put((Object)name, (Object)(value.getImplName() + VISIBLE + (value.isEnabled() ? ENABLED : DISABLED)));
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delJobPlugin(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        if (!this.mJobsSched.getPlugins().containsKey(id)) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_PLUGIN_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        Enumeration<Job> e = this.mJobsSched.getInstances().elements();
        while (e.hasMoreElements()) {
            Job jobs = e.nextElement();
            if (!jobs.getImplName().equals(id)) continue;
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_IN_USE", new String[0]), null, resp);
            return;
        }
        this.mJobsSched.getPlugins().remove(id);
        JobsSchedulerConfig destStore = this.mConfig.getJobsSchedulerConfig();
        JobPluginsConfig instancesConfig = destStore.getJobPluginsConfig();
        instancesConfig.removeSubStore(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e2) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void delJobsInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        if (!this.mJobsSched.getInstances().containsKey(id)) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        this.mJobsSched.getInstances().remove(id);
        JobsSchedulerConfig destStore = this.mConfig.getJobsSchedulerConfig();
        JobsConfig instancesConfig = destStore.getJobsConfig();
        instancesConfig.removeJobConfig(id);
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
            return;
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void getConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String implname = req.getParameter("RS_ID");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        String[] configParams = this.mJobsSched.getConfigParams(implname);
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)"");
        if (configParams != null) {
            for (int i = 0; i < configParams.length; ++i) {
                params.put((Object)configParams[i], (Object)"");
            }
        }
        this.sendResponse(0, null, params, resp);
    }

    private synchronized void getInstConfig(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        if (!this.mJobsSched.getInstances().containsKey(id)) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        Job jobInst = this.mJobsSched.getInstances().get(id);
        JobConfig config = jobInst.getConfigStore();
        String[] configParams = jobInst.getConfigParams();
        NameValuePairs params = new NameValuePairs();
        params.put((Object)"implName", (Object)jobInst.getImplName());
        if (configParams != null) {
            for (int i = 0; i < configParams.length; ++i) {
                String key = configParams[i];
                String val = config.get(key);
                if (val != null && !val.equals("")) {
                    params.put((Object)key, (Object)val);
                    continue;
                }
                params.put((Object)key, (Object)"");
            }
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void modJobsInst(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        String id = req.getParameter("RS_ID");
        if (id == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        CMSEngine engine = this.getCMSEngine();
        if (!this.mJobsSched.getInstances().containsKey(id)) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ILL_JOB_INST_ID", new String[0]), null, resp);
            return;
        }
        String implname = req.getParameter("implName");
        if (implname == null) {
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_ADD_MISSING_PARAMS", new String[0]), null, resp);
            return;
        }
        JobPlugin plugin = this.mJobsSched.getPlugins().get(implname);
        if (plugin == null) {
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_JOB_PLUGIN_NOT_FOUND", id)).toString(), null, resp);
            return;
        }
        Job oldinst = this.mJobsSched.getInstances().get(id);
        JobConfig oldConfig = oldinst.getConfigStore();
        String[] oldConfigParms = oldinst.getConfigParams();
        NameValuePairs saveParams = new NameValuePairs();
        saveParams.put((Object)"pluginName", (Object)oldConfig.getPluginName());
        if (oldConfigParms != null) {
            for (int i = 0; i < oldConfigParms.length; ++i) {
                String key = oldConfigParms[i];
                String val = oldConfig.get(key);
                if (val == null) continue;
                saveParams.put((Object)key, (Object)val);
            }
        }
        JobsSchedulerConfig destStore = this.mConfig.getJobsSchedulerConfig();
        JobsConfig instancesConfig = destStore.getJobsConfig();
        instancesConfig.removeJobConfig(id);
        String[] configParams = this.mJobsSched.getConfigParams(implname);
        JobConfig substore = instancesConfig.createJobConfig(id);
        substore.setPluginName(implname);
        if (configParams != null) {
            for (int i = 0; i < configParams.length; ++i) {
                String key = configParams[i];
                String val = req.getParameter(key);
                if (val != null && !val.equals("")) {
                    substore.put(key, val);
                    continue;
                }
                if (key.equals("profileId")) continue;
                JobsAdminServlet.restore(instancesConfig, id, saveParams);
                this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_SRVLT_MISSING_INST_PARAM_VAL", key)).toString(), null, resp);
                return;
            }
        }
        String className = plugin.getClassPath();
        Job newJobInst = null;
        try {
            newJobInst = (Job)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            JobsAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, new EJobsException(CMS.getUserMessage(this.getLocale(req), "CMS_JOB_LOAD_CLASS_FAILED", className)).toString(), null, resp);
            return;
        }
        JobsScheduler scheduler = (JobsScheduler)engine.getSubsystem("jobsScheduler");
        try {
            newJobInst.setCMSEngine(engine);
            newJobInst.init(scheduler, id, implname, substore);
        }
        catch (EBaseException e) {
            JobsAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
            return;
        }
        catch (Exception e) {
            logger.warn("JobsAdminServlet: modJobsInst: " + e.getMessage(), (Throwable)e);
            JobsAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, "unidentified error" + e, null, resp);
            return;
        }
        try {
            this.mConfig.commit(true);
        }
        catch (EBaseException e) {
            JobsAdminServlet.restore(instancesConfig, id, saveParams);
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_COMMIT_FAILED", new String[0]), null, resp);
            return;
        }
        this.mJobsSched.getInstances().put(id, newJobInst);
        logger.info(CMS.getLogMessage("ADMIN_SRVLT_JOB_INST_REP", id));
        NameValuePairs params = new NameValuePairs();
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getSettings(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        JobsSchedulerConfig config = this.mConfig.getJobsSchedulerConfig();
        params.put((Object)"enable", (Object)config.getString("enabled", "false"));
        params.put((Object)"frequency", (Object)config.getString("interval", "1"));
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void setSettings(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        String interval;
        JobsSchedulerConfig config = this.mConfig.getJobsSchedulerConfig();
        String enabled = config.getString("enabled");
        String enabledSetTo = req.getParameter("enable");
        boolean enabledChanged = false;
        if (!enabled.equalsIgnoreCase(enabledSetTo)) {
            enabledChanged = true;
            config.putString("enabled", enabledSetTo);
        }
        if ((interval = req.getParameter("frequency")) != null) {
            config.putString("interval", interval);
            this.mJobsSched.setInterval(config.getInteger("interval"));
        }
        if (enabledChanged && enabled.equalsIgnoreCase("false")) {
            this.mJobsSched.startDaemon();
        }
        this.mConfig.commit(true);
        this.sendResponse(SUCCESS, null, null, resp);
    }

    private static void restore(JobsConfig store, String id, NameValuePairs saveParams) {
        store.removeJobConfig(id);
        JobConfig rstore = store.createJobConfig(id);
        for (String key : saveParams.keySet()) {
            String value = (String)saveParams.get((Object)key);
            if (value.equals("")) continue;
            rstore.put(key, value);
        }
    }
}

