/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationInfoMapper
extends DBAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(RevocationInfoMapper.class);
    protected static Vector<String> mNames = new Vector();

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return mNames.elements();
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        try {
            StringBuffer value = new StringBuffer();
            RevocationInfo info = (RevocationInfo)obj;
            Date d = info.getRevocationDate();
            value.append(DateMapper.dateToDB(d));
            CRLExtensions exts = info.getCRLEntryExtensions();
            Enumeration e = exts.getElements();
            while (e.hasMoreElements()) {
                Extension ext = (Extension)e.nextElement();
                if (ext instanceof CRLReasonExtension) {
                    RevocationReason reason = ((CRLReasonExtension)ext).getReason();
                    value.append(";CRLReasonExtension=" + Integer.toString(reason.getCode()));
                    continue;
                }
                if (ext instanceof InvalidityDateExtension) {
                    Date invalidityDate = ((InvalidityDateExtension)ext).getInvalidityDate();
                    value.append(";InvalidityDateExtension=" + DateMapper.dateToDB(invalidityDate));
                    continue;
                }
                logger.trace("XXX skipped extension");
            }
            logger.debug("RevocationInfoMapper: Mapping " + name + " to revInfo");
            attrs.add(new LDAPAttribute("revInfo", value.toString()));
        }
        catch (Exception e) {
            logger.error("RevocationInfoMapper: " + e.getMessage(), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        try {
            LDAPAttribute attr = attrs.getAttribute("revInfo");
            if (attr == null) {
                return;
            }
            String value = (String)attr.getStringValues().nextElement();
            int i = value.indexOf(59);
            String str = null;
            CRLExtensions exts = new CRLExtensions();
            Date d = null;
            if (i == -1) {
                d = DateMapper.dateFromDB(value);
            } else {
                String s = value;
                str = s.substring(0, i);
                d = DateMapper.dateFromDB(str);
                s = s.substring(i + 1);
                do {
                    CRLReasonExtension ext;
                    if ((i = s.indexOf(59)) == -1) {
                        str = s;
                    } else {
                        str = s.substring(0, i);
                        s = s.substring(i + 1);
                    }
                    if (str.startsWith("CRLReasonExtension=")) {
                        String reasonStr = str.substring(19);
                        RevocationReason reason = RevocationReason.valueOf((int)Integer.parseInt(reasonStr));
                        ext = new CRLReasonExtension(reason);
                        exts.set("CRLReason", (Extension)ext);
                        continue;
                    }
                    if (str.startsWith("InvalidityDateExtension=")) {
                        String invalidityDateStr = str.substring(24);
                        Date invalidityDate = DateMapper.dateFromDB(invalidityDateStr);
                        ext = new InvalidityDateExtension(invalidityDate);
                        exts.set("InvalidityDate", (Extension)ext);
                        continue;
                    }
                    logger.trace("XXX skipped extension");
                } while (i != -1);
            }
            RevocationInfo info = new RevocationInfo(d, exts);
            parent.set(name, info);
        }
        catch (Exception e) {
            logger.error("RevocationInfoMapper: " + e.getMessage(), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_DESERIALIZE_FAILED", name));
        }
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return "revInfo" + op + value;
    }

    static {
        mNames.addElement("revInfo");
    }
}

