/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="new-nonce")
@ACMEManagedService
public class ACMENewNonceService {
    public static Logger logger = LoggerFactory.getLogger(ACMENewNonceService.class);
    @Context
    UriInfo uriInfo;

    @HEAD
    public Response headNewNonce() throws Exception {
        Response.ResponseBuilder builder = Response.ok();
        this.createNonce(builder);
        return builder.build();
    }

    @GET
    public Response getNewNonce() throws Exception {
        Response.ResponseBuilder builder = Response.noContent();
        this.createNonce(builder);
        return builder.build();
    }

    public void createNonce(Response.ResponseBuilder builder) throws Exception {
        logger.info("Creating nonce");
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        CacheControl cc = new CacheControl();
        cc.setNoStore(true);
        builder.cacheControl(cc);
        URI directoryURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(directoryURL, "index");
    }
}

