/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.profile;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.util.AsyncLoader;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.LDAPConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.TreeSet;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;
import netscape.ldap.util.DN;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPProfileSubsystem
extends ProfileSubsystem
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(LDAPProfileSubsystem.class);
    private String profileContainerDNString;
    private DN profileContainerDN;
    private LdapBoundConnFactory dbFactory;
    private boolean stopped = false;
    private Thread monitor;
    private TreeMap<String, BigInteger> entryUSNs = new TreeMap();
    private TreeMap<String, String> nsUniqueIds = new TreeMap();
    private TreeSet<String> deletedNsUniqueIds = new TreeSet();
    private AsyncLoader loader = new AsyncLoader(10);

    @Override
    public void init(ConfigStore config) throws Exception {
        logger.debug("LDAPProfileSubsystem: start init");
        CAEngine caEngine = (CAEngine)this.engine;
        CAEngineConfig cs = caEngine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        LDAPConfig dbCfg = cs.getInternalDBConfig();
        this.dbFactory = new LdapBoundConnFactory("LDAPProfileSubsystem");
        this.dbFactory.setCMSEngine(this.engine);
        this.dbFactory.init(socketConfig, dbCfg, this.engine.getPasswordStore());
        this.mConfig = config;
        String basedn = dbCfg.getBaseDN();
        this.profileContainerDNString = "ou=certificateProfiles,ou=ca," + basedn;
        this.profileContainerDN = new DN(this.profileContainerDNString);
        this.monitor = new Thread((Runnable)this, "ProfileChangeMonitor");
        this.monitor.start();
        try {
            this.loader.awaitLoadDone();
        }
        catch (InterruptedException e) {
            logger.warn("LDAPProfileSubsystem: caught InterruptedException while waiting for initial load of profiles.");
            logger.warn("You may have replication conflict entries or extraneous data under " + this.profileContainerDNString);
        }
        logger.debug("LDAPProfileSubsystem: finished init");
    }

    @Override
    public Profile getProfile(String id) throws EProfileException {
        try {
            this.loader.awaitLoadDone();
        }
        catch (InterruptedException e) {
            logger.warn("LDAPProfileSubsystem.getProfile: caught InterruptedException while waiting for profiles to be loaded: " + e, (Throwable)e);
        }
        return super.getProfile(id);
    }

    @Override
    public Enumeration<String> getProfileIds() {
        try {
            this.loader.awaitLoadDone();
        }
        catch (InterruptedException e) {
            logger.warn("LDAPProfileSubsystem.getProfile: caught InterruptedException while waiting for profiles to be loaded: " + e, (Throwable)e);
        }
        return super.getProfileIds();
    }

    private synchronized void readProfile(LDAPEntry ldapProfile) {
        CAEngine engine = CAEngine.getInstance();
        PluginRegistry registry = engine.getPluginRegistry();
        String nsUniqueId = ldapProfile.getAttribute("nsUniqueId").getStringValueArray()[0];
        if (this.deletedNsUniqueIds.contains(nsUniqueId)) {
            logger.warn("readProfile: ignoring entry with nsUniqueId '" + nsUniqueId + "' due to deletion");
            return;
        }
        String profileId = null;
        String dn = ldapProfile.getDN();
        if (!dn.startsWith("cn=")) {
            logger.error("Error reading profile entry: DN " + dn + " does not start with 'cn='");
            return;
        }
        profileId = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
        BigInteger newEntryUSN = new BigInteger(ldapProfile.getAttribute("entryUSN").getStringValueArray()[0]);
        logger.debug("readProfile: new entryUSN = " + newEntryUSN);
        BigInteger knownEntryUSN = this.entryUSNs.get(profileId);
        if (knownEntryUSN != null) {
            logger.debug("readProfile: known entryUSN = " + knownEntryUSN);
            if (newEntryUSN.compareTo(knownEntryUSN) <= 0) {
                logger.info("readProfile: data is current");
                return;
            }
        }
        String classId = (String)ldapProfile.getAttribute("classId").getStringValues().nextElement();
        ByteArrayInputStream data = new ByteArrayInputStream(ldapProfile.getAttribute("certProfileConfig").getByteValueArray()[0]);
        PluginInfo info = registry.getPluginInfo("profile", classId);
        if (info == null) {
            logger.error("Error loading profile: No plugins for type : profile, with classId " + classId);
        } else {
            try {
                logger.debug("Start Profile Creation - " + profileId + " " + classId + " " + info.getClassName());
                this.createProfile(profileId, classId, info.getClassName(), data);
                this.entryUSNs.put(profileId, newEntryUSN);
                this.nsUniqueIds.put(profileId, nsUniqueId);
                logger.info("Done Profile Creation - " + profileId);
            }
            catch (EProfileException e) {
                logger.error("Error creating profile '" + profileId + "': " + e, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Profile createProfile(String id, String classid, String className) throws EProfileException {
        return this.createProfile(id, classid, className, null);
    }

    private synchronized Profile createProfile(String id, String classid, String className, InputStream data) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        PluginRegistry registry = engine.getPluginRegistry();
        LDAPConnection conn = null;
        try {
            conn = this.dbFactory.getConn();
            String[] objectClasses = new String[]{"top", "certProfile"};
            LDAPAttribute[] createAttrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", objectClasses), new LDAPAttribute("cn", id), new LDAPAttribute("classId", classid)};
            LDAPConfigStorage storage = new LDAPConfigStorage(conn, this.createProfileDN(id), createAttrs, "certProfileConfig");
            ProfileConfig profileConfig = new ProfileConfig((ConfigStorage)storage);
            if (data != null) {
                profileConfig.load(data);
            }
            logger.debug("LDAPProfileSubsystem: initing " + className);
            Profile profile = (Profile)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            profile.setId(id);
            profile.init(engineConfig, registry, profileConfig);
            this.mProfiles.put(id, profile);
            this.mProfileClassIds.put(id, classid);
            Profile profile2 = profile;
            return profile2;
        }
        catch (Exception e) {
            logger.error("LDAPProfileSubsystem: error creating or reading profile: " + e, (Throwable)e);
            throw new EProfileException("Error creating or reading profile: " + e, (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.dbFactory.returnConn(conn);
            }
        }
    }

    @Override
    public synchronized void deleteProfile(String id) throws EBaseException {
        LDAPConnection conn;
        if (this.isProfileEnable(id)) {
            throw new EProfileException("CMS_PROFILE_DELETE_ENABLEPROFILE");
        }
        try {
            conn = this.dbFactory.getConn();
        }
        catch (ELdapException e) {
            throw new EProfileException("Error acquiring the ldap connection", (Throwable)e);
        }
        try {
            conn.delete(this.createProfileDN(id));
        }
        catch (LDAPException e) {
            throw new EProfileException("CMS_PROFILE_DELETE_ERROR", (Throwable)e);
        }
        finally {
            try {
                this.dbFactory.returnConn(conn);
            }
            catch (Exception e) {
                throw new EProfileException("Error releasing the ldap connection", (Throwable)e);
            }
        }
        this.deletedNsUniqueIds.add(this.nsUniqueIds.get(id));
        this.forgetProfile(id);
    }

    private synchronized void handleDELETE(LDAPEntry entry) {
        LDAPAttribute attr = entry.getAttribute("nsUniqueId");
        String nsUniqueId = null;
        if (attr != null) {
            nsUniqueId = attr.getStringValueArray()[0];
        }
        if (this.deletedNsUniqueIds.remove(nsUniqueId)) {
            logger.debug("handleDELETE: delete was already effected");
            return;
        }
        String profileId = null;
        String dn = entry.getDN();
        if (!dn.startsWith("cn=")) {
            logger.debug("handleDELETE: DN " + dn + " does not start with 'cn='");
            return;
        }
        profileId = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
        this.forgetProfile(profileId);
    }

    private synchronized void handleMODDN(DN oldDN, LDAPEntry entry) {
        if (oldDN.isDescendantOf(this.profileContainerDN)) {
            this.forgetProfile(oldDN.explodeDN(true)[0]);
        }
        if (new DN(entry.getDN()).isDescendantOf(this.profileContainerDN)) {
            this.readProfile(entry);
        }
    }

    @Override
    protected void commitConfigStore(String id, ConfigStore configStore) throws EProfileException {
        ConfigStore propConfigStore = configStore;
        LDAPConfigStorage storage = (LDAPConfigStorage)propConfigStore.getStorage();
        try {
            String[] attrs = new String[]{"entryUSN", "nsUniqueId"};
            LDAPEntry entry = storage.commitReturn(configStore, false, attrs);
            if (entry == null) {
                return;
            }
            BigInteger entryUSN = null;
            LDAPAttribute attr = entry.getAttribute("entryUSN");
            if (attr != null) {
                entryUSN = new BigInteger(attr.getStringValueArray()[0]);
            }
            this.entryUSNs.put(id, entryUSN);
            logger.debug("commitProfile: new entryUSN = " + entryUSN);
            String nsUniqueId = null;
            attr = entry.getAttribute("nsUniqueId");
            if (attr != null) {
                nsUniqueId = attr.getStringValueArray()[0];
            }
            logger.debug("commitProfile: nsUniqueId = " + nsUniqueId);
            this.nsUniqueIds.put(id, nsUniqueId);
        }
        catch (EBaseException e) {
            logger.error("commitProfile: Failed to commit config store of profile '" + id + ": " + e, (Throwable)e);
            throw new EProfileException("Failed to commit config store of profile '" + id + ": " + e, (Throwable)e);
        }
    }

    private void forgetProfile(String id) {
        this.mProfiles.remove(id);
        this.mProfileClassIds.remove(id);
        this.entryUSNs.remove(id);
        this.nsUniqueIds.remove(id);
    }

    @Override
    public void startup() throws EBaseException {
        logger.info("LDAPProfileSubsystem: startup");
    }

    @Override
    public void shutdown() {
        this.stopped = true;
        this.monitor = null;
        this.forgetAllProfiles();
    }

    private void forgetAllProfiles() {
        this.mProfiles.clear();
        this.mProfileClassIds.clear();
        this.entryUSNs.clear();
        this.nsUniqueIds.clear();
        this.deletedNsUniqueIds.clear();
    }

    private String createProfileDN(String id) throws EProfileException {
        if (id == null) {
            throw new EProfileException("CMS_PROFILE_ID_NOT_FOUND");
        }
        return "cn=" + id + "," + this.profileContainerDNString;
    }

    private void ensureProfilesOU(LDAPConnection conn) throws LDAPException {
        block2: {
            try {
                conn.search(this.profileContainerDNString, 0, "(objectclass=*)", null, false);
            }
            catch (LDAPException e) {
                if (e.getLDAPResultCode() != 32) break block2;
                logger.info("Adding LDAP certificate profiles container");
                LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("objectClass", "organizationalUnit"), new LDAPAttribute("ou", "certificateProfiles")};
                LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
                LDAPEntry entry = new LDAPEntry(this.profileContainerDNString, attrSet);
                conn.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int op = 15;
        LDAPPersistSearchControl persistCtrl = new LDAPPersistSearchControl(op, false, true, true);
        LDAPConnection conn = null;
        logger.info("Profile change monitor: starting.");
        while (!this.stopped) {
            try {
                conn = this.dbFactory.getConn();
                this.ensureProfilesOU(conn);
                LDAPSearchConstraints cons = conn.getSearchConstraints();
                cons.setServerControls((LDAPControl)persistCtrl);
                cons.setBatchSize(1);
                cons.setServerTimeLimit(0);
                String[] attrs = new String[]{"*", "entryUSN", "nsUniqueId", "numSubordinates"};
                LDAPSearchResults results = conn.search(this.profileContainerDNString, 2, "(objectclass=*)", attrs, false, cons);
                this.loader.startLoading();
                this.forgetAllProfiles();
                while (!this.stopped && results.hasMoreElements()) {
                    LDAPEntry entry = results.next();
                    DN entryDN = new DN(entry.getDN());
                    if (entryDN.countRDNs() == this.profileContainerDN.countRDNs()) {
                        this.loader.setNumItems(Integer.valueOf(entry.getAttribute("numSubordinates").getStringValueArray()[0]));
                        continue;
                    }
                    if (entryDN.countRDNs() > this.profileContainerDN.countRDNs() + 1) continue;
                    String[] objectClasses = entry.getAttribute("objectClass").getStringValueArray();
                    if (!Arrays.asList(objectClasses).contains("certProfile")) {
                        this.loader.increment();
                        continue;
                    }
                    LDAPEntryChangeControl changeControl = (LDAPEntryChangeControl)LDAPUtil.getControl(LDAPEntryChangeControl.class, (LDAPControl[])results.getResponseControls());
                    logger.debug("Profile change monitor: Processed change controls.");
                    if (changeControl != null) {
                        int changeType = changeControl.getChangeType();
                        switch (changeType) {
                            case 1: {
                                logger.debug("Profile change monitor: ADD");
                                this.readProfile(entry);
                                break;
                            }
                            case 2: {
                                logger.debug("Profile change monitor: DELETE");
                                this.handleDELETE(entry);
                                break;
                            }
                            case 4: {
                                logger.debug("Profile change monitor: MODIFY");
                                this.readProfile(entry);
                                break;
                            }
                            case 8: {
                                logger.debug("Profile change monitor: MODDN");
                                this.handleMODDN(new DN(changeControl.getPreviousDN()), entry);
                                break;
                            }
                            default: {
                                logger.warn("Profile change monitor: unknown change type: " + changeType);
                                break;
                            }
                        }
                        continue;
                    }
                    logger.debug("Profile change monitor: immediate result");
                    this.readProfile(entry);
                    this.loader.increment();
                }
            }
            catch (ELdapException e) {
                logger.warn("Profile change monitor: failed to get LDAPConnection. Retrying in 1 second.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (LDAPException e) {
                logger.error("Profile change monitor: Caught exception: " + e, (Throwable)e);
            }
            finally {
                if (conn == null) continue;
                try {
                    this.dbFactory.returnConn(conn);
                    conn = null;
                }
                catch (Exception e) {
                    logger.error("Profile change monitor: Error releasing the LDAPConnection" + e, (Throwable)e);
                }
            }
        }
        logger.info("Profile change monitor: stopping.");
    }
}

