/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.profile;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileConfig;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.profile.AbstractProfileSubsystem;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSubsystem
extends AbstractProfileSubsystem {
    public static Logger logger = LoggerFactory.getLogger(ProfileSubsystem.class);
    public static final String ID = "profile";
    private static final String PROP_LIST = "list";
    private static final String PROP_CLASS_ID = "class_id";

    public void init(ConfigStore config) throws Exception {
        logger.debug("ProfileSubsystem: initialization");
        PluginRegistry registry = this.engine.getPluginRegistry();
        this.mConfig = config;
        String ids = config.getString(PROP_LIST, "");
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken();
            logger.info("ProfileSubsystem: Loading profile " + id);
            ConfigStore subStore = config.getSubStore(id, ConfigStore.class);
            String classid = subStore.getString(PROP_CLASS_ID);
            logger.debug("- class ID: " + classid);
            PluginInfo info = registry.getPluginInfo(ID, classid);
            if (info == null) {
                throw new EBaseException("Missing plugin info: " + classid);
            }
            logger.debug("- class name: " + info.getClassName());
            String configPath = CMS.getInstanceDir() + "/ca/profiles/ca/" + id + ".cfg";
            logger.debug("- config: " + configPath);
            this.createProfile(id, classid, info.getClassName(), configPath, false);
        }
        logger.debug("Registered profiles:");
        Enumeration<String> ee = this.getProfileIds();
        while (ee.hasMoreElements()) {
            String id = ee.nextElement();
            logger.debug("- " + id);
        }
    }

    public Profile createProfile(String id, String classid, String className) throws EProfileException {
        return this.createProfile(id, classid, className, null, true);
    }

    private Profile createProfile(String id, String classid, String className, String configPath, boolean isNew) throws EProfileException {
        logger.debug("ProfileSubsystem: Creating " + id + " profile");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        PluginRegistry registry = engine.getPluginRegistry();
        if (configPath == null) {
            configPath = CMS.getInstanceDir() + "/ca/profiles/ca/" + id + ".cfg";
        }
        logger.debug("- config: " + (String)configPath);
        try {
            File file = new File((String)configPath);
            file.createNewFile();
            FileConfigStorage storage = new FileConfigStorage((String)configPath);
            ProfileConfig profileConfig = new ProfileConfig((ConfigStorage)storage);
            profileConfig.load();
            logger.debug("ProfileSubsystem: Initializing " + className);
            Profile profile = (Profile)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            profile.setId(id);
            profile.init(engineConfig, registry, profileConfig);
            this.mProfiles.put(id, profile);
            this.mProfileClassIds.put(id, classid);
            if (isNew) {
                this.createProfileConfig(id, classid);
            }
            return profile;
        }
        catch (Exception e) {
            logger.warn("Unable to create profile: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void deleteProfile(String id) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        String configPath = CMS.getInstanceDir() + "/ca/profiles/ca/" + id + ".cfg";
        logger.debug("- config: " + configPath);
        if (this.isProfileEnable(id)) {
            throw new EProfileException("CMS_PROFILE_DELETE_ENABLEPROFILE");
        }
        String ids = "";
        try {
            ids = this.mConfig.getString(PROP_LIST, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(ids, ",");
        StringBuffer list = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (element.equals(id)) continue;
            list.append(element + ",");
        }
        if (list.length() != 0) {
            list.deleteCharAt(list.length() - 1);
        }
        this.mConfig.putString(PROP_LIST, list.toString());
        this.mConfig.removeSubStore(id);
        File file1 = new File(configPath);
        if (!file1.delete()) {
            logger.warn("ProfileSubsystem: Unable to delete configuration: " + configPath);
        }
        this.mProfiles.remove(id);
        this.mProfileClassIds.remove(id);
        try {
            cs.commit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createProfileConfig(String id, String classId) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        try {
            if (this.mProfiles.size() > 0) {
                this.mConfig.putString(PROP_LIST, this.mConfig.getString(PROP_LIST) + "," + id);
            } else {
                this.mConfig.putString(PROP_LIST, id);
            }
            this.mConfig.putString(id + ".class_id", classId);
            cs.commit(true);
        }
        catch (EBaseException e) {
            logger.warn("Unable to create profile config: " + e.getMessage(), (Throwable)e);
        }
    }

    public void startup() throws EBaseException {
        logger.debug("ProfileSubsystem: startup");
    }

    public void shutdown() {
        this.mProfiles.clear();
        this.mProfileClassIds.clear();
    }
}

