/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Logger {
    public static final String IPOJO_LOG_LEVEL = "ipojo.log.level";
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private BundleContext m_context;
    private String m_name;
    private int m_level;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public Logger(BundleContext context, String name, int level) {
        this.m_name = name;
        this.m_level = level;
        this.m_context = context;
    }

    public Logger(BundleContext context, String name) {
        this(context, name, Logger.getDefaultLevel(context));
    }

    public void log(int level, String msg) {
        if (this.m_level >= level) {
            this.dispatch(level, msg);
        }
    }

    public void log(int level, String msg, Throwable exception) {
        if (this.m_level >= level) {
            this.dispatch(level, msg, exception);
        }
    }

    private void dispatch(int level, String msg) {
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        LogService log = null;
        if (ref != null) {
            log = (LogService)this.m_context.getService(ref);
        }
        String message = null;
        switch (level) {
            case 4: {
                message = "[" + this.m_name + "] DEBUG: " + msg;
                if (log != null) {
                    log.log(4, message);
                }
                System.err.println(message);
                break;
            }
            case 1: {
                message = "[" + this.m_name + "] ERROR: " + msg;
                if (log != null) {
                    log.log(1, message);
                }
                System.err.println(message);
                break;
            }
            case 3: {
                message = "[" + this.m_name + "] INFO: " + msg;
                if (log != null) {
                    log.log(3, message);
                }
                System.err.println(message);
                break;
            }
            case 2: {
                message = "[" + this.m_name + "] WARNING: " + msg;
                if (log != null) {
                    log.log(2, message);
                }
                System.err.println(message);
                break;
            }
            default: {
                System.err.println("[" + this.m_name + "] UNKNOWN[" + level + "]: " + msg);
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private void dispatch(int level, String msg, Throwable exception) {
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Logger.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        LogService log = null;
        if (ref != null) {
            log = (LogService)this.m_context.getService(ref);
        }
        String message = null;
        switch (level) {
            case 4: {
                message = "[" + this.m_name + "] DEBUG: " + msg;
                if (log != null) {
                    log.log(4, message, exception);
                }
                System.err.println(message);
                exception.printStackTrace();
                break;
            }
            case 1: {
                message = "[" + this.m_name + "] ERROR: " + msg;
                if (log != null) {
                    log.log(1, message, exception);
                }
                System.err.println(message);
                exception.printStackTrace(System.err);
                break;
            }
            case 3: {
                message = "[" + this.m_name + "] INFO: " + msg;
                if (log != null) {
                    log.log(3, message, exception);
                }
                System.err.println(message);
                exception.printStackTrace(System.err);
                break;
            }
            case 2: {
                message = "[" + this.m_name + "] WARNING: " + msg;
                if (log != null) {
                    log.log(2, message, exception);
                }
                System.err.println(message);
                exception.printStackTrace(System.err);
                break;
            }
            default: {
                System.err.println("[" + this.m_name + "] UNKNOWN[" + level + "]: " + msg);
                exception.printStackTrace();
            }
        }
        if (log != null) {
            this.m_context.ungetService(ref);
        }
    }

    private static int getDefaultLevel(BundleContext context) {
        String level = context.getProperty(IPOJO_LOG_LEVEL);
        if (level == null) {
            String key = IPOJO_LOG_LEVEL.replace('.', '-');
            level = (String)context.getBundle().getHeaders().get(key);
        }
        if (level != null) {
            if (level.equalsIgnoreCase("info")) {
                return 3;
            }
            if (level.equalsIgnoreCase("debug")) {
                return 4;
            }
            if (level.equalsIgnoreCase("warning")) {
                return 2;
            }
            if (level.equalsIgnoreCase("error")) {
                return 1;
            }
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

