/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.asian;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.arguments.ContinuousAveragingAsianOptionArguments;
import org.jquantlib.pricingengines.asian.ContinuousAveragingAsianOptionEngine;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;

public class AnalyticContinuousGeometricAveragePriceasianEngine
extends ContinuousAveragingAsianOptionEngine {
    @Override
    public void calculate() {
        if (((ContinuousAveragingAsianOptionArguments)this.arguments).averageType != AverageType.Geometric) {
            throw new IllegalArgumentException("not a geometric average option");
        }
        if (((ContinuousAveragingAsianOptionArguments)this.arguments).exercise.type() != Exercise.Type.EUROPEAN) {
            throw new IllegalArgumentException("not an European Option");
        }
        Date exercise = ((ContinuousAveragingAsianOptionArguments)this.arguments).exercise.lastDate();
        if (!(((ContinuousAveragingAsianOptionArguments)this.arguments).payoff instanceof PlainVanillaPayoff)) {
            throw new IllegalArgumentException("non-plain payoff given");
        }
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((ContinuousAveragingAsianOptionArguments)this.arguments).payoff;
        if (!(((ContinuousAveragingAsianOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new IllegalArgumentException("Black-Scholes process required");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((ContinuousAveragingAsianOptionArguments)this.arguments).stochasticProcess;
        double volatility = process.blackVolatility().getLink().blackVol(exercise, payoff.strike());
        double variance = process.blackVolatility().getLink().blackVariance(exercise, payoff.strike());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(exercise);
        DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
        DayCounter divdc = process.dividendYield().getLink().dayCounter();
        DayCounter voldc = process.blackVolatility().getLink().dayCounter();
        double dividendYield = 0.5 * (process.riskFreeRate().getLink().zeroRate(exercise, rfdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate() + process.dividendYield().getLink().zeroRate(exercise, divdc, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate() + volatility * volatility / 6.0);
        double t_q = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), exercise);
        double dividendDiscount = Math.exp(-dividendYield * t_q);
        double spot = process.stateVariable().getLink().evaluate();
        double forward = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forward, Math.sqrt(variance / 3.0), riskFreeDiscount);
        ((OneAssetOptionResults)this.results).value = black.value();
        ((OneAssetOptionResults)this.results).delta = black.delta(spot);
        ((OneAssetOptionResults)this.results).gamma = black.gamma(spot);
        ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(t_q) / 2.0;
        double t_r = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((ContinuousAveragingAsianOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).rho = black.rho(t_r) + 0.5 * black.dividendRho(t_q);
        double t_v = voldc.yearFraction(process.blackVolatility().getLink().referenceDate(), ((ContinuousAveragingAsianOptionArguments)this.arguments).exercise.lastDate());
        ((OneAssetOptionResults)this.results).vega = black.vega(t_v) / Math.sqrt(3.0) + black.dividendRho(t_q) * volatility / 6.0;
        ((OneAssetOptionResults)this.results).theta = black.theta(spot, t_v);
    }
}

