/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;

public class InterestRate {
    private double rate;
    private DayCounter dc;
    private Compounding compound;
    private boolean freqMakesSense;
    private int freq;

    public InterestRate() {
        this.rate = 0.0;
    }

    public InterestRate(double r, DayCounter dc, Compounding comp) {
        this(r, dc, comp, Frequency.ANNUAL);
    }

    public InterestRate(double r, DayCounter dc, Compounding comp, Frequency freq) {
        this.rate = r;
        this.dc = dc;
        this.compound = comp;
        this.freqMakesSense = false;
        if (this.compound == Compounding.COMPOUNDED || this.compound == Compounding.SIMPLE_THEN_COMPOUNDED) {
            this.freqMakesSense = true;
            if (freq == Frequency.ONCE || freq == Frequency.NO_FREQUENCY) {
                throw new IllegalArgumentException("frequency not allowed for this interest rate");
            }
            this.freq = freq.toInteger();
        }
    }

    public final double compoundFactor(double time) {
        double t = time;
        if (t < 0.0) {
            throw new IllegalArgumentException("negative time not allowed");
        }
        if (this.rate < 0.0) {
            throw new IllegalArgumentException("null interest rate");
        }
        double r = this.rate;
        if (this.compound == Compounding.SIMPLE) {
            return 1.0 + r * t;
        }
        if (this.compound == Compounding.COMPOUNDED) {
            return Math.pow(1.0 + r / (double)this.freq, (double)this.freq * t);
        }
        if (this.compound == Compounding.CONTINUOUS) {
            return Math.exp(r * t);
        }
        if (this.compound == Compounding.SIMPLE_THEN_COMPOUNDED) {
            if (t < 1.0 / (double)this.freq) {
                return 1.0 + r * t;
            }
            return Math.pow(1.0 + r / (double)this.freq, (double)this.freq * t);
        }
        throw new IllegalArgumentException("unknown compounding convention");
    }

    public final DayCounter dayCounter() {
        return this.dc;
    }

    public final Compounding compounding() {
        return this.compound;
    }

    public final Frequency frequency() {
        return this.freqMakesSense ? Frequency.valueOf(this.freq) : Frequency.NO_FREQUENCY;
    }

    public final double discountFactor(double t) {
        double factor = this.compoundFactor(t);
        return 1.0 / factor;
    }

    public final double discountFactor(Date d1, Date d2) {
        return this.discountFactor(d1, d2, Date.NULL_DATE);
    }

    public final double discountFactor(Date d1, Date d2, Date refStart) {
        return this.discountFactor(d1, d2, refStart, Date.NULL_DATE);
    }

    public final double discountFactor(Date d1, Date d2, Date refStart, Date refEnd) {
        double t = this.dc.yearFraction(d1, d2, refStart, refEnd);
        return this.discountFactor(t);
    }

    public final InterestRate equivalentRate(double t, Compounding comp) {
        return this.equivalentRate(t, comp, Frequency.ANNUAL);
    }

    public final InterestRate equivalentRate(double t, Compounding comp, Frequency freq) {
        return InterestRate.impliedRate(this.compoundFactor(t), t, this.dc, comp, freq);
    }

    public final InterestRate equivalentRate(Date d1, Date d2, DayCounter resultDC, Compounding comp) {
        return this.equivalentRate(d1, d2, resultDC, comp, Frequency.ANNUAL);
    }

    public final InterestRate equivalentRate(Date d1, Date d2, DayCounter resultDC, Compounding comp, Frequency freq) {
        if (d1.le(d2)) {
            throw new IllegalArgumentException("d1 (" + d1 + ") later than or equal to d2 (" + d2 + ")");
        }
        double t1 = this.dc.yearFraction(d1, d2);
        double t2 = resultDC.yearFraction(d1, d2);
        return InterestRate.impliedRate(this.compoundFactor(t1), t2, resultDC, comp, freq);
    }

    public static InterestRate impliedRate(double c, double time, DayCounter resultDC, Compounding comp, Frequency freq) {
        double rate;
        double t = time;
        double f = freq.toInteger();
        if (c <= 0.0) {
            throw new IllegalArgumentException("positive compound factor required");
        }
        if (t <= 0.0) {
            throw new IllegalArgumentException("positive time required");
        }
        switch (comp) {
            case SIMPLE: {
                rate = (c - 1.0) / t;
                break;
            }
            case COMPOUNDED: {
                rate = (Math.pow(c, 1.0 / (f * t)) - 1.0) * f;
                break;
            }
            case CONTINUOUS: {
                rate = Math.log(c) / t;
                break;
            }
            case SIMPLE_THEN_COMPOUNDED: {
                if (t <= 1.0 / f) {
                    rate = (c - 1.0) / t;
                    break;
                }
                rate = (Math.pow(c, 1.0 / (f * t)) - 1.0) * f;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compounding convention (" + (Object)((Object)comp) + ")");
            }
        }
        return new InterestRate(rate, resultDC, comp, freq);
    }

    public static InterestRate impliedRate(double compound, double t, DayCounter resultDC, Compounding comp) {
        return InterestRate.impliedRate(compound, t, resultDC, comp, Frequency.ANNUAL);
    }

    public static InterestRate impliedRate(double compound, Date d1, Date d2, DayCounter resultDC, Compounding comp) {
        return InterestRate.impliedRate(compound, d1, d2, resultDC, comp, Frequency.ANNUAL);
    }

    public static InterestRate impliedRate(double compound, Date d1, Date d2, DayCounter resultDC, Compounding comp, Frequency freq) {
        if (d2.le(d1)) {
            throw new IllegalArgumentException("d1 (" + d1 + ") later than or equal to d2 (" + d2 + ")");
        }
        double t = resultDC.yearFraction(d1, d2);
        return InterestRate.impliedRate(compound, t, resultDC, comp, freq);
    }

    public String toString() {
        if (this.rate == 0.0) {
            return "null interest rate";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.rate).append(' ').append(this.dc).append(' ');
        if (this.compound == Compounding.SIMPLE) {
            sb.append("simple compounding");
        } else if (this.compound == Compounding.COMPOUNDED) {
            if (this.freq == Frequency.NO_FREQUENCY.toInteger() || this.freq == Frequency.ONCE.toInteger()) {
                throw new IllegalArgumentException(this.freq + " frequency not allowed for this interest rate");
            }
            sb.append(this.freq + " compounding");
        } else if (this.compound == Compounding.CONTINUOUS) {
            sb.append("continuous compounding");
        } else if (this.compound == Compounding.SIMPLE_THEN_COMPOUNDED) {
            if (this.freq == Frequency.NO_FREQUENCY.toInteger() || this.freq == Frequency.ONCE.toInteger()) {
                throw new IllegalArgumentException(this.freq + " frequency not allowed for this interest rate");
            }
            sb.append("simple compounding up to " + 12 / this.freq + " months, then " + this.freq + " compounding");
        } else {
            throw new IllegalArgumentException("unknown compounding convention (" + (Object)((Object)this.compound) + ")");
        }
        return sb.toString();
    }

    public final double rate() {
        return this.rate;
    }
}

